/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.sql.execute.ColumnDef;
import org.netbeans.modules.db.sql.execute.FetchLimitHandler;
import org.netbeans.modules.db.sql.execute.NullValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetTableModelSupport {
    private static Logger LOGGER = Logger.getLogger(ResultSetTableModelSupport.class.getName());
    static final Map<Integer, ColumnTypeDef> TYPE_TO_DEF = new HashMap<Integer, ColumnTypeDef>();
    private static ColumnTypeDef DEFAULT_COLUMN_DEF;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ColumnTypeDef getColumnTypeDef(DatabaseMetaData databaseMetaData, int n) {
        ColumnTypeDef columnTypeDef;
        if (n == 91 && ResultSetTableModelSupport.isOracle(databaseMetaData)) {
            n = 93;
        }
        if ((columnTypeDef = TYPE_TO_DEF.get(n)) != null) {
            return columnTypeDef;
        }
        Class<ResultSetTableModelSupport> clazz = ResultSetTableModelSupport.class;
        synchronized (ResultSetTableModelSupport.class) {
            if (DEFAULT_COLUMN_DEF == null) {
                DEFAULT_COLUMN_DEF = new DefaultColumnDef();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return DEFAULT_COLUMN_DEF;
        }
    }

    public static List<ColumnDef> createColumnDefs(DatabaseMetaData databaseMetaData, ResultSetMetaData resultSetMetaData) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        ArrayList<ColumnDef> arrayList = new ArrayList<ColumnDef>(n);
        for (int i = 1; i <= n; ++i) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            int n2 = resultSetMetaData.getColumnType(i);
            ColumnTypeDef columnTypeDef = ResultSetTableModelSupport.getColumnTypeDef(databaseMetaData, n2);
            boolean bl = false;
            try {
                bl = resultSetMetaData.isWritable(i) && columnTypeDef.isWritable();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ColumnDef columnDef = new ColumnDef(resultSetMetaData.getColumnName(i), resultSetMetaData.getColumnLabel(i), bl, columnTypeDef.getColumnClass());
            arrayList.add(columnDef);
        }
        return arrayList;
    }

    private static boolean isOracle(DatabaseMetaData databaseMetaData) {
        try {
            return "Oracle".equals(databaseMetaData.getDatabaseProductName());
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.WARNING, "Unable to obtain database product name", sQLException);
            return false;
        }
    }

    public static List<List<Object>> retrieveRows(DatabaseMetaData databaseMetaData, ResultSet resultSet, ResultSetMetaData resultSetMetaData, FetchLimitHandler fetchLimitHandler) throws SQLException, IOException {
        ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>();
        int n = resultSetMetaData.getColumnCount();
        int n2 = fetchLimitHandler.getFetchLimit();
        while (resultSet.next()) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            int n3 = arrayList.size();
            if (n2 > 0 && n3 >= n2 && (n2 = fetchLimitHandler.fetchLimitReached(n3)) != 0 && n2 <= n3) break;
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (int i = 1; i <= n; ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    return null;
                }
                int n4 = resultSetMetaData.getColumnType(i);
                ColumnTypeDef columnTypeDef = ResultSetTableModelSupport.getColumnTypeDef(databaseMetaData, n4);
                Object object = columnTypeDef.getColumnValue(resultSet, i);
                arrayList2.add(object != null ? object : NullValue.getDefault());
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    static {
        GenericWritableColumnDef genericWritableColumnDef = new GenericWritableColumnDef(Boolean.class);
        TYPE_TO_DEF.put(16, genericWritableColumnDef);
        TYPE_TO_DEF.put(-7, genericWritableColumnDef);
        GenericWritableColumnDef genericWritableColumnDef2 = new GenericWritableColumnDef(Integer.class);
        TYPE_TO_DEF.put(-6, genericWritableColumnDef2);
        TYPE_TO_DEF.put(5, genericWritableColumnDef2);
        TYPE_TO_DEF.put(4, genericWritableColumnDef2);
        GenericWritableColumnDef genericWritableColumnDef3 = new GenericWritableColumnDef(String.class);
        TYPE_TO_DEF.put(1, genericWritableColumnDef3);
        TYPE_TO_DEF.put(12, genericWritableColumnDef3);
        TYPE_TO_DEF.put(-15, genericWritableColumnDef3);
        TYPE_TO_DEF.put(-9, genericWritableColumnDef3);
        GenericWritableColumnDef genericWritableColumnDef4 = new GenericWritableColumnDef(Long.class);
        TYPE_TO_DEF.put(-5, genericWritableColumnDef4);
        GenericWritableColumnDef genericWritableColumnDef5 = new GenericWritableColumnDef(Double.class);
        TYPE_TO_DEF.put(6, genericWritableColumnDef5);
        TYPE_TO_DEF.put(8, genericWritableColumnDef5);
        GenericWritableColumnDef genericWritableColumnDef6 = new GenericWritableColumnDef(BigDecimal.class);
        TYPE_TO_DEF.put(7, genericWritableColumnDef6);
        TYPE_TO_DEF.put(2, genericWritableColumnDef6);
        TYPE_TO_DEF.put(3, genericWritableColumnDef6);
        GenericWritableColumnDef genericWritableColumnDef7 = new GenericWritableColumnDef(Date.class);
        TYPE_TO_DEF.put(91, genericWritableColumnDef7);
        ColumnTypeDef columnTypeDef = new ColumnTypeDef(){

            public boolean isWritable() {
                return true;
            }

            public Class getColumnClass() {
                return Time.class;
            }

            public Object getColumnValue(ResultSet resultSet, int n) throws SQLException, IOException {
                return resultSet.getTime(n);
            }
        };
        TYPE_TO_DEF.put(92, columnTypeDef);
        TYPE_TO_DEF.put(93, new ColumnTypeDef(){

            public boolean isWritable() {
                return true;
            }

            public Class getColumnClass() {
                return Timestamp.class;
            }

            public Object getColumnValue(ResultSet resultSet, int n) throws SQLException, IOException {
                return resultSet.getTimestamp(n);
            }
        });
        ColumnTypeDef columnTypeDef2 = new ColumnTypeDef(){

            public boolean isWritable() {
                return false;
            }

            public Class getColumnClass() {
                return Object.class;
            }

            public Object getColumnValue(ResultSet resultSet, int n) throws SQLException, IOException {
                return BinaryColumnValue.forBinaryColumn(resultSet, n);
            }
        };
        TYPE_TO_DEF.put(-2, columnTypeDef2);
        TYPE_TO_DEF.put(-3, columnTypeDef2);
        TYPE_TO_DEF.put(-4, columnTypeDef2);
        ColumnTypeDef columnTypeDef3 = new ColumnTypeDef(){

            public boolean isWritable() {
                return false;
            }

            public Class getColumnClass() {
                return Object.class;
            }

            public Object getColumnValue(ResultSet resultSet, int n) throws SQLException, IOException {
                return BinaryColumnValue.forBlobColumn(resultSet, n);
            }
        };
        TYPE_TO_DEF.put(2004, columnTypeDef3);
        ColumnTypeDef columnTypeDef4 = new ColumnTypeDef(){

            public boolean isWritable() {
                return false;
            }

            public Class getColumnClass() {
                return Object.class;
            }

            public Object getColumnValue(ResultSet resultSet, int n) throws SQLException, IOException {
                return LongVarCharColumnValue.forCharColumn(resultSet, n);
            }
        };
        TYPE_TO_DEF.put(-1, columnTypeDef4);
        TYPE_TO_DEF.put(-16, columnTypeDef4);
        TYPE_TO_DEF.put(2009, columnTypeDef4);
        ColumnTypeDef columnTypeDef5 = new ColumnTypeDef(){

            public boolean isWritable() {
                return false;
            }

            public Class getColumnClass() {
                return Object.class;
            }

            public Object getColumnValue(ResultSet resultSet, int n) throws SQLException, IOException {
                return LongVarCharColumnValue.forClobColumn(resultSet, n);
            }
        };
        TYPE_TO_DEF.put(2005, columnTypeDef5);
        TYPE_TO_DEF.put(2011, columnTypeDef5);
        ColumnTypeDef columnTypeDef6 = new ColumnTypeDef(){

            public boolean isWritable() {
                return false;
            }

            public Class getColumnClass() {
                return Object.class;
            }

            public Object getColumnValue(ResultSet resultSet, int n) throws SQLException {
                return resultSet.getObject(n);
            }
        };
        TYPE_TO_DEF.put(0, columnTypeDef6);
        TYPE_TO_DEF.put(1111, columnTypeDef6);
        TYPE_TO_DEF.put(2000, columnTypeDef6);
        TYPE_TO_DEF.put(2001, columnTypeDef6);
        TYPE_TO_DEF.put(2002, columnTypeDef6);
        TYPE_TO_DEF.put(2003, columnTypeDef6);
        TYPE_TO_DEF.put(2006, columnTypeDef6);
        TYPE_TO_DEF.put(70, columnTypeDef6);
        TYPE_TO_DEF.put(-8, genericWritableColumnDef2);
    }

    private static final class BinaryColumnValue {
        private static final int COUNT = 100;
        private String data;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static BinaryColumnValue forBinaryColumn(ResultSet resultSet, int n) throws SQLException, IOException {
            InputStream inputStream = resultSet.getBinaryStream(n);
            if (inputStream == null) {
                return null;
            }
            try {
                BinaryColumnValue binaryColumnValue = new BinaryColumnValue(inputStream);
                return binaryColumnValue;
            }
            finally {
                inputStream.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static BinaryColumnValue forBlobColumn(ResultSet resultSet, int n) throws SQLException, IOException {
            Blob blob = resultSet.getBlob(n);
            if (blob == null) {
                return null;
            }
            InputStream inputStream = blob.getBinaryStream();
            if (inputStream == null) {
                return null;
            }
            try {
                BinaryColumnValue binaryColumnValue = new BinaryColumnValue(inputStream);
                return binaryColumnValue;
            }
            finally {
                inputStream.close();
            }
        }

        private BinaryColumnValue(InputStream inputStream) throws SQLException, IOException {
            byte[] byArray = new byte[100];
            int n = inputStream.read(byArray, 0, byArray.length);
            if (n > 0) {
                StringBuffer stringBuffer = new StringBuffer(2 + 2 * n);
                stringBuffer.append("0x");
                for (int i = 0; i < n; ++i) {
                    int n2 = byArray[i];
                    if (n2 < 0) {
                        n2 += 256;
                    }
                    if (n2 < 16) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(Integer.toHexString(n2).toUpperCase());
                }
                if (inputStream.read() != -1) {
                    stringBuffer.append("...");
                }
                this.data = stringBuffer.toString();
            } else {
                this.data = "";
            }
        }

        public String toString() {
            return this.data;
        }
    }

    private static final class LongVarCharColumnValue {
        private static final int COUNT = 100;
        private String data;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static LongVarCharColumnValue forCharColumn(ResultSet resultSet, int n) throws SQLException, IOException {
            Reader reader = resultSet.getCharacterStream(n);
            if (reader == null) {
                return null;
            }
            try {
                LongVarCharColumnValue longVarCharColumnValue = new LongVarCharColumnValue(reader);
                return longVarCharColumnValue;
            }
            finally {
                reader.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static LongVarCharColumnValue forClobColumn(ResultSet resultSet, int n) throws SQLException, IOException {
            Clob clob = resultSet.getClob(n);
            if (clob == null) {
                return null;
            }
            Reader reader = clob.getCharacterStream();
            if (reader == null) {
                return null;
            }
            try {
                LongVarCharColumnValue longVarCharColumnValue = new LongVarCharColumnValue(reader);
                return longVarCharColumnValue;
            }
            finally {
                reader.close();
            }
        }

        private LongVarCharColumnValue(Reader reader) throws SQLException, IOException {
            char[] cArray = new char[100];
            int n = reader.read(cArray, 0, cArray.length);
            if (n >= 0) {
                this.data = new String(cArray, 0, n);
                if (reader.read() != -1) {
                    this.data = this.data + "...";
                }
            } else {
                this.data = "";
            }
        }

        public String toString() {
            return this.data;
        }
    }

    private static final class DefaultColumnDef
    implements ColumnTypeDef {
        private DefaultColumnDef() {
        }

        public boolean isWritable() {
            return false;
        }

        public Class getColumnClass() {
            return Object.class;
        }

        public Object getColumnValue(ResultSet resultSet, int n) throws SQLException, IOException {
            return resultSet.getObject(n);
        }
    }

    private static final class GenericWritableColumnDef
    implements ColumnTypeDef {
        private Class columnClass;

        public GenericWritableColumnDef(Class clazz) {
            this.columnClass = clazz;
        }

        public boolean isWritable() {
            return true;
        }

        public Class getColumnClass() {
            return this.columnClass;
        }

        public Object getColumnValue(ResultSet resultSet, int n) throws SQLException, IOException {
            return resultSet.getObject(n);
        }
    }

    private static interface ColumnTypeDef {
        public boolean isWritable();

        public Class getColumnClass();

        public Object getColumnValue(ResultSet var1, int var2) throws SQLException, IOException;
    }
}

