/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.db.sql.execute.NullValue;
import org.netbeans.modules.db.sql.execute.SQLExecutionResults;
import org.netbeans.modules.db.sql.execute.ui.SQLResultPanelModel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExClipboard;

public class SQLResultPanel
extends JPanel {
    private SQLExecutionResults executionResults;
    private JMenuItem copyCellValueMenuItem;
    private JMenuItem copyRowValuesMenuItem;
    private JScrollPane resultScrollPane;
    private JTable resultTable;
    private JPopupMenu tablePopupMenu;

    public SQLResultPanel() {
        this.initComponents();
    }

    public void setModel(SQLResultPanelModel sQLResultPanelModel) {
        AbstractTableModel abstractTableModel = null;
        abstractTableModel = sQLResultPanelModel != null ? (sQLResultPanelModel.getResultSetModel() != null ? sQLResultPanelModel.getResultSetModel() : new DefaultTableModel(0, 0)) : new DefaultTableModel(0, 0);
        this.resultTable.setModel(abstractTableModel);
    }

    private void setClipboard(String string) {
        ExClipboard exClipboard = (ExClipboard)Lookup.getDefault().lookup(ExClipboard.class);
        StringSelection stringSelection = new StringSelection(string);
        exClipboard.setContents((Transferable)stringSelection, (ClipboardOwner)stringSelection);
    }

    private void initComponents() {
        this.tablePopupMenu = new JPopupMenu();
        this.copyCellValueMenuItem = new JMenuItem();
        this.copyRowValuesMenuItem = new JMenuItem();
        this.resultScrollPane = new JScrollPane();
        this.resultTable = new SQLResultTable();
        this.copyCellValueMenuItem.setText(NbBundle.getMessage(SQLResultPanel.class, (String)"LBL_CopyCellValue"));
        this.copyCellValueMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SQLResultPanel.this.copyCellValueMenuItemActionPerformed(actionEvent);
            }
        });
        this.tablePopupMenu.add(this.copyCellValueMenuItem);
        this.copyCellValueMenuItem.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLResultPanel.class, (String)"ACSD_CopyCellValue"));
        this.copyRowValuesMenuItem.setText(NbBundle.getMessage(SQLResultPanel.class, (String)"LBL_CopyRowValues"));
        this.copyRowValuesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SQLResultPanel.this.copyRowValuesMenuItemActionPerformed(actionEvent);
            }
        });
        this.tablePopupMenu.add(this.copyRowValuesMenuItem);
        this.copyRowValuesMenuItem.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLResultPanel.class, (String)"ACSD_CopyRowValues"));
        this.setLayout(new BorderLayout());
        this.resultScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.resultScrollPane.getViewport().setBackground(UIManager.getDefaults().getColor("Table.background"));
        this.resultTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.resultTable.setAutoResizeMode(0);
        this.resultTable.setOpaque(false);
        this.resultTable.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                SQLResultPanel.this.resultTableMouseReleased(mouseEvent);
            }
        });
        this.resultScrollPane.setViewportView(this.resultTable);
        this.add((Component)this.resultScrollPane, "Center");
    }

    private void copyRowValuesMenuItemActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.resultTable.getSelectedRows();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < this.resultTable.getColumnCount(); ++j) {
                if (j > 0) {
                    stringBuffer.append('\t');
                }
                Object object = this.resultTable.getValueAt(nArray[i], j);
                stringBuffer.append(object.toString());
            }
            stringBuffer.append('\n');
        }
        this.setClipboard(stringBuffer.toString());
    }

    private void copyCellValueMenuItemActionPerformed(ActionEvent actionEvent) {
        Object object = this.resultTable.getValueAt(this.resultTable.getSelectedRow(), this.resultTable.getSelectedColumn());
        this.setClipboard(object.toString());
    }

    private void resultTableMouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 3) {
            return;
        }
        int n = this.resultTable.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.resultTable.columnAtPoint(mouseEvent.getPoint());
        boolean bl = false;
        int[] nArray = this.resultTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.resultTable.changeSelection(n, n2, false, false);
        }
        this.tablePopupMenu.show(this.resultTable, mouseEvent.getX(), mouseEvent.getY());
    }

    static final class SQLResultTable
    extends JTable {
        private final NullRenderer nullRenderer = new NullRenderer();

        public SQLResultTable() {
            this.setDefaultRenderer(String.class, new StringRenderer());
            this.setDefaultRenderer(Timestamp.class, new DateTimeRenderer());
            this.setDefaultRenderer(Time.class, new TimeRenderer());
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            Object object = this.getValueAt(n, n2);
            if (object instanceof NullValue) {
                return this.nullRenderer;
            }
            return super.getCellRenderer(n, n2);
        }

        private static final class StringRenderer
        extends DefaultTableCellRenderer.UIResource {
            public StringRenderer() {
                super.putClientProperty("html.disable", Boolean.TRUE);
            }
        }

        private static final class NullRenderer
        extends DefaultTableCellRenderer.UIResource {
            private NullRenderer() {
            }

            public void setValue(Object object) {
                this.setText(((NullValue)object).toString());
            }
        }

        private static final class TimeRenderer
        extends DefaultTableCellRenderer.UIResource {
            DateFormat formatter;

            public void setValue(Object object) {
                if (this.formatter == null) {
                    this.formatter = DateFormat.getTimeInstance();
                }
                this.setText(object == null ? "" : this.formatter.format(object));
            }
        }

        private static final class DateTimeRenderer
        extends DefaultTableCellRenderer.UIResource {
            DateFormat formatter;

            public void setValue(Object object) {
                if (this.formatter == null) {
                    this.formatter = DateFormat.getDateTimeInstance();
                }
                this.setText(object == null ? "" : this.formatter.format(object));
            }
        }
    }
}

