/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.update;

import java.io.File;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class UpdateBuilder
implements Builder {
    public static final String UNKNOWN = ": nothing known about";
    public static final String EXAM_DIR = ": Updating";
    public static final String TO_ADD = ": use `cvs add' to create an entry for";
    public static final String STATES = "U P A R M C ? ";
    public static final String WARNING = ": warning: ";
    public static final String SERVER = "server: ";
    public static final String PERTINENT = "is not (any longer) pertinent";
    public static final String REMOVAL = "for removal";
    public static final String SERVER_SCHEDULING = "server: scheduling";
    private static final String SERVER_SCHEDULING_12 = "update: scheduling `";
    private static final String REMOVAL_12 = "' for removal";
    public static final String CONFLICTS = "rcsmerge: warning: conflicts during merge";
    public static final String NOT_IN_REPOSITORY = "is no longer in the repository";
    private static final String MERGE_SAME = " already contains the differences between";
    private static final String MERGED = "Merging differences between";
    private DefaultFileInfoContainer fileInfoContainer;
    private EventManager eventManager;
    private final String localPath;
    private String diagnostics;
    private String fileMergedOrConflict;

    public UpdateBuilder(EventManager eventManager, String string) {
        this.eventManager = eventManager;
        this.localPath = string;
    }

    public void outputDone() {
        this.fileMergedOrConflict = null;
        if (this.fileInfoContainer != null) {
            if (this.fileInfoContainer.getFile() == null) {
                System.err.println("#65387 CVS: firing invalid event while processing: " + this.diagnostics);
            }
            this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.fileInfoContainer));
            this.fileInfoContainer = null;
        }
    }

    public void parseLine(String string, boolean bl) {
        this.diagnostics = string;
        if (string.indexOf(UNKNOWN) >= 0) {
            this.processUnknownFile(string, string.indexOf(UNKNOWN) + UNKNOWN.length());
        } else if (string.indexOf(TO_ADD) >= 0) {
            this.processUnknownFile(string, string.indexOf(TO_ADD) + TO_ADD.length());
        } else {
            if (string.indexOf(EXAM_DIR) >= 0) {
                return;
            }
            if (string.startsWith(CONFLICTS)) {
                if (this.fileInfoContainer != null) {
                    this.fileInfoContainer.setType("C");
                }
                this.fileMergedOrConflict = "C";
            } else if (string.indexOf(WARNING) >= 0) {
                if (string.indexOf(PERTINENT) > 0) {
                    String string2 = string.substring(string.indexOf(WARNING) + WARNING.length(), string.indexOf(PERTINENT)).trim();
                    this.processNotPertinent(string2);
                }
            } else if (string.indexOf(SERVER_SCHEDULING_12) >= 0) {
                if (string.indexOf(REMOVAL_12) > 0) {
                    String string3 = string.substring(string.indexOf(SERVER_SCHEDULING_12) + SERVER_SCHEDULING_12.length(), string.indexOf(REMOVAL_12)).trim();
                    this.processNotPertinent(string3);
                }
            } else if (string.indexOf(SERVER_SCHEDULING) >= 0) {
                if (string.indexOf(REMOVAL) > 0) {
                    String string4 = string.substring(string.indexOf(SERVER_SCHEDULING) + SERVER_SCHEDULING.length(), string.indexOf(REMOVAL)).trim();
                    this.processNotPertinent(string4);
                }
            } else if (string.indexOf(MERGE_SAME) >= 0) {
                this.ensureExistingFileInfoContainer();
                this.fileInfoContainer.setType("G");
                String string5 = string.substring(0, string.indexOf(MERGE_SAME));
                this.fileInfoContainer.setFile(this.createFile(string5));
                this.outputDone();
            } else if (string.startsWith(MERGED)) {
                this.outputDone();
                this.fileMergedOrConflict = "G";
            } else {
                String string6;
                if (string.indexOf(NOT_IN_REPOSITORY) > 0) {
                    String string7 = string.substring(string.indexOf(SERVER) + SERVER.length(), string.indexOf(NOT_IN_REPOSITORY)).trim();
                    this.processNotPertinent(string7);
                    return;
                }
                if (string.length() > 2 && STATES.indexOf(string6 = string.substring(0, 2)) >= 0) {
                    this.processFile(string);
                    return;
                }
            }
        }
    }

    private File createFile(String string) {
        if (string.length() > 1 && string.charAt(0) == '`' && string.charAt(string.length() - 1) == '\'') {
            string = string.substring(1, string.length() - 1);
        }
        return new File(this.localPath, string);
    }

    private void ensureExistingFileInfoContainer() {
        if (this.fileInfoContainer != null) {
            return;
        }
        this.fileInfoContainer = new DefaultFileInfoContainer();
    }

    private void processUnknownFile(String string, int n) {
        this.outputDone();
        this.fileInfoContainer = new DefaultFileInfoContainer();
        this.fileInfoContainer.setType("?");
        String string2 = string.substring(n).trim();
        this.fileInfoContainer.setFile(this.createFile(string2));
    }

    private void processFile(String string) {
        String string2 = string.substring(2).trim();
        if (string2.startsWith("no file")) {
            string2 = string2.substring(8);
        }
        if (string2.startsWith("./")) {
            string2 = string2.substring(2);
        }
        File file = this.createFile(string2);
        if (this.fileInfoContainer != null) {
            if (this.fileInfoContainer.getFile() == null) {
                this.fileInfoContainer.setFile(file);
            }
            if (file.equals(this.fileInfoContainer.getFile())) {
                if (this.fileInfoContainer.getType().equals("?")) {
                    this.fileInfoContainer = null;
                } else {
                    this.outputDone();
                    return;
                }
            }
        }
        if (this.fileMergedOrConflict != null && string.charAt(0) == 'M') {
            string = this.fileMergedOrConflict;
        }
        this.outputDone();
        this.ensureExistingFileInfoContainer();
        this.fileInfoContainer.setType(string.substring(0, 1));
        this.fileInfoContainer.setFile(file);
    }

    private void processNotPertinent(String string) {
        this.outputDone();
        File file = this.createFile(string);
        this.ensureExistingFileInfoContainer();
        this.fileInfoContainer.setType("Y");
        this.fileInfoContainer.setFile(file);
    }

    public void parseEnhancedMessage(String string, Object object) {
        if (string.equals("Merged_Response_File_Path")) {
            this.ensureExistingFileInfoContainer();
            String string2 = object.toString();
            File file = new File(string2);
            if (!file.equals(this.fileInfoContainer.getFile())) {
                this.fileInfoContainer.setFile(file);
                this.fileInfoContainer.setType("G");
                if (this.fileMergedOrConflict != null) {
                    this.fileInfoContainer.setType(this.fileMergedOrConflict);
                }
            }
            this.outputDone();
        }
    }
}

