/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.io.EOFException;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.SimpleStringPattern;
import org.netbeans.lib.cvsclient.util.StringPattern;

public class WrapperSendResponse
implements Response {
    public static Map parseWrappers(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        SimpleStringPattern simpleStringPattern = new SimpleStringPattern(stringTokenizer.nextToken());
        Map<SimpleStringPattern, KeywordSubstitutionOptions> map = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            if (!string2.equals("-k")) continue;
            int n = string3.indexOf(39);
            int n2 = string3.lastIndexOf(39);
            if (n >= 0 && n2 >= 0) {
                string3 = string3.substring(n + 1, n2);
            }
            KeywordSubstitutionOptions keywordSubstitutionOptions = KeywordSubstitutionOptions.findKeywordSubstOption(string3);
            if (map == null) {
                if (!stringTokenizer.hasMoreTokens()) {
                    map = Collections.singletonMap(simpleStringPattern, keywordSubstitutionOptions);
                    continue;
                }
                map = new LinkedHashMap<SimpleStringPattern, KeywordSubstitutionOptions>();
                map.put(simpleStringPattern, keywordSubstitutionOptions);
                continue;
            }
            map.put(simpleStringPattern, keywordSubstitutionOptions);
        }
        return map;
    }

    public void process(LoggedDataInputStream loggedDataInputStream, ResponseServices responseServices) throws ResponseException {
        try {
            String string = loggedDataInputStream.readLine();
            Map map = WrapperSendResponse.parseWrappers(string);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                StringPattern stringPattern = (StringPattern)iterator.next();
                KeywordSubstitutionOptions keywordSubstitutionOptions = (KeywordSubstitutionOptions)map.get(stringPattern);
                responseServices.addWrapper(stringPattern, keywordSubstitutionOptions);
            }
        }
        catch (EOFException eOFException) {
            throw new ResponseException(eOFException, ResponseException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (IOException iOException) {
            throw new ResponseException(iOException);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new ResponseException(noSuchElementException);
        }
    }

    public boolean isTerminalResponse() {
        return false;
    }
}

