/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import antlr.TokenStream;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTBuilder;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;

public class APTDriverImpl {
    private static Map<String, APTSyncCreator> file2creator = new ConcurrentHashMap<String, APTSyncCreator>();
    private static Map<String, Reference<APTFile>> file2ref2apt = new ConcurrentHashMap<String, Reference<APTFile>>();
    private static Map<String, APTFile> file2apt = new ConcurrentHashMap<String, APTFile>();

    private APTDriverImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static APTFile findAPT(APTFileBuffer aPTFileBuffer, boolean bl) throws IOException {
        File file = aPTFileBuffer.getFile();
        String string = file.getAbsolutePath();
        APTFile aPTFile = APTDriverImpl._getAPTFile(string, bl);
        if (aPTFile == null) {
            APTSyncCreator aPTSyncCreator;
            Map<String, APTSyncCreator> map = file2creator;
            synchronized (map) {
                aPTSyncCreator = file2creator.get(string);
                if (aPTSyncCreator == null) {
                    aPTSyncCreator = new APTSyncCreator();
                    file2creator.put(string, aPTSyncCreator);
                }
            }
            assert (aPTSyncCreator != null);
            aPTFile = aPTSyncCreator.findAPT(aPTFileBuffer, bl);
            map = file2creator;
            synchronized (map) {
                file2creator.remove(string);
            }
        }
        return aPTFile;
    }

    public static void invalidateAPT(APTFileBuffer aPTFileBuffer) {
        File file = aPTFileBuffer.getFile();
        String string = file.getAbsolutePath();
        if (APTTraceFlags.APT_USE_SOFT_REFERENCE) {
            file2ref2apt.remove(string);
        } else {
            file2apt.remove(string);
        }
    }

    public static void invalidateAll() {
        if (APTTraceFlags.APT_USE_SOFT_REFERENCE) {
            file2ref2apt.clear();
        } else {
            file2apt.clear();
        }
    }

    private static APTFile _getAPTFile(String string, boolean bl) {
        Reference<APTFile> reference;
        if (bl) {
            return null;
        }
        APTFile aPTFile = APTTraceFlags.APT_USE_SOFT_REFERENCE ? ((reference = file2ref2apt.get(string)) == null ? null : reference.get()) : file2apt.get(string);
        return aPTFile;
    }

    private static void _putAPTFile(String string, APTFile aPTFile, boolean bl) {
        if (bl) {
            return;
        }
        if (APTTraceFlags.APT_USE_SOFT_REFERENCE) {
            file2ref2apt.put(string, new SoftReference<APTFile>(aPTFile));
        } else {
            file2apt.put(string, aPTFile);
        }
    }

    public static void close() {
        APTDriverImpl.invalidateAll();
    }

    private static class APTSyncCreator {
        private APTFile fullAPT = null;
        private APTFile lightAPT = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized APTFile findAPT(APTFileBuffer aPTFileBuffer, boolean bl) throws IOException {
            File file = aPTFileBuffer.getFile();
            String string = file.getAbsolutePath();
            if (bl && this.fullAPT != null) {
                return this.fullAPT;
            }
            if (!bl && this.lightAPT != null) {
                return this.lightAPT;
            }
            APTFile aPTFile = APTDriverImpl._getAPTFile(string, bl);
            if (aPTFile == null) {
                Reader reader = null;
                try {
                    TokenStream tokenStream;
                    reader = aPTFileBuffer.getReader();
                    if (!bl) {
                        tokenStream = APTTokenStreamBuilder.buildLightTokenStream(string, reader);
                        aPTFile = APTBuilder.buildAPT(string, tokenStream);
                        this.fullAPT = null;
                        if (aPTFile != null) {
                            if (APTTraceFlags.TEST_APT_SERIALIZATION) {
                                APTFile aPTFile2 = (APTFile)APTSerializeUtils.testAPTSerialization(aPTFileBuffer, aPTFile);
                                if (aPTFile2 != null) {
                                    aPTFile = aPTFile2;
                                } else {
                                    System.err.println("error on serialization apt for file " + file.getAbsolutePath());
                                }
                            }
                            this.lightAPT = aPTFile;
                            APTDriverImpl._putAPTFile(string, this.lightAPT, bl);
                        }
                    } else {
                        tokenStream = APTTokenStreamBuilder.buildTokenStream(string, reader);
                        this.fullAPT = aPTFile = APTBuilder.buildAPT(string, tokenStream);
                        if (aPTFile != null) {
                            APTFile aPTFile3;
                            if (APTTraceFlags.TEST_APT_SERIALIZATION) {
                                aPTFile3 = (APTFile)APTSerializeUtils.testAPTSerialization(aPTFileBuffer, aPTFile);
                                if (aPTFile3 != null) {
                                    aPTFile = aPTFile3;
                                } else {
                                    System.err.println("error on serialization apt for file " + file.getAbsolutePath());
                                }
                            }
                            APTDriverImpl._putAPTFile(string, aPTFile, bl);
                            this.lightAPT = aPTFile3 = (APTFile)APTBuilder.buildAPTLight(aPTFile);
                            APTDriverImpl._putAPTFile(string, aPTFile3, bl);
                            if (!bl) {
                                aPTFile = aPTFile3;
                            }
                        }
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {
                            APTUtils.LOG.log(Level.SEVERE, "exception on closing stream", iOException);
                        }
                    }
                }
            }
            return aPTFile;
        }
    }
}

