/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.impl.support.APTHandlersSupportImpl;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;

public class APTPreprocHandlerImpl
implements APTPreprocHandler {
    private boolean compileContext;
    private boolean isValid = true;
    private APTMacroMap macroMap;
    private APTIncludeHandler inclHandler;

    public APTPreprocHandlerImpl(APTMacroMap aPTMacroMap, APTIncludeHandler aPTIncludeHandler, boolean bl) {
        this.macroMap = aPTMacroMap;
        this.inclHandler = aPTIncludeHandler;
        this.compileContext = bl;
    }

    public APTMacroMap getMacroMap() {
        return this.macroMap;
    }

    public APTIncludeHandler getIncludeHandler() {
        return this.inclHandler;
    }

    public APTPreprocHandler.State getState() {
        return this.createStateImpl();
    }

    public void setState(APTPreprocHandler.State state) {
        if (state instanceof StateImpl) {
            ((StateImpl)state).restoreTo(this);
        }
    }

    public void setValid(boolean bl) {
        this.isValid = bl;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isCompileContext() {
        return this.compileContext;
    }

    protected StateImpl createStateImpl() {
        return new StateImpl(this);
    }

    private void setCompileContext(boolean bl) {
        this.compileContext = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.isCompileContext() ? "\nCompile Context" : "\nDefault/Null State");
        stringBuilder.append("\nInclude Info:\n");
        stringBuilder.append(this.inclHandler);
        stringBuilder.append("\nMACROS info:\n");
        stringBuilder.append(this.macroMap);
        return stringBuilder.toString();
    }

    public static final class StateImpl
    implements APTPreprocHandler.State {
        private final APTMacroMap.State macroState;
        final APTIncludeHandler.State inclState;
        private final byte attributes;
        private static final byte COMPILE_CONTEXT_FLAG = 1;
        private static final byte CLEANED_FLAG = 2;
        private static final byte VALID_FLAG = 4;

        private static byte createAttributes(boolean bl, boolean bl2, boolean bl3) {
            byte by = 0;
            by = bl ? (byte)((byte)(by | 1)) : (byte)((byte)(by & 0xFFFFFFFE));
            by = bl2 ? (byte)((byte)(by | 2)) : (byte)((byte)(by & 0xFFFFFFFD));
            by = bl3 ? (byte)((byte)(by | 4)) : (byte)((byte)(by & 0xFFFFFFFB));
            return by;
        }

        protected StateImpl(APTPreprocHandlerImpl aPTPreprocHandlerImpl) {
            this.macroState = aPTPreprocHandlerImpl.getMacroMap() != null ? aPTPreprocHandlerImpl.getMacroMap().getState() : null;
            this.inclState = aPTPreprocHandlerImpl.getIncludeHandler() != null ? aPTPreprocHandlerImpl.getIncludeHandler().getState() : null;
            this.attributes = StateImpl.createAttributes(aPTPreprocHandlerImpl.isCompileContext(), false, aPTPreprocHandlerImpl.isValid());
        }

        private StateImpl(StateImpl stateImpl, boolean bl, boolean bl2, boolean bl3) {
            boolean bl4;
            if (bl && !stateImpl.isCleaned()) {
                this.inclState = APTHandlersSupportImpl.copyIncludeState(stateImpl.inclState, true);
                this.macroState = APTHandlersSupportImpl.createCleanMacroState(stateImpl.macroState);
                bl4 = true;
            } else {
                this.macroState = stateImpl.macroState;
                bl4 = stateImpl.isCleaned();
                this.inclState = stateImpl.inclState;
            }
            this.attributes = StateImpl.createAttributes(bl2, bl4, bl3);
        }

        private void restoreTo(APTPreprocHandlerImpl aPTPreprocHandlerImpl) {
            if (aPTPreprocHandlerImpl.getMacroMap() != null) {
                aPTPreprocHandlerImpl.getMacroMap().setState(this.macroState);
            }
            if (aPTPreprocHandlerImpl.getIncludeHandler() != null) {
                aPTPreprocHandlerImpl.getIncludeHandler().setState(this.inclState);
            }
            aPTPreprocHandlerImpl.setCompileContext(this.isCompileContext());
            aPTPreprocHandlerImpl.setValid(this.isValid());
            if (!this.isValid()) {
                APTUtils.LOG.log(Level.SEVERE, "setting invalid state {0}", new Object[]{this});
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.isCleaned() ? "\nCleaned State;" : "\nNot Cleaned State;");
            stringBuilder.append(this.isCompileContext() ? "Compile Context;" : "Default/Null State;");
            stringBuilder.append(this.isValid() ? "Valid State;" : "Invalid State;");
            stringBuilder.append("\nInclude state Info:\n");
            stringBuilder.append(this.inclState);
            stringBuilder.append("\nMACROS state info:\n");
            stringBuilder.append(this.macroState);
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            StateImpl stateImpl = (StateImpl)object;
            return this.isCompileContext() == stateImpl.isCompileContext() && this.isValid() == stateImpl.isValid() && (this.inclState == null && stateImpl.inclState == null || this.inclState.equals(stateImpl.inclState));
        }

        public int hashCode() {
            int n = 5;
            n = 83 * n + (this.isCompileContext() ? 1 : 0);
            n = 83 * n + (this.isValid() ? 1 : 0);
            n = 83 * n + (this.inclState != null ? this.inclState.hashCode() : 0);
            return n;
        }

        public boolean isCompileContext() {
            return (this.attributes & 1) == 1;
        }

        public boolean isCleaned() {
            return (this.attributes & 2) == 2;
        }

        public boolean isValid() {
            return (this.attributes & 4) == 4;
        }

        APTPreprocHandler.State copy() {
            return new StateImpl(this, this.isCleaned(), this.isCompileContext(), this.isValid());
        }

        APTPreprocHandler.State copyCleaned() {
            return new StateImpl(this, true, this.isCompileContext(), this.isValid());
        }

        APTPreprocHandler.State copyInvalid() {
            return new StateImpl(this, this.isCleaned(), this.isCompileContext(), false);
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeByte(this.attributes);
            APTSerializeUtils.writeIncludeState(this.inclState, dataOutput);
            APTSerializeUtils.writeMacroMapState(this.macroState, dataOutput);
        }

        public StateImpl(DataInput dataInput) throws IOException {
            this.attributes = dataInput.readByte();
            this.inclState = APTSerializeUtils.readIncludeState(dataInput);
            this.macroState = APTSerializeUtils.readMacroMapState(dataInput);
        }
    }
}

