/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.debug.DebugUtils;
import org.netbeans.modules.cnd.apt.impl.support.generated.APTExprParser;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTElif;
import org.netbeans.modules.cnd.apt.structure.APTIf;
import org.netbeans.modules.cnd.apt.structure.APTIfdef;
import org.netbeans.modules.cnd.apt.structure.APTIfndef;
import org.netbeans.modules.cnd.apt.support.APTExpandedStream;
import org.netbeans.modules.cnd.apt.support.APTMacroCallback;
import org.netbeans.modules.cnd.apt.utils.APTUtils;

public final class APTConditionResolver {
    private static final boolean APT_EXPR_TRACE = Boolean.getBoolean("aptexpr.trace");
    public static final boolean PREPROCESSOR_ERROR_DEFAULT_RETURN_VALUE = false;

    private APTConditionResolver() {
    }

    public static boolean evaluate(APT aPT, APTMacroCallback aPTMacroCallback) throws TokenStreamException {
        boolean bl = false;
        switch (aPT.getType()) {
            case 9: {
                Token token = ((APTIfndef)aPT).getMacroName();
                bl = token == null ? false : !APTConditionResolver.isDefined(token, aPTMacroCallback);
                break;
            }
            case 8: {
                Token token = ((APTIfdef)aPT).getMacroName();
                bl = token == null ? false : APTConditionResolver.isDefined(token, aPTMacroCallback);
                break;
            }
            case 10: {
                bl = APTConditionResolver.evaluate(((APTIf)aPT).getCondition(), aPTMacroCallback);
                break;
            }
            case 11: {
                bl = APTConditionResolver.evaluate(((APTElif)aPT).getCondition(), aPTMacroCallback);
                break;
            }
            default: {
                assert (false) : "support only #ifdef,#ifndef,#if,#elif";
                break;
            }
        }
        return bl;
    }

    private static boolean isDefined(Token token, APTMacroCallback aPTMacroCallback) {
        return aPTMacroCallback.isDefined(token);
    }

    private static boolean evaluate(TokenStream tokenStream, APTMacroCallback aPTMacroCallback) throws TokenStreamException {
        boolean bl = false;
        TokenStream tokenStream2 = APTConditionResolver.expandTokenStream(tokenStream, aPTMacroCallback);
        try {
            APTExprParser aPTExprParser = new APTExprParser(tokenStream2, aPTMacroCallback);
            long l = aPTExprParser.expr();
            if (APT_EXPR_TRACE) {
                System.out.println("Value is " + l);
            }
            APTUtils.LOG.log(Level.FINE, "stream {0} \n was expanded for condition resolving to \n {1} \n with result {2}", new Object[]{tokenStream, tokenStream2, new Long(l)});
            bl = l != 0L;
        }
        catch (NullPointerException nullPointerException) {
            APTUtils.LOG.log(Level.SEVERE, "exception on resolving expression: {0}\n{1}", new Object[]{tokenStream, nullPointerException});
            bl = false;
        }
        catch (ArithmeticException arithmeticException) {
            if (DebugUtils.STANDALONE) {
                System.err.printf("arithmetic error \"%s\" on resolving expression:\n\t %s\n", arithmeticException.getMessage(), tokenStream);
            } else {
                APTUtils.LOG.log(Level.WARNING, "arithmetic error \"{0}\" on resolving expression\n: {1}", new Object[]{arithmeticException.getMessage(), tokenStream});
            }
            bl = false;
        }
        return bl;
    }

    private static TokenStream expandTokenStream(TokenStream tokenStream, APTMacroCallback aPTMacroCallback) {
        return new APTExpandedStream(tokenStream, aPTMacroCallback, true);
    }

    private static boolean isEmpty(AST aST) {
        return aST == null || aST.getType() == 1;
    }
}

