/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.netbeans.modules.spring.beans.ConfigFileManagerImplementation;
import org.netbeans.modules.spring.util.ConfigFiles;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectConfigFileManagerImpl
implements ConfigFileManagerImplementation {
    private static final Logger LOGGER = Logger.getLogger(ProjectConfigFileManagerImpl.class.getName());
    private static final String SPRING_DATA = "spring-data";
    private static final String CONFIG_FILES = "config-files";
    private static final String CONFIG_FILE_GROUPS = "config-file-groups";
    private static final String CONFIG_FILE_GROUP = "config-file-group";
    private static final String NAME = "name";
    private static final String CONFIG_FILE = "config-file";
    private static final String SPRING_DATA_NS = "http://www.netbeans.org/ns/spring-data/1";
    private final Project project;
    private final AuxiliaryConfiguration auxConfig;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private List<File> files;
    private List<ConfigFileGroup> groups;

    public ProjectConfigFileManagerImpl(Project project) {
        this.project = project;
        this.auxConfig = (AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class);
        if (this.auxConfig == null) {
            throw new IllegalStateException("Project " + project + " does not have an AuxiliaryConfiguration in its lookup");
        }
    }

    @Override
    public Mutex mutex() {
        return ProjectManager.mutex();
    }

    @Override
    public List<File> getConfigFiles() {
        return (List)this.mutex().readAccess((Mutex.Action)new Mutex.Action<List<File>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<File> run() {
                Object object = ProjectConfigFileManagerImpl.this;
                synchronized (object) {
                    if (ProjectConfigFileManagerImpl.this.files == null) {
                        ProjectConfigFileManagerImpl.this.readConfiguration();
                    }
                    assert (ProjectConfigFileManagerImpl.this.files != null);
                }
                object = new ArrayList(ProjectConfigFileManagerImpl.this.files.size());
                object.addAll(ProjectConfigFileManagerImpl.this.files);
                return object;
            }
        });
    }

    @Override
    public List<ConfigFileGroup> getConfigFileGroups() {
        return (List)this.mutex().readAccess((Mutex.Action)new Mutex.Action<List<ConfigFileGroup>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<ConfigFileGroup> run() {
                Object object = ProjectConfigFileManagerImpl.this;
                synchronized (object) {
                    if (ProjectConfigFileManagerImpl.this.groups == null) {
                        ProjectConfigFileManagerImpl.this.readConfiguration();
                    }
                    assert (ProjectConfigFileManagerImpl.this.groups != null);
                }
                object = new ArrayList(ProjectConfigFileManagerImpl.this.groups.size());
                object.addAll(ProjectConfigFileManagerImpl.this.groups);
                return object;
            }
        });
    }

    @Override
    public void putConfigFilesAndGroups(List<File> list, List<ConfigFileGroup> list2) {
        assert (this.mutex().isWriteAccess());
        this.writeConfiguration(list, list2);
        this.files = new ArrayList<File>(list.size());
        this.files.addAll(list);
        this.groups = new ArrayList<ConfigFileGroup>(list2.size());
        this.groups.addAll(list2);
        this.changeSupport.fireChange();
    }

    @Override
    public void save() throws IOException {
        assert (this.mutex().isWriteAccess());
        ProjectManager.getDefault().saveProject(this.project);
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    private void readConfiguration() {
        assert (this.mutex().isReadAccess());
        File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        if (file == null) {
            LOGGER.warning("The directory of project " + this.project + "is null");
            this.files = Collections.emptyList();
            this.groups = Collections.emptyList();
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<ConfigFileGroup> arrayList2 = new ArrayList<ConfigFileGroup>();
        Element element = this.auxConfig.getConfigurationFragment(SPRING_DATA, SPRING_DATA_NS, true);
        if (element != null) {
            Element element2;
            NodeList nodeList = element.getElementsByTagNameNS(SPRING_DATA_NS, CONFIG_FILES);
            if (nodeList.getLength() > 0) {
                element2 = (Element)nodeList.item(0);
                nodeList = element2.getElementsByTagNameNS(SPRING_DATA_NS, CONFIG_FILE);
                this.readFiles(nodeList, file, arrayList);
            }
            if ((nodeList = element.getElementsByTagNameNS(SPRING_DATA_NS, CONFIG_FILE_GROUPS)).getLength() > 0) {
                element2 = (Element)nodeList.item(0);
                nodeList = element2.getElementsByTagNameNS(SPRING_DATA_NS, CONFIG_FILE_GROUP);
                this.readGroups(nodeList, file, arrayList2);
            }
            this.removeUnknownFiles(arrayList2, new HashSet<File>(arrayList));
        }
        this.files = arrayList;
        this.groups = arrayList2;
    }

    private void readFiles(NodeList nodeList, File file, List<File> list) {
        HashSet<File> hashSet = new HashSet<File>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            File file2 = ConfigFiles.resolveFile(file, element.getTextContent());
            if (file2 == null || !hashSet.add(file2)) continue;
            list.add(file2);
        }
    }

    private void readGroups(NodeList nodeList, File file, List<ConfigFileGroup> list) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute(NAME);
            NodeList nodeList2 = element.getElementsByTagNameNS(SPRING_DATA_NS, CONFIG_FILE);
            ArrayList<File> arrayList = new ArrayList<File>(nodeList2.getLength());
            this.readFiles(nodeList2, file, arrayList);
            list.add(ConfigFileGroup.create(string, arrayList));
        }
    }

    private void removeUnknownFiles(List<ConfigFileGroup> list, Set<File> set) {
        for (int i = 0; i < list.size(); ++i) {
            ConfigFileGroup configFileGroup = list.get(i);
            for (File file : configFileGroup.getFiles()) {
                if (set.contains(file)) continue;
                ArrayList<File> arrayList = new ArrayList<File>(configFileGroup.getFiles().size());
                for (File file2 : configFileGroup.getFiles()) {
                    if (!set.contains(file2)) continue;
                    arrayList.add(file2);
                }
                list.set(i, ConfigFileGroup.create(configFileGroup.getName(), arrayList));
            }
        }
    }

    private void writeConfiguration(List<File> list, List<ConfigFileGroup> list2) {
        assert (this.mutex().isWriteAccess());
        File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        if (file == null) {
            LOGGER.warning("The directory of project " + this.project + "is null");
            return;
        }
        Document document = XMLUtil.createDocument((String)SPRING_DATA, (String)SPRING_DATA_NS, null, null);
        Element element = document.getDocumentElement();
        Element element2 = element.getOwnerDocument().createElementNS(SPRING_DATA_NS, CONFIG_FILES);
        element.appendChild(element2);
        this.writeFiles(list, file, element2);
        Element element3 = element.getOwnerDocument().createElementNS(SPRING_DATA_NS, CONFIG_FILE_GROUPS);
        element.appendChild(element3);
        this.writeGroups(list2, file, element3);
        this.auxConfig.putConfigurationFragment(element, true);
    }

    private void writeFiles(List<File> list, File file, Element element) {
        for (File file2 : list) {
            Element element2 = element.getOwnerDocument().createElementNS(SPRING_DATA_NS, CONFIG_FILE);
            element2.appendChild(element2.getOwnerDocument().createTextNode(ConfigFiles.getRelativePath(file, file2)));
            element.appendChild(element2);
        }
    }

    private void writeGroups(List<ConfigFileGroup> list, File file, Element element) {
        for (ConfigFileGroup configFileGroup : list) {
            Element element2 = element.getOwnerDocument().createElementNS(SPRING_DATA_NS, CONFIG_FILE_GROUP);
            String string = configFileGroup.getName();
            if (string != null && string.length() > 0) {
                element2.setAttribute(NAME, string);
            }
            this.writeFiles(configFileGroup.getFiles(), file, element2);
            element.appendChild(element2);
        }
    }
}

