/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.spring.beans.editor.DocumentContext;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLKit;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.EndTag;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionContext {
    private ArrayList<String> existingAttributes;
    private CompletionType completionType = CompletionType.NONE;
    private int caretOffset;
    private DocumentContext documentContext;
    private String typedChars = "";
    private char lastTypedChar;
    private XMLSyntaxSupport support;
    private FileObject fileObject;
    private BaseDocument internalDoc = new BaseDocument(XMLKit.class, false);

    public CompletionContext(Document document, int n) {
        this.caretOffset = n;
        this.fileObject = NbEditorUtilities.getFileObject((Document)document);
        this.initContext((BaseDocument)document);
    }

    private void initContext(BaseDocument baseDocument) {
        boolean bl = this.copyDocument(baseDocument, this.internalDoc);
        if (!bl) {
            return;
        }
        Object object = baseDocument.getProperty((Object)"stream");
        this.internalDoc.putProperty((Object)"stream", object);
        this.support = (XMLSyntaxSupport)this.internalDoc.getSyntaxSupport();
        this.documentContext = DocumentContext.create((Document)this.internalDoc, this.caretOffset);
        this.lastTypedChar = ((XMLSyntaxSupport)baseDocument.getSyntaxSupport()).lastTypedChar();
        if (this.documentContext == null) {
            return;
        }
        TokenItem tokenItem = this.documentContext.getCurrentToken();
        if (tokenItem == null) {
            return;
        }
        boolean bl2 = tokenItem.getOffset() == this.caretOffset || tokenItem.getOffset() + tokenItem.getImage().length() == this.caretOffset;
        int n = tokenItem.getTokenID().getNumericID();
        SyntaxElement syntaxElement = this.documentContext.getCurrentElement();
        switch (n) {
            case 1: {
                String string = tokenItem.getImage().trim();
                if (string != null && string.equals("") && tokenItem.getPrevious().getImage().trim().equals("/>")) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                if (string != null && string.equals("") && tokenItem.getPrevious().getImage().trim().equals(">")) {
                    this.completionType = CompletionType.VALUE;
                    break;
                }
                if (string != null && !string.equals("<") && tokenItem.getPrevious().getImage().trim().equals(">")) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                if (string != null && string.startsWith("<")) {
                    this.typedChars = string.substring(1);
                }
                this.completionType = CompletionType.TAG;
                break;
            }
            case 4: {
                if (syntaxElement instanceof EndTag) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                if (syntaxElement instanceof EmptyTag) {
                    if (tokenItem != null && tokenItem.getImage().trim().equals("/>")) {
                        TokenItem tokenItem2 = tokenItem.getPrevious();
                        if (tokenItem2 != null && tokenItem2.getTokenID().getNumericID() == 2 && this.caretOffset == tokenItem.getOffset()) {
                            this.completionType = CompletionType.ATTRIBUTE;
                            break;
                        }
                        this.completionType = CompletionType.NONE;
                        break;
                    }
                    EmptyTag emptyTag = (EmptyTag)syntaxElement;
                    if (syntaxElement.getElementOffset() + 1 == this.caretOffset) {
                        this.completionType = CompletionType.TAG;
                        break;
                    }
                    if (this.caretOffset > syntaxElement.getElementOffset() + 1 && this.caretOffset <= syntaxElement.getElementOffset() + 1 + emptyTag.getTagName().length()) {
                        this.completionType = CompletionType.TAG;
                        this.typedChars = emptyTag.getTagName();
                        break;
                    }
                    this.completionType = CompletionType.ATTRIBUTE;
                    break;
                }
                if (syntaxElement instanceof StartTag) {
                    if (tokenItem != null && tokenItem.getImage().trim().equals(">")) {
                        TokenItem tokenItem3 = tokenItem.getPrevious();
                        if (tokenItem3 != null && tokenItem3.getTokenID().getNumericID() == 2 && this.caretOffset == tokenItem.getOffset()) {
                            this.completionType = CompletionType.ATTRIBUTE;
                            break;
                        }
                        this.completionType = CompletionType.NONE;
                        break;
                    }
                    if (syntaxElement.getElementOffset() + 1 != this.caretOffset) {
                        StartTag startTag = (StartTag)syntaxElement;
                        this.typedChars = startTag.getTagName();
                    }
                }
                if (this.lastTypedChar == '>') {
                    this.completionType = CompletionType.VALUE;
                    break;
                }
                this.completionType = CompletionType.TAG;
                break;
            }
            case 5: {
                this.completionType = CompletionType.ATTRIBUTE;
                this.typedChars = tokenItem.getImage().substring(0, this.caretOffset - tokenItem.getOffset());
                break;
            }
            case 6: 
            case 11: {
                this.completionType = CompletionType.NONE;
                break;
            }
            case 7: {
                if (!bl2) {
                    this.completionType = CompletionType.ATTRIBUTE_VALUE;
                    this.typedChars = tokenItem.getImage().substring(1, this.caretOffset - tokenItem.getOffset());
                    break;
                }
                this.completionType = CompletionType.NONE;
                break;
            }
            case 2: {
                TokenItem tokenItem4;
                this.completionType = CompletionType.NONE;
                for (tokenItem4 = tokenItem.getPrevious(); tokenItem4 != null && tokenItem4.getTokenID().getNumericID() == 2; tokenItem4 = tokenItem4.getPrevious()) {
                }
                if (tokenItem4.getTokenID().getNumericID() == 5) {
                    this.typedChars = tokenItem4.getImage();
                    this.completionType = CompletionType.ATTRIBUTE;
                    break;
                }
                if (tokenItem4.getTokenID().getNumericID() != 7 && tokenItem4.getTokenID().getNumericID() != 4) break;
                this.completionType = CompletionType.ATTRIBUTE;
                break;
            }
            default: {
                this.completionType = CompletionType.NONE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyDocument(BaseDocument baseDocument, BaseDocument baseDocument2) {
        boolean bl = true;
        baseDocument.readLock();
        baseDocument2.atomicLock();
        try {
            String string = baseDocument.getText(0, baseDocument.getLength());
            baseDocument2.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            bl = false;
        }
        finally {
            baseDocument2.atomicUnlock();
            baseDocument.readUnlock();
        }
        return bl;
    }

    public CompletionType getCompletionType() {
        return this.completionType;
    }

    public String getTypedPrefix() {
        return this.typedChars;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public DocumentContext getDocumentContext() {
        return this.documentContext;
    }

    public int getCaretOffset() {
        return this.caretOffset;
    }

    public Node getTag() {
        SyntaxElement syntaxElement = this.documentContext.getCurrentElement();
        return syntaxElement instanceof Tag ? (Node)syntaxElement : null;
    }

    public TokenItem getCurrentToken() {
        return this.documentContext.getCurrentToken();
    }

    public List<String> getExistingAttributes() {
        if (this.existingAttributes == null) {
            int n;
            this.existingAttributes = new ArrayList();
            for (TokenItem tokenItem = this.documentContext.getCurrentToken().getPrevious(); tokenItem != null && (n = tokenItem.getTokenID().getNumericID()) != 4; tokenItem = tokenItem.getPrevious()) {
                if (n != 5) continue;
                this.existingAttributes.add(tokenItem.getImage());
            }
        }
        return this.existingAttributes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompletionType {
        TAG,
        VALUE,
        ATTRIBUTE,
        ATTRIBUTE_VALUE,
        NONE;

    }
}

