/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.hyperlink;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.spring.beans.editor.BeanClassFinder;
import org.netbeans.modules.spring.beans.editor.Property;
import org.netbeans.modules.spring.beans.editor.PropertyFinder;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkEnv;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkProcessor;
import org.openide.util.Exceptions;

public class PropertyHyperlinkProcessor
extends HyperlinkProcessor {
    public void process(HyperlinkEnv hyperlinkEnv) {
        try {
            final String string = new BeanClassFinder(hyperlinkEnv.getBeanAttributes(), hyperlinkEnv.getFileObject()).findImplementationClass();
            if (string == null) {
                return;
            }
            final String string2 = this.getPropertyChainUptoPosition(hyperlinkEnv);
            if (string2 == null || string2.equals("")) {
                return;
            }
            JavaSource javaSource = SpringXMLConfigEditorUtils.getJavaSource(hyperlinkEnv.getFileObject());
            if (javaSource == null) {
                return;
            }
            final int n = string2.lastIndexOf(".");
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    Property[] propertyArray;
                    String string3;
                    TypeElement typeElement = SpringXMLConfigEditorUtils.findClassElementByBinaryName(string, compilationController);
                    if (typeElement == null) {
                        return;
                    }
                    TypeMirror typeMirror = typeElement.asType();
                    ElementUtilities elementUtilities = compilationController.getElementUtilities();
                    if (n != -1) {
                        string3 = string2.substring(0, n);
                        propertyArray = new StringTokenizer(string3, ".");
                        while (propertyArray.hasMoreTokens() && typeMirror != null) {
                            String string22 = propertyArray.nextToken();
                            Property[] propertyArray2 = new PropertyFinder(typeMirror, string22, elementUtilities).findProperties();
                            if (propertyArray2.length == 0 || propertyArray2[0].getGetter() == null) {
                                typeMirror = null;
                                break;
                            }
                            TypeMirror typeMirror2 = propertyArray2[0].getGetter().getReturnType();
                            if (typeMirror2.getKind() == TypeKind.DECLARED) {
                                typeMirror = typeMirror2;
                                continue;
                            }
                            typeMirror = null;
                        }
                    }
                    if (typeMirror == null) {
                        return;
                    }
                    string3 = string2.substring(n + 1);
                    propertyArray = new PropertyFinder(typeMirror, string3, elementUtilities).findProperties();
                    if (propertyArray.length > 0 && propertyArray[0].getSetter() != null) {
                        ElementOpen.open((ClasspathInfo)compilationController.getClasspathInfo(), (Element)propertyArray[0].getSetter());
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public int[] getSpan(HyperlinkEnv hyperlinkEnv) {
        int n = hyperlinkEnv.getTokenStartOffset() + 1;
        String string = this.getPropertyChainUptoPosition(hyperlinkEnv);
        if (string == null || string.equals("")) {
            return null;
        }
        int n2 = hyperlinkEnv.getTokenStartOffset() + string.length() + 1;
        int n3 = string.lastIndexOf(".");
        n3 = n3 == -1 ? 0 : ++n3;
        return new int[]{n3 += n, n2};
    }

    private String getPropertyChainUptoPosition(HyperlinkEnv hyperlinkEnv) {
        int n = hyperlinkEnv.getOffset() - hyperlinkEnv.getTokenStartOffset() - 1;
        int n2 = hyperlinkEnv.getValueString().indexOf(".", n);
        if (n2 == -1) {
            return hyperlinkEnv.getValueString();
        }
        return hyperlinkEnv.getValueString().substring(0, n2);
    }
}

