/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.beans.model.ExclusiveAccess;
import org.netbeans.modules.spring.beans.model.SpringBeanSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigModelSpringBeans
implements SpringBeans {
    private final Map<File, SpringBeanSource> file2BeanSource;

    public ConfigModelSpringBeans(Map<File, SpringBeanSource> map) {
        this.file2BeanSource = map;
    }

    @Override
    public SpringBean findBean(String string) {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess()) : "The SpringBeans instance has escaped the Action.run() method";
        for (SpringBeanSource springBeanSource : this.file2BeanSource.values()) {
            SpringBean springBean = springBeanSource.findBeanByIDOrName(string);
            if (springBean == null) continue;
            return springBean;
        }
        return null;
    }

    @Override
    public SpringBean findBean(File file, String string) {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess()) : "The SpringBeans instance has escaped the Action.run() method";
        SpringBeanSource springBeanSource = this.file2BeanSource.get(file);
        if (springBeanSource != null) {
            return springBeanSource.findBeanByID(string);
        }
        return null;
    }

    @Override
    public List<SpringBean> getBeans(File file) {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess()) : "The SpringBeans instance has escaped the Action.run() method";
        SpringBeanSource springBeanSource = this.file2BeanSource.get(file);
        if (springBeanSource != null) {
            return springBeanSource.getBeans();
        }
        return null;
    }

    @Override
    public List<SpringBean> getBeans() {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess()) : "The SpringBeans instance has escaped the Action.run() method";
        ArrayList<SpringBean> arrayList = new ArrayList<SpringBean>(this.file2BeanSource.size() * 20);
        for (SpringBeanSource springBeanSource : this.file2BeanSource.values()) {
            arrayList.addAll(springBeanSource.getBeans());
        }
        return Collections.unmodifiableList(arrayList);
    }
}

