/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.validation.core;

import java.util.Collections;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.CreateInstanceActivity;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.support.SimpleBpelModelVisitor;
import org.netbeans.modules.bpel.model.api.support.TBoolean;
import org.netbeans.modules.bpel.validation.core.CoreValidator;
import org.netbeans.modules.soa.ui.util.UI;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.ValidationResult;

public abstract class BpelValidator
extends CoreValidator {
    public synchronized ValidationResult validate(Model model, Validation validation, Validation.ValidationType validationType) {
        if (!(model instanceof BpelModel)) {
            return null;
        }
        final BpelModel bpelModel = (BpelModel)model;
        if (bpelModel.getState() == Model.State.NOT_WELL_FORMED) {
            return null;
        }
        this.init(validation, validationType);
        Runnable runnable = new Runnable(){

            public void run() {
                UI.startTime();
                Process process = bpelModel.getProcess();
                if (process != null) {
                    process.accept((SimpleBpelModelVisitor)BpelValidator.this);
                }
                UI.endTime((Object)BpelValidator.this.getDisplayName());
            }
        };
        bpelModel.invoke(runnable);
        return new ValidationResult(this.getResultItems(), Collections.singleton(model));
    }

    protected final boolean isCreateInstanceYes(CreateInstanceActivity createInstanceActivity) {
        return createInstanceActivity != null && createInstanceActivity.getCreateInstance() == TBoolean.YES;
    }

    protected final CreateInstanceActivity getCreateInstanceActivity(Component component) {
        if (component instanceof CreateInstanceActivity) {
            return (CreateInstanceActivity)component;
        }
        if (component.getParent() instanceof CreateInstanceActivity) {
            return (CreateInstanceActivity)component.getParent();
        }
        return null;
    }
}

