/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.validation.project;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.compapp.projects.jbi.api.ProjectValidator;
import org.netbeans.modules.soa.ui.util.UI;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validator
implements ProjectValidator {
    public String validateProjects(List<Project> list) {
        ArrayList<BPELFile> arrayList = new ArrayList<BPELFile>();
        for (Project project : list) {
            String string = this.addBPELFiles(project, arrayList);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    private String addBPELFiles(Project project, List<BPELFile> list) {
        SourceGroup[] sourceGroupArray;
        Sources sources = ProjectUtils.getSources((Project)project);
        boolean bl = this.isAllowBuildWithError(project);
        for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("xml")) {
            Enumeration enumeration = sourceGroup.getRootFolder().getChildren(true);
            while (enumeration.hasMoreElements()) {
                String string;
                String string2;
                FileObject fileObject = (FileObject)enumeration.nextElement();
                if (!fileObject.getExt().toLowerCase().equals("bpel") || (string2 = this.getQName(fileObject)) == null || (string = this.check(list, new BPELFile(fileObject, project, string2), bl)) == null) continue;
                return string;
            }
        }
        return null;
    }

    private boolean isAllowBuildWithError(Project project) {
        AntProjectHelper antProjectHelper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
        if (antProjectHelper == null) {
            return false;
        }
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        if (editableProperties == null) {
            return false;
        }
        return "true".equals(editableProperties.get((Object)"allow.build.with.error"));
    }

    private String check(List<BPELFile> list, BPELFile bPELFile, boolean bl) {
        String string = bPELFile.getQName();
        for (BPELFile bPELFile2 : list) {
            if (!bPELFile2.getQName().equals(string) || bl) continue;
            return UI.i18n(this.getClass(), (String)"ERR_Same_QName", (String)bPELFile2.getName(), (String)bPELFile.getName(), (String)string);
        }
        list.add(bPELFile);
        return null;
    }

    private String getQName(FileObject fileObject) {
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
        if (!(dataObject instanceof Lookup.Provider)) {
            return null;
        }
        BpelModel bpelModel = (BpelModel)dataObject.getLookup().lookup(BpelModel.class);
        Process process = bpelModel.getProcess();
        return process.getName() + ", " + process.getTargetNamespace();
    }

    public static class BPELFile {
        private FileObject myFile;
        private Project myProject;
        private String myQName;

        public BPELFile(FileObject fileObject, Project project, String string) {
            this.myFile = fileObject;
            this.myProject = project;
            this.myQName = string;
        }

        public String getQName() {
            return this.myQName;
        }

        public String getName() {
            return "[" + ProjectUtils.getInformation((Project)this.myProject).getDisplayName() + "]/" + this.myFile.getName();
        }
    }
}

