/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.api.client;

import com.sun.ws.rest.api.client.ClientHandler;
import com.sun.ws.rest.api.client.ClientHandlerException;
import com.sun.ws.rest.api.client.ClientRequest;
import com.sun.ws.rest.api.client.ClientResponse;
import com.sun.ws.rest.api.client.Filterable;
import com.sun.ws.rest.api.client.WebResource;
import com.sun.ws.rest.api.client.config.ClientConfig;
import com.sun.ws.rest.api.client.config.DefaultClientConfig;
import com.sun.ws.rest.api.core.ResourceConfig;
import com.sun.ws.rest.impl.application.ComponentProviderCache;
import com.sun.ws.rest.impl.application.ContextResolverFactory;
import com.sun.ws.rest.impl.application.MessageBodyFactory;
import com.sun.ws.rest.impl.client.urlconnection.URLConnectionClientHandler;
import com.sun.ws.rest.spi.container.MessageBodyContext;
import com.sun.ws.rest.spi.resource.Injectable;
import com.sun.ws.rest.spi.service.ComponentProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Context;

public class Client
extends Filterable
implements ClientHandler {
    private final Map<Type, Injectable> injectables = new HashMap<Type, Injectable>();
    private final ClientConfig config;
    private final ComponentProvider provider;
    private final MessageBodyContext bodyContext;

    public Client(ClientHandler root) {
        this(root, new DefaultClientConfig(), null);
    }

    public Client(ClientHandler root, ClientConfig config) {
        this(root, config, null);
    }

    public Client(ClientHandler root, ClientConfig config, ComponentProvider provider) {
        super(root);
        this.config = config;
        this.addInjectable((Type)((Object)ResourceConfig.class), new HttpContextInjectable<ClientConfig>(){

            @Override
            public ClientConfig getInjectableValue(Context c) {
                return Client.this.config;
            }
        });
        this.provider = provider == null ? new DefaultComponentProvider() : new AdaptingComponentProvider(provider);
        ComponentProviderCache cpc = new ComponentProviderCache(this.provider, config.getProviderClasses());
        ContextResolverFactory crf = new ContextResolverFactory(cpc);
        this.injectables.putAll(crf.getInjectables());
        this.bodyContext = new MessageBodyFactory(cpc);
        this.addInjectable((Type)((Object)MessageBodyContext.class), new HttpContextInjectable<MessageBodyContext>(){

            @Override
            public MessageBodyContext getInjectableValue(Context c) {
                return Client.this.bodyContext;
            }
        });
        this.injectResources(root);
    }

    public final void addInjectable(Type fieldType, Injectable injectable) {
        this.injectables.put(fieldType, injectable);
    }

    public final WebResource resource(String u) {
        return this.resource(URI.create(u));
    }

    public final WebResource resource(URI u) {
        return new WebResource(this, u);
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        return this.getHeadHandler().handle(cr);
    }

    private void injectResources(Object o) {
        this.injectResources(o.getClass(), o);
    }

    private void injectResources(Class oClass, Object o) {
        while (oClass != null) {
            for (Field f : oClass.getDeclaredFields()) {
                Injectable i = this.injectables.get(f.getGenericType());
                if (i == null) continue;
                i.inject(o, f);
            }
            oClass = oClass.getSuperclass();
        }
    }

    public static Client create() {
        return new Client(new URLConnectionClientHandler());
    }

    public static Client create(ClientConfig cc) {
        return new Client(new URLConnectionClientHandler(), cc);
    }

    public static Client create(ClientConfig cc, ComponentProvider cp) {
        return new Client(new URLConnectionClientHandler(), cc, cp);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class HttpContextInjectable<V>
    extends Injectable<Context, V> {
        private HttpContextInjectable() {
        }

        @Override
        public Class<Context> getAnnotationClass() {
            return Context.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DefaultComponentProvider
    implements ComponentProvider {
        private DefaultComponentProvider() {
        }

        @Override
        public <T> T getInstance(ComponentProvider.Scope scope, Class<T> c) throws InstantiationException, IllegalAccessException {
            T o = c.newInstance();
            Client.this.injectResources(o);
            return o;
        }

        @Override
        public <T> T getInstance(ComponentProvider.Scope scope, Constructor<T> contructor, Object[] parameters) throws InstantiationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            T o = contructor.newInstance(parameters);
            Client.this.injectResources(o);
            return o;
        }

        @Override
        public void inject(Object instance) {
            Client.this.injectResources(instance);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AdaptingComponentProvider
    implements ComponentProvider {
        private final ComponentProvider cp;

        AdaptingComponentProvider(ComponentProvider cp) {
            this.cp = cp;
        }

        @Override
        public <T> T getInstance(ComponentProvider.Scope scope, Class<T> c) throws InstantiationException, IllegalAccessException {
            T o = this.cp.getInstance(scope, c);
            if (o == null) {
                o = c.newInstance();
            }
            Client.this.injectResources(o);
            return o;
        }

        @Override
        public <T> T getInstance(ComponentProvider.Scope scope, Constructor<T> contructor, Object[] parameters) throws InstantiationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            T o = this.cp.getInstance(scope, contructor, parameters);
            if (o == null) {
                o = contructor.newInstance(parameters);
            }
            Client.this.injectResources(o);
            return o;
        }

        @Override
        public void inject(Object instance) {
            this.cp.inject(instance);
            Client.this.injectResources(instance);
        }
    }
}

