/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.api.model;

import com.sun.ws.rest.api.model.AbstractModelComponent;
import com.sun.ws.rest.api.model.AbstractModelVisitor;
import com.sun.ws.rest.api.model.AbstractResource;
import com.sun.ws.rest.api.model.Parameter;
import com.sun.ws.rest.api.model.Parameterized;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractResourceMethod
implements Parameterized,
AbstractModelComponent {
    private AbstractResource resource;
    private List<MediaType> consumeMimeList;
    private List<MediaType> produceMimeList;
    private List<Parameter> parameters;
    private String httpMethod;
    private Method method;

    public AbstractResourceMethod(AbstractResource resource, Method method, String httpMethod) {
        assert (null != method);
        this.resource = resource;
        this.method = method;
        this.httpMethod = httpMethod;
        this.consumeMimeList = new ArrayList<MediaType>();
        this.produceMimeList = new ArrayList<MediaType>();
        this.parameters = new ArrayList<Parameter>();
    }

    public AbstractResource getDeclaringResource() {
        return this.resource;
    }

    public List<MediaType> getSupportedInputTypes() {
        return this.consumeMimeList;
    }

    public List<MediaType> getSupportedOutputTypes() {
        return this.produceMimeList;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public void accept(AbstractModelVisitor visitor) {
        visitor.visitAbstractResourceMethod(this);
    }

    @Override
    public List<AbstractModelComponent> getComponents() {
        return null;
    }

    public String toString() {
        return "AbstractResourceMethod(" + this.getMethod().getDeclaringClass().getSimpleName() + "#" + this.getMethod().getName() + ")";
    }
}

