/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.application;

import com.sun.ws.rest.impl.application.ComponentProviderCache;
import com.sun.ws.rest.impl.model.MediaTypeHelper;
import com.sun.ws.rest.spi.container.MessageBodyContext;
import com.sun.ws.rest.spi.service.ServiceFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageBodyFactory
implements MessageBodyContext {
    private static final Logger LOGGER = Logger.getLogger(MessageBodyFactory.class.getName());
    private final ComponentProviderCache componentProviderCache;
    private final Map<MediaType, List<MessageBodyReader>> readerProviders;
    private final Map<MediaType, List<MessageBodyWriter>> writerProviders;

    public MessageBodyFactory(ComponentProviderCache componentProviderCache) {
        this.componentProviderCache = componentProviderCache;
        this.readerProviders = this.getProviderMap(MessageBodyReader.class, ConsumeMime.class);
        this.writerProviders = this.getProviderMap(MessageBodyWriter.class, ProduceMime.class);
    }

    private <T> Map<MediaType, List<T>> getProviderMap(Class<T> serviceClass, Class<?> annotationClass) {
        Class<T>[] pca;
        LinkedHashSet<Class> pcs = new LinkedHashSet<Class>(this.componentProviderCache.getProviderClasses(serviceClass));
        LOGGER.log(Level.CONFIG, "Searching for providers that implement: " + serviceClass);
        for (Class<T> pc : pca = ServiceFinder.find(serviceClass, true).toClassArray()) {
            LOGGER.log(Level.CONFIG, "    Provider found: " + pc);
        }
        for (Class<T> pc : pca) {
            pcs.add(pc);
        }
        HashMap<MediaType, List<T>> s = new HashMap<MediaType, List<T>>();
        for (Class providerClass : pcs) {
            Object o = this.componentProviderCache.getComponent(providerClass);
            if (o == null) continue;
            T provider = serviceClass.cast(o);
            String[] values = this.getAnnotationValues(providerClass, annotationClass);
            if (values == null) {
                this.getClassCapability(s, provider, MediaTypeHelper.GENERAL_MEDIA_TYPE);
                continue;
            }
            for (String type : values) {
                this.getClassCapability(s, provider, MediaType.parse((String)type));
            }
        }
        return s;
    }

    private <T> void getClassCapability(Map<MediaType, List<T>> capabilities, T provider, MediaType mediaType) {
        if (!capabilities.containsKey(mediaType)) {
            capabilities.put(mediaType, new ArrayList());
        }
        List<T> providers = capabilities.get(mediaType);
        providers.add(provider);
    }

    private String[] getAnnotationValues(Class<?> clazz, Class<?> annotationClass) {
        ProduceMime produces;
        String[] values = null;
        if (annotationClass.equals(ConsumeMime.class)) {
            ConsumeMime consumes = clazz.getAnnotation(ConsumeMime.class);
            if (consumes != null) {
                values = consumes.value();
            }
        } else if (annotationClass.equals(ProduceMime.class) && (produces = clazz.getAnnotation(ProduceMime.class)) != null) {
            values = produces.value();
        }
        return values;
    }

    @Override
    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, MediaType mediaType) {
        List<MediaType> searchTypes = this.createSearchList(mediaType);
        for (MediaType t : searchTypes) {
            List<MessageBodyReader> readers = this.readerProviders.get(t);
            if (readers == null) continue;
            for (MessageBodyReader p : readers) {
                if (!p.isReadable(type)) continue;
                return p;
            }
        }
        throw new IllegalArgumentException("A message body reader for Java type, " + type + ", and MIME media type, " + mediaType + ", was not found");
    }

    @Override
    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, MediaType mediaType) {
        List<MediaType> searchTypes = this.createSearchList(mediaType);
        for (MediaType t : searchTypes) {
            List<MessageBodyWriter> writers = this.writerProviders.get(t);
            if (writers == null) continue;
            for (MessageBodyWriter p : writers) {
                if (!p.isWriteable(type)) continue;
                return p;
            }
        }
        throw new IllegalArgumentException("A message body writer for Java type, " + type + ", and MIME media type, " + mediaType + ", was not found");
    }

    private List<MediaType> createSearchList(MediaType mediaType) {
        if (mediaType == null) {
            return Arrays.asList(MediaTypeHelper.GENERAL_MEDIA_TYPE);
        }
        return Arrays.asList(mediaType, new MediaType(mediaType.getType(), "*"), MediaTypeHelper.GENERAL_MEDIA_TYPE);
    }
}

