/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.application;

import com.sun.ws.rest.api.core.HttpContextAccess;
import com.sun.ws.rest.api.core.HttpRequestContext;
import com.sun.ws.rest.api.core.HttpResponseContext;
import com.sun.ws.rest.impl.application.WebApplicationImpl;
import com.sun.ws.rest.impl.model.ResourceClass;
import com.sun.ws.rest.spi.container.ContainerRequest;
import com.sun.ws.rest.spi.container.ContainerResponse;
import com.sun.ws.rest.spi.uri.rules.UriRule;
import com.sun.ws.rest.spi.uri.rules.UriRuleContext;
import com.sun.ws.rest.spi.uri.rules.UriRules;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WebApplicationContext
implements HttpContextAccess,
UriRuleContext {
    private final ContainerRequest request;
    private final ContainerResponse response;
    private final WebApplicationImpl app;
    private Object it;
    private final List<String> capturingGroupValues = new ArrayList<String>();

    WebApplicationContext(WebApplicationImpl app, ContainerRequest request, ContainerResponse response) {
        this.app = app;
        this.request = request;
        this.response = response;
    }

    @Override
    public HttpRequestContext getHttpRequestContext() {
        return this.request;
    }

    @Override
    public HttpResponseContext getHttpResponseContext() {
        return this.response;
    }

    @Override
    public Object getCurrentResource() {
        return this.it;
    }

    @Override
    public HttpContextAccess getHttpContext() {
        return this;
    }

    @Override
    public Object getResource(Class resourceClass) {
        ResourceClass rc = this.app.getResourceClass(resourceClass);
        this.it = rc.resolver.getInstance(this.app.getComponentProvider(), this.request);
        return this.it;
    }

    @Override
    public UriRules<UriRule> getRules(Class resourceClass) {
        ResourceClass rc = this.app.getResourceClass(resourceClass);
        return rc.getRules();
    }

    @Override
    public List<String> getGroupValues() {
        return this.capturingGroupValues;
    }

    @Override
    public void setTemplateValues(List<String> names) {
        this.request.addTemplateValues(names, this.capturingGroupValues);
    }
}

