/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.container.grizzly;

import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.ws.rest.impl.http.header.HttpHeaderFactory;
import com.sun.ws.rest.spi.container.AbstractContainerRequest;
import com.sun.ws.rest.spi.container.MessageBodyContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import javax.ws.rs.core.MultivaluedMap;

public final class GrizzlyRequestAdaptor
extends AbstractContainerRequest {
    private final GrizzlyRequest request;

    public GrizzlyRequestAdaptor(MessageBodyContext bodyContext, GrizzlyRequest request) throws IOException {
        super(bodyContext, request.getMethod(), (InputStream)request.getInputStream());
        this.request = request;
        this.initiateUriInfo();
        this.copyHttpHeaders();
    }

    private void initiateUriInfo() {
        try {
            this.baseUri = new URI(this.request.getScheme(), null, this.request.getServerName(), this.request.getServerPort(), "/", null, null);
            this.completeUri = this.baseUri.resolve(this.request.getRequest().unparsedURI().toString());
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException(ex);
        }
    }

    private void copyHttpHeaders() {
        MultivaluedMap<String, String> headers = this.getRequestHeaders();
        Enumeration names = this.request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = this.request.getHeader(name);
            headers.add((Object)name, (Object)value);
            if (!name.equalsIgnoreCase("cookie")) continue;
            this.getCookies().putAll(HttpHeaderFactory.createCookies(value));
        }
    }
}

