/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.container.httpserver;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsExchange;
import com.sun.net.httpserver.HttpsServer;
import com.sun.ws.rest.impl.http.header.HttpHeaderFactory;
import com.sun.ws.rest.spi.container.AbstractContainerRequest;
import com.sun.ws.rest.spi.container.MessageBodyContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;

public final class HttpServerRequestAdaptor
extends AbstractContainerRequest {
    private final HttpExchange exchange;

    public HttpServerRequestAdaptor(MessageBodyContext bodyContext, HttpExchange exchange) throws IOException {
        super(bodyContext, exchange.getRequestMethod(), exchange.getRequestBody());
        this.exchange = exchange;
        this.initiateUriInfo();
        this.copyHttpHeaders();
    }

    private void initiateUriInfo() {
        HttpServer server;
        URI requestUri = this.exchange.getRequestURI();
        String decodedBasePath = this.exchange.getHttpContext().getPath();
        if (!decodedBasePath.endsWith("/")) {
            if (decodedBasePath.equals(requestUri.getPath())) {
                requestUri = UriBuilder.fromUri((URI)requestUri).path(new String[]{"/"}).build();
            }
            decodedBasePath = decodedBasePath + "/";
        }
        String scheme = (server = this.exchange.getHttpContext().getServer()) instanceof HttpsServer ? "https" : "http";
        InetSocketAddress addr = this.exchange.getLocalAddress();
        try {
            this.baseUri = new URI(scheme, null, addr.getHostName(), addr.getPort(), decodedBasePath, null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        this.completeUri = this.baseUri.resolve(requestUri);
    }

    private void copyHttpHeaders() {
        MultivaluedMap<String, String> headers = this.getRequestHeaders();
        Headers eh = this.exchange.getRequestHeaders();
        for (Map.Entry<String, List<String>> e : eh.entrySet()) {
            headers.put((Object)e.getKey(), e.getValue());
            if (!e.getKey().equalsIgnoreCase("cookie")) continue;
            for (String headerValue : e.getValue()) {
                this.getCookies().putAll(HttpHeaderFactory.createCookies(headerValue));
            }
        }
    }

    public Principal getUserPrincipal() {
        return this.exchange.getPrincipal();
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public boolean isSecure() {
        return this.exchange instanceof HttpsExchange;
    }

    public String getAuthenticationScheme() {
        return null;
    }
}

