/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.json.writer;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonXmlStreamWriter
implements XMLStreamWriter {
    Writer mainWriter;
    boolean stripRoot;
    List<ProcessingState> processingStack;
    int depth;
    final Collection<String> arrayElementNames = new LinkedList<String>();
    final Collection<String> nonStringElementNames = new LinkedList<String>();

    public JsonXmlStreamWriter(Writer writer) {
        this(writer, false, null, null);
    }

    public JsonXmlStreamWriter(Writer writer, boolean stripRoot) {
        this(writer, stripRoot, null, null);
    }

    public JsonXmlStreamWriter(Writer writer, boolean stripRoot, Collection<String> arrays, Collection<String> nonStrings) {
        this.mainWriter = writer;
        this.stripRoot = stripRoot;
        if (null != arrays) {
            this.arrayElementNames.addAll(arrays);
        }
        if (null != nonStrings) {
            this.nonStringElementNames.addAll(nonStrings);
        }
    }

    @Override
    public void close() throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void flush() throws XMLStreamException {
        try {
            this.mainWriter.flush();
        }
        catch (IOException ex) {
            Logger.getLogger(JsonXmlStreamWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        try {
            if (null != this.processingStack.get((int)this.depth).lastElementWriter) {
                this.processingStack.get((int)this.depth).writer.write(this.processingStack.get((int)this.depth).lastElementWriter.getContent());
            }
            if (null == this.processingStack.get((int)this.depth).lastWasPrimitive || !this.processingStack.get((int)this.depth).lastWasPrimitive.booleanValue()) {
                this.processingStack.get((int)this.depth).writer.write("}");
            }
            this.processingStack.remove(this.depth);
            --this.depth;
        }
        catch (IOException ex) {
            Logger.getLogger(JsonXmlStreamWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        try {
            if (null != this.processingStack.get((int)this.depth).lastElementWriter) {
                if (this.processingStack.get((int)this.depth).lastIsArray) {
                    this.processingStack.get((int)this.depth).writer.write(",");
                    this.processingStack.get((int)this.depth).writer.write(this.processingStack.get((int)this.depth).lastElementWriter.getContent());
                    this.processingStack.get((int)this.depth).writer.write("]");
                } else if (this.isArrayElement(this.processingStack.get((int)this.depth).lastName)) {
                    this.processingStack.get((int)this.depth).writer.write("[");
                    this.processingStack.get((int)this.depth).lastIsArray = true;
                    this.processingStack.get((int)this.depth).writer.write(this.processingStack.get((int)this.depth).lastElementWriter.getContent());
                    this.processingStack.get((int)this.depth).writer.write("]");
                } else {
                    this.processingStack.get((int)this.depth).writer.write(this.processingStack.get((int)this.depth).lastElementWriter.getContent());
                }
            }
            if (null == this.processingStack.get((int)this.depth).lastWasPrimitive || !this.processingStack.get((int)this.depth).lastWasPrimitive.booleanValue()) {
                this.processingStack.get((int)this.depth).writer.write("}");
            }
            this.processingStack.get((int)(this.depth - 1)).lastName = this.processingStack.get((int)(this.depth - 1)).currentName;
            this.processingStack.get((int)(this.depth - 1)).lastWasPrimitive = false;
            this.processingStack.get((int)(this.depth - 1)).lastElementWriter = this.processingStack.get((int)this.depth).writer;
            this.processingStack.remove(this.depth);
            --this.depth;
        }
        catch (IOException ex) {
            Logger.getLogger(JsonXmlStreamWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.depth = 0;
        this.processingStack = new ArrayList<ProcessingState>();
        this.processingStack.add(this.createProcessingState());
    }

    @Override
    public void writeCharacters(char[] text, int start, int length) throws XMLStreamException {
        this.writeCharacters(new String(text, start, length));
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        try {
            if (this.isNonString(this.processingStack.get((int)(this.depth - 1)).currentName)) {
                this.processingStack.get((int)this.depth).writer.write(text);
            } else {
                this.processingStack.get((int)this.depth).writer.write("\"" + text + "\"");
            }
            this.processingStack.get((int)this.depth).lastWasPrimitive = true;
        }
        catch (IOException ex) {
            Logger.getLogger(JsonXmlStreamWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeDefaultNamespace(String uri) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeEmptyElement(null, localName, null);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.writeStartElement(null, localName, null);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return null;
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writeAttribute(null, null, localName, value);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeEmptyElement(null, localName, null);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartElement(null, localName, null);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writeAttribute(null, namespaceURI, localName, value);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeStartElement(localName);
        this.writeEndElement();
    }

    private void printStack(String localName) {
        try {
            for (int d = 0; d <= this.depth; ++d) {
                this.mainWriter.write("\n**" + d + ":" + this.processingStack.get(d));
            }
            this.mainWriter.write("\n*** [" + localName + "]");
        }
        catch (IOException ex) {
            Logger.getLogger(JsonXmlStreamWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private boolean isArrayElement(String name) {
        if (null == name) {
            return false;
        }
        return this.arrayElementNames.contains(name);
    }

    private boolean isNonString(String name) {
        if (null == name) {
            return false;
        }
        return this.nonStringElementNames.contains(name);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.processingStack.get((int)this.depth).currentName = localName;
        try {
            boolean isNextArrayElement = this.processingStack.get((int)this.depth).currentName.equals(this.processingStack.get((int)this.depth).lastName);
            if (!isNextArrayElement) {
                if (this.isArrayElement(this.processingStack.get((int)this.depth).lastName)) {
                    this.processingStack.get((int)this.depth).writer.write("[");
                    this.processingStack.get((int)this.depth).lastIsArray = true;
                    this.processingStack.get((int)this.depth).writer.write(this.processingStack.get((int)this.depth).lastElementWriter.getContent());
                } else {
                    if (null != this.processingStack.get((int)this.depth).lastElementWriter) {
                        if (this.processingStack.get((int)this.depth).lastIsArray) {
                            this.processingStack.get((int)this.depth).writer.write(",");
                            this.processingStack.get((int)this.depth).writer.write(this.processingStack.get((int)this.depth).lastElementWriter.getContent());
                            this.processingStack.get((int)this.depth).writer.write("]");
                        } else {
                            this.processingStack.get((int)this.depth).writer.write(this.processingStack.get((int)this.depth).lastElementWriter.getContent());
                        }
                    }
                    this.processingStack.get((int)this.depth).lastIsArray = false;
                    if (null != this.processingStack.get((int)this.depth).lastName) {
                        if (this.processingStack.get((int)this.depth).lastIsArray) {
                            this.processingStack.get((int)this.depth).writer.write("]");
                            this.processingStack.get((int)this.depth).lastIsArray = false;
                        }
                        this.processingStack.get((int)this.depth).writer.write(",");
                    }
                    if (null == this.processingStack.get((int)this.depth).lastWasPrimitive) {
                        this.processingStack.get((int)this.depth).writer.write("{");
                    }
                    this.processingStack.get((int)this.depth).writer.write("\"" + localName + "\":");
                }
            } else {
                this.processingStack.get((int)this.depth).writer.write(this.processingStack.get((int)this.depth).lastIsArray ? "," : "[");
                this.processingStack.get((int)this.depth).lastIsArray = true;
                this.processingStack.get((int)this.depth).writer.write(this.processingStack.get((int)this.depth).lastElementWriter.getContent());
            }
            ++this.depth;
            this.processingStack.add(this.depth, this.createProcessingState());
        }
        catch (IOException ex) {
            Logger.getLogger(JsonXmlStreamWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writeStartElement(prefix, "@" + localName, namespaceURI);
        this.writeCharacters(value);
        this.writeEndElement();
    }

    private ProcessingState createProcessingState() {
        switch (this.depth) {
            case 0: {
                return new ProcessingState(this.stripRoot ? new DummyWriterAdapter() : new WriterAdapter(this.mainWriter));
            }
            case 1: {
                return this.stripRoot ? new ProcessingState(new WriterAdapter(this.mainWriter)) : new ProcessingState();
            }
        }
        return new ProcessingState();
    }

    private static final class ProcessingState {
        String lastName;
        String currentName;
        WriterAdapter lastElementWriter;
        Boolean lastWasPrimitive;
        boolean lastIsArray;
        WriterAdapter writer;

        ProcessingState() {
            this.writer = new StringWriterAdapter();
        }

        ProcessingState(WriterAdapter w) {
            this.writer = w;
        }

        public String toString() {
            return "PS(" + this.currentName + "|" + (this.writer != null ? this.writer.getContent() : null) + "|" + this.lastName + "|" + (this.lastElementWriter != null ? this.lastElementWriter.getContent() : null) + ")";
        }
    }

    private static final class DummyWriterAdapter
    extends WriterAdapter {
        DummyWriterAdapter() {
        }

        void write(String s) throws IOException {
        }

        String getContent() {
            return null;
        }
    }

    private static final class StringWriterAdapter
    extends WriterAdapter {
        StringWriterAdapter() {
            this.writer = new StringWriter();
        }

        String getContent() {
            return this.writer.toString();
        }
    }

    private static class WriterAdapter {
        Writer writer;

        WriterAdapter() {
        }

        WriterAdapter(Writer w) {
            this.writer = w;
        }

        void write(String s) throws IOException {
            assert (null != this.writer);
            this.writer.write(s);
        }

        String getContent() {
            return null;
        }
    }
}

