/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.modelapi.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodList
implements Iterable<Method> {
    Method[] methods;

    MethodList(Class c) {
        this(c.getMethods());
    }

    MethodList(Method ... methods) {
        this.methods = methods;
    }

    @Override
    public Iterator<Method> iterator() {
        return Arrays.asList(this.methods).iterator();
    }

    <T extends Annotation> MethodList hasAnnotation(final Class<T> annotation) {
        return this.filter(new Filter(){

            public boolean keep(Method m) {
                return m.getAnnotation(annotation) != null;
            }
        });
    }

    <T extends Annotation> MethodList hasMetaAnnotation(final Class<T> annotation) {
        return this.filter(new Filter(){

            public boolean keep(Method m) {
                for (Annotation a : m.getAnnotations()) {
                    if (a.annotationType().getAnnotation(annotation) == null) continue;
                    return true;
                }
                return false;
            }
        });
    }

    <T extends Annotation> MethodList hasNotAnnotation(final Class<T> annotation) {
        return this.filter(new Filter(){

            public boolean keep(Method m) {
                return m.getAnnotation(annotation) == null;
            }
        });
    }

    <T extends Annotation> MethodList hasNotMetaAnnotation(final Class<T> annotation) {
        return this.filter(new Filter(){

            public boolean keep(Method m) {
                for (Annotation a : m.getAnnotations()) {
                    if (a.annotationType().getAnnotation(annotation) == null) continue;
                    return false;
                }
                return true;
            }
        });
    }

    private MethodList filter(Filter f) {
        ArrayList<Method> r = new ArrayList<Method>();
        for (Method m : this.methods) {
            if (!f.keep(m)) continue;
            r.add(m);
        }
        return new MethodList(r.toArray(new Method[0]));
    }

    private static interface Filter {
        public boolean keep(Method var1);
    }
}

