/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.provider.entity;

import com.sun.ws.rest.impl.ImplMessages;
import com.sun.ws.rest.impl.json.JSONMarshaller;
import com.sun.ws.rest.impl.json.JSONUnmarshaller;
import com.sun.ws.rest.impl.json.reader.JsonXmlStreamReader;
import com.sun.ws.rest.impl.json.writer.JsonXmlStreamWriter;
import com.sun.ws.rest.impl.provider.entity.AbstractJAXBElementProvider;
import com.sun.ws.rest.impl.util.ThrowHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ProduceMime(value={"application/json"})
@ConsumeMime(value={"application/json"})
public final class JSONJAXBElementProvider
extends AbstractJAXBElementProvider {
    public Object readFrom(Class<Object> type, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream entityStream) throws IOException {
        try {
            JAXBContext context = this.getJAXBContext(type);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            if (unmarshaller instanceof JSONUnmarshaller) {
                unmarshaller.setProperty("com.sun.ws.rest.impl.json.enabled", (Object)Boolean.TRUE);
                JAXBElement jaxbElem = (JAXBElement)((JSONUnmarshaller)unmarshaller).unmarshal(entityStream, type);
                return jaxbElem.getValue();
            }
            return unmarshaller.unmarshal((XMLStreamReader)new JsonXmlStreamReader(new InputStreamReader(entityStream)));
        }
        catch (JAXBException cause) {
            throw ThrowHelper.withInitCause((Exception)((Object)cause), new IOException(ImplMessages.ERROR_MARSHALLING_JAXB(type)));
        }
    }

    public void writeTo(Object t, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream entityStream) throws IOException {
        try {
            JAXBContext context = this.getJAXBContext(t.getClass());
            Marshaller marshaller = context.createMarshaller();
            if (marshaller instanceof JSONMarshaller) {
                marshaller.setProperty("com.sun.ws.rest.impl.json.enabled", (Object)Boolean.TRUE);
                marshaller.marshal(t, entityStream);
            } else {
                marshaller.marshal(t, (XMLStreamWriter)new JsonXmlStreamWriter(new OutputStreamWriter(entityStream)));
            }
        }
        catch (JAXBException cause) {
            throw ThrowHelper.withInitCause((Exception)((Object)cause), new IOException(ImplMessages.ERROR_MARSHALLING_JAXB(t.getClass())));
        }
    }
}

