/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.provider.header;

import com.sun.ws.rest.impl.http.header.reader.HttpHeaderReader;
import com.sun.ws.rest.impl.http.header.reader.HttpHeaderReaderImpl;
import com.sun.ws.rest.impl.http.header.writer.WriterUtil;
import com.sun.ws.rest.spi.HeaderDelegateProvider;
import java.text.ParseException;
import java.util.Map;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaTypeProvider
implements HeaderDelegateProvider<MediaType> {
    @Override
    public boolean supports(Class<?> type) {
        return type == MediaType.class;
    }

    public String toString(MediaType header) {
        StringBuilder b = new StringBuilder();
        b.append(header.getType());
        b.append('/');
        b.append(header.getSubtype());
        for (String key : header.getParameters().keySet()) {
            b.append(';');
            b.append(key);
            b.append('=');
            WriterUtil.appendQuotedIfWhitespace(b, (String)header.getParameters().get(key));
        }
        return b.toString();
    }

    public MediaType fromString(String header) {
        try {
            if (header == null) {
                return new MediaType();
            }
            HttpHeaderReaderImpl reader = new HttpHeaderReaderImpl(header);
            ((HttpHeaderReader)reader).hasNext();
            String type = reader.nextToken();
            reader.nextSeparator('/');
            String subType = reader.nextToken();
            Map<String, String> params = null;
            if (((HttpHeaderReader)reader).hasNext()) {
                params = HttpHeaderReader.readParameters(reader);
            }
            return new MediaType(type, subType, params);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

