/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.uri;

import com.sun.ws.rest.api.uri.UriComponent;
import com.sun.ws.rest.api.uri.UriTemplate;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UriBuilderImpl
extends UriBuilder {
    private boolean encode = true;
    private String scheme;
    private String userInfo;
    private String host;
    private int port = -1;
    private final StringBuilder path;
    private final StringBuilder query;
    private String fragment;

    public UriBuilderImpl() {
        this.path = new StringBuilder();
        this.query = new StringBuilder();
    }

    private UriBuilderImpl(UriBuilderImpl that) {
        this.encode = that.encode;
        this.scheme = that.scheme;
        this.userInfo = that.userInfo;
        this.host = that.host;
        this.port = that.port;
        this.path = new StringBuilder(that.path);
        this.query = new StringBuilder(that.query);
        this.fragment = that.fragment;
    }

    public UriBuilder clone() {
        return new UriBuilderImpl(this);
    }

    public boolean isEncode() {
        return this.encode;
    }

    public UriBuilder encode(boolean enable) {
        this.encode = enable;
        return this;
    }

    public UriBuilder uri(URI uri) {
        if (uri.getScheme() != null) {
            this.scheme = uri.getScheme();
        }
        if (uri.getRawUserInfo() != null) {
            this.userInfo = uri.getRawUserInfo();
        }
        if (uri.getHost() != null) {
            this.host = uri.getHost();
        }
        if (uri.getPort() != -1) {
            this.port = uri.getPort();
        }
        if (uri.getRawPath() != null && uri.getRawPath().length() > 0) {
            this.path.setLength(0);
            this.path.append(uri.getRawPath());
        }
        if (uri.getRawQuery() != null && uri.getRawQuery().length() > 0) {
            this.query.setLength(0);
            this.query.append(uri.getRawQuery());
        }
        if (uri.getRawFragment() != null) {
            this.fragment = uri.getRawFragment();
        }
        return this;
    }

    public UriBuilder scheme(String scheme) {
        this.scheme = scheme;
        UriComponent.validate(scheme, UriComponent.Type.SCHEME, true);
        return this;
    }

    public UriBuilder schemeSpecificPart(String ssp) {
        URI uri = this.createURI(null, ssp, null);
        this.userInfo = uri.getRawUserInfo();
        this.host = uri.getHost();
        this.port = uri.getPort();
        this.path.setLength(0);
        this.path.append(this.replaceNull(uri.getRawPath()));
        this.query.setLength(0);
        this.query.append(this.replaceNull(uri.getRawQuery()));
        return this;
    }

    public UriBuilder userInfo(String ui) {
        this.userInfo = this.encode(ui, UriComponent.Type.USER_INFO);
        return this;
    }

    public UriBuilder host(String host) {
        this.host = this.encode(host, UriComponent.Type.HOST);
        return this;
    }

    public UriBuilder port(int port) {
        this.port = port;
        return this;
    }

    public UriBuilder replacePath(String ... segments) {
        this.path.setLength(0);
        this.path(segments);
        return this;
    }

    public UriBuilder path(String ... segments) {
        for (String segment : segments) {
            this.appendPath(segment);
        }
        return this;
    }

    public UriBuilder path(Class resource) {
        Path ut = resource.getAnnotation(Path.class);
        this.appendPath(ut);
        return this;
    }

    public UriBuilder path(Class resource, String methodName) {
        Method[] methods = resource.getDeclaredMethods();
        Method found = null;
        for (Method m : methods) {
            if (!methodName.equals(m.getName())) continue;
            if (found == null) {
                found = m;
                continue;
            }
            throw new IllegalArgumentException();
        }
        if (found == null) {
            throw new IllegalArgumentException();
        }
        this.appendPath(found.getAnnotation(Path.class));
        return this;
    }

    public UriBuilder path(Method ... methods) {
        for (Method m : methods) {
            this.appendPath(m.getAnnotation(Path.class));
        }
        return this;
    }

    public UriBuilder replaceMatrixParams(String matrix) {
        int i = this.path.lastIndexOf("/");
        if (i != -1) {
            i = 0;
        }
        if ((i = this.path.indexOf(";", i)) != -1) {
            this.path.setLength(i + 1);
        }
        this.path.append(this.encode(matrix, UriComponent.Type.PATH));
        return this;
    }

    public UriBuilder matrixParam(String name, String value) {
        if (this.path.length() > 0) {
            this.path.append(';');
        }
        this.path.append(this.encode(name, UriComponent.Type.PATH));
        if (value != null && value.length() > 0) {
            this.path.append('=').append(this.encode(value, UriComponent.Type.PATH));
        }
        return this;
    }

    public UriBuilder replaceQueryParams(String query) {
        this.query.setLength(0);
        this.query.append(this.encode(query, UriComponent.Type.QUERY));
        return this;
    }

    public UriBuilder queryParam(String name, String value) {
        if (this.query.length() > 0) {
            this.query.append('&');
        }
        this.query.append(this.encodeQuery(name));
        if (value != null && value.length() > 0) {
            this.query.append('=').append(this.encodeQuery(value));
        }
        return this;
    }

    public UriBuilder fragment(String fragment) {
        this.fragment = this.encode(fragment, UriComponent.Type.FRAGMENT);
        return this;
    }

    private void appendPath(Path t) {
        if (t == null) {
            throw new IllegalArgumentException();
        }
        boolean _encode = this.encode;
        this.encode = t.encode();
        this.appendPath(t.value());
        this.encode = _encode;
    }

    private void appendPath(String segment) {
        boolean segmentStartsWithSlash;
        if (segment == null || segment.length() == 0) {
            return;
        }
        segment = this.encode(segment, UriComponent.Type.PATH);
        boolean pathEndsInSlash = this.path.length() > 0 && this.path.charAt(this.path.length() - 1) == '/';
        boolean bl = segmentStartsWithSlash = segment.charAt(0) == '/';
        if (this.path.length() > 0 && !pathEndsInSlash && !segmentStartsWithSlash) {
            this.path.append('/');
        } else if (pathEndsInSlash && segmentStartsWithSlash && (segment = segment.substring(1)).length() == 0) {
            return;
        }
        this.path.append(segment);
    }

    private String encode(String s, UriComponent.Type type) {
        if (this.encode) {
            return UriComponent.encode(s, type, true);
        }
        UriComponent.validate(s, type, true);
        return s;
    }

    private String encodeQuery(String s) {
        block3: {
            if (this.encode) {
                try {
                    return URLEncoder.encode(s, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
        UriComponent.validate(s, UriComponent.Type.QUERY, true);
        return s;
    }

    public URI build() {
        return this.createURI(this.create());
    }

    public URI build(Map<String, String> values) {
        String uri = UriTemplate.createURI(this.scheme, this.userInfo, this.host, String.valueOf(this.port), this.path.toString(), this.query.toString(), this.fragment, values, this.encode);
        return this.createURI(uri);
    }

    public URI build(String ... values) {
        String uri = UriTemplate.createURI(this.scheme, this.userInfo, this.host, String.valueOf(this.port), this.path.toString(), this.query.toString(), this.fragment, values, this.encode);
        return this.createURI(uri);
    }

    private String create() {
        StringBuilder sb = new StringBuilder();
        if (this.scheme != null) {
            sb.append(this.scheme).append(':');
        }
        if (this.userInfo != null || this.host != null || this.port != -1) {
            sb.append("//");
            if (this.userInfo != null && this.userInfo.length() > 0) {
                sb.append(this.userInfo).append('@');
            }
            if (this.host != null) {
                sb.append(this.host);
            }
            if (this.port != -1) {
                sb.append(':').append(this.port);
            }
        }
        if (this.path.length() > 0) {
            if (sb.length() > 0 && this.path.charAt(0) != '/') {
                sb.append("/");
            }
            sb.append((CharSequence)this.path);
        }
        if (this.query.length() > 0) {
            sb.append('?').append((CharSequence)this.query);
        }
        if (this.fragment != null && this.fragment.length() > 0) {
            sb.append('#').append(this.fragment);
        }
        return sb.toString();
    }

    private URI createURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException ex) {
            throw new UriBuilderException((Throwable)ex);
        }
    }

    private URI createURI(String scheme, String ssp, String fragment) {
        try {
            return new URI(scheme, ssp, fragment);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String replaceNull(String s) {
        return s != null ? s : "";
    }
}

