/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.spi.container.servlet;

import com.sun.ws.rest.api.container.ContainerException;
import com.sun.ws.rest.api.core.ClasspathResourceConfig;
import com.sun.ws.rest.api.core.ResourceConfig;
import com.sun.ws.rest.impl.ThreadLocalInvoker;
import com.sun.ws.rest.impl.container.servlet.HttpRequestAdaptor;
import com.sun.ws.rest.impl.container.servlet.HttpResponseAdaptor;
import com.sun.ws.rest.spi.container.WebApplication;
import com.sun.ws.rest.spi.container.WebApplicationFactory;
import com.sun.ws.rest.spi.resource.Injectable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContainer
extends HttpServlet {
    private static final String RESOURCE_CONFIG_CLASS = "com.sun.ws.rest.config.property.resourceConfigClass";
    private final ThreadLocalInvoker<HttpServletRequest> requestInvoker = new ThreadLocalInvoker();
    private final ThreadLocalInvoker<HttpServletResponse> responseInvoker = new ThreadLocalInvoker();
    private ServletContext context;
    private WebApplication application;

    public final void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.context = servletConfig.getServletContext();
        ResourceConfig resourceConfig = this.createResourceConfig(servletConfig);
        this.initResourceConfigFeatures(servletConfig, resourceConfig);
        this.application = this.create();
        this.configure(servletConfig, resourceConfig, this.application);
        this.initiate(resourceConfig, this.application);
    }

    public final void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpRequestAdaptor requestAdaptor = new HttpRequestAdaptor(this.application.getMessageBodyContext(), req);
        HttpResponseAdaptor responseAdaptor = new HttpResponseAdaptor(this.context, resp, req, this.application.getMessageBodyContext(), requestAdaptor);
        try {
            this.requestInvoker.set(req);
            this.responseInvoker.set(resp);
            this.application.handleRequest(requestAdaptor, responseAdaptor);
        }
        catch (ContainerException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            this.requestInvoker.set(null);
            this.responseInvoker.set(null);
        }
        responseAdaptor.commitAll();
        if (responseAdaptor.getRequestDispatcher() != null) {
            responseAdaptor.getRequestDispatcher().forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    private ResourceConfig createResourceConfig(ServletConfig servletConfig) throws ServletException {
        Map<String, Object> props = this.getInitParams(servletConfig);
        String resourceConfigClassName = servletConfig.getInitParameter(RESOURCE_CONFIG_CLASS);
        if (resourceConfigClassName == null) {
            String[] paths = this.getPaths(servletConfig.getInitParameter("com.sun.ws.rest.config.property.classpath"));
            props.put("com.sun.ws.rest.config.property.classpath", paths);
            return new ClasspathResourceConfig(props);
        }
        try {
            Class<?> resourceConfigClass = this.getClassLoader().loadClass(resourceConfigClassName);
            if (resourceConfigClass == ClasspathResourceConfig.class) {
                String[] paths = this.getPaths(servletConfig.getInitParameter("com.sun.ws.rest.config.property.classpath"));
                props.put("com.sun.ws.rest.config.property.classpath", paths);
                return new ClasspathResourceConfig(props);
            }
            if (ResourceConfig.class.isAssignableFrom(resourceConfigClass)) {
                try {
                    Constructor<?> constructor = resourceConfigClass.getConstructor(Map.class);
                    return (ResourceConfig)constructor.newInstance(props);
                }
                catch (NoSuchMethodException ex) {
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
                try {
                    return (ResourceConfig)resourceConfigClass.newInstance();
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
            String message = "Resource configuration class, " + resourceConfigClassName + ", is not a super class of " + ResourceConfig.class;
            throw new ServletException(message);
        }
        catch (ClassNotFoundException e) {
            String message = "Resource configuration class, " + resourceConfigClassName + ", could not be loaded";
            throw new ServletException(message, (Throwable)e);
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader == null ? ((Object)((Object)this)).getClass().getClassLoader() : classLoader;
    }

    private Map<String, Object> getInitParams(ServletConfig servletConfig) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Enumeration names = servletConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            props.put(name, servletConfig.getInitParameter(name));
        }
        return props;
    }

    private String[] getPaths(String classpath) {
        if (classpath == null) {
            return new String[]{this.context.getRealPath("/WEB-INF/lib"), this.context.getRealPath("/WEB-INF/classes")};
        }
        String[] virtualPaths = classpath.split(";");
        ArrayList<String> resourcePaths = new ArrayList<String>();
        for (String virtualPath : virtualPaths) {
            if ((virtualPath = virtualPath.trim()).length() == 0) continue;
            resourcePaths.add(this.context.getRealPath(virtualPath));
        }
        return resourcePaths.toArray(new String[resourcePaths.size()]);
    }

    private void initResourceConfigFeatures(ServletConfig servletConfig, ResourceConfig rc) {
        this.setResourceConfigFeature(servletConfig, rc, "com.sun.ws.rest.config.feature.CanonicalizeURIPath");
        this.setResourceConfigFeature(servletConfig, rc, "com.sun.ws.rest.config.feature.IgnoreMatrixParams");
        this.setResourceConfigFeature(servletConfig, rc, "com.sun.ws.rest.config.feature.NormalizeURI");
        this.setResourceConfigFeature(servletConfig, rc, "com.sun.ws.rest.config.feature.Redirect");
        this.setResourceConfigFeature(servletConfig, rc, "com.sun.ws.rest.config.feature.ImplicitViewables");
    }

    private void setResourceConfigFeature(ServletConfig servletConfig, ResourceConfig rc, String feature) {
        String value = servletConfig.getInitParameter(feature);
        if (value != null) {
            rc.getFeatures().put(feature, Boolean.valueOf(value));
        }
    }

    protected WebApplication create() {
        return WebApplicationFactory.createWebApplication();
    }

    protected void configure(final ServletConfig sc, ResourceConfig rc, WebApplication wa) {
        wa.addInjectable((Type)((Object)HttpServletRequest.class), new ResourceInjectable<HttpServletRequest>(){

            @Override
            public HttpServletRequest getInjectableValue(Resource r) {
                HttpServletRequest servletRequest = (HttpServletRequest)Proxy.newProxyInstance(HttpServletRequest.class.getClassLoader(), new Class[]{HttpServletRequest.class}, (InvocationHandler)ServletContainer.this.requestInvoker);
                return servletRequest;
            }
        });
        wa.addInjectable((Type)((Object)HttpServletResponse.class), new ResourceInjectable<HttpServletResponse>(){

            @Override
            public HttpServletResponse getInjectableValue(Resource r) {
                HttpServletResponse servletResponse = (HttpServletResponse)Proxy.newProxyInstance(HttpServletResponse.class.getClassLoader(), new Class[]{HttpServletResponse.class}, (InvocationHandler)ServletContainer.this.responseInvoker);
                return servletResponse;
            }
        });
        wa.addInjectable((Type)((Object)ServletConfig.class), new ResourceInjectable<ServletConfig>(){

            @Override
            public ServletConfig getInjectableValue(Resource r) {
                return sc;
            }
        });
        wa.addInjectable((Type)((Object)ServletContext.class), new ResourceInjectable<ServletContext>(){

            @Override
            public ServletContext getInjectableValue(Resource r) {
                return sc.getServletContext();
            }
        });
    }

    protected void initiate(ResourceConfig rc, WebApplication wa) {
        wa.initiate(rc);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ResourceInjectable<V>
    extends Injectable<Resource, V> {
        private ResourceInjectable() {
        }

        @Override
        public Class<Resource> getAnnotationClass() {
            return Resource.class;
        }
    }
}

