/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.awt.Point;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.RequestProcessor;

public class Utils {
    private static Logger logger = Logger.getLogger("org.netbeans.modules.languages");
    private static Map<String, WeakReference> collections;

    public static void notify(String string) {
        logger.log(Level.WARNING, string);
    }

    public static void message(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
            }
        });
    }

    public static void notify(Exception exception) {
        logger.log(Level.WARNING, null, exception);
    }

    public static void notify(String string, Exception exception) {
        logger.log(Level.WARNING, string, exception);
    }

    public static void startTest(String string, Collection collection) {
        if (collections == null) {
            collections = new HashMap<String, WeakReference>();
            Utils.start();
        }
        collections.put(string, new WeakReference<Collection>(collection));
    }

    public static void startTest(String string, Map map) {
        if (collections == null) {
            collections = new HashMap<String, WeakReference>();
            Utils.start();
        }
        collections.put(string, new WeakReference<Map>(map));
    }

    private static void start() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                HashMap hashMap = new HashMap(collections);
                for (String string : hashMap.keySet()) {
                    Object t = ((WeakReference)hashMap.get(string)).get();
                    if (t == null) {
                        collections.remove(string);
                        continue;
                    }
                    System.out.println(":" + string + " " + Utils.size(t));
                }
                Utils.start();
            }
        }, 5000);
    }

    private static int size(Object object) {
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            int n = collection.size();
            for (Object e : collection) {
                if (!(e instanceof Collection) && !(e instanceof Map)) continue;
                n += Utils.size(e);
            }
            return n;
        }
        Map map = (Map)object;
        int n = map.size();
        for (Object k : map.keySet()) {
            Object v;
            if (k instanceof Collection || k instanceof Map) {
                n += Utils.size(k);
            }
            if (!((v = map.get(k)) instanceof Collection) && !(v instanceof Map)) continue;
            n += Utils.size(v);
        }
        return n;
    }

    public static Point findPosition(String string, int n) {
        int n2 = 0;
        int n3 = string.indexOf(10, n2);
        int n4 = 1;
        while (n3 >= 0) {
            if (n3 > n) {
                return new Point(n4, n - n2 + 1);
            }
            ++n4;
            n2 = n3 + 1;
            n3 = string.indexOf(10, n2);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static TokenSequence getTokenSequence(Document document, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        if (tokenHierarchy == null) {
            return null;
        }
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        if (tokenSequence == null) {
            return null;
        }
        while (true) {
            tokenSequence.move(n);
            if (!tokenSequence.moveNext()) {
                return tokenSequence;
            }
            TokenSequence tokenSequence2 = tokenSequence.embedded();
            if (tokenSequence2 == null) {
                return tokenSequence;
            }
            tokenSequence = tokenSequence2;
        }
    }
}

