/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.dataobject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.languages.dataobject.LanguagesDataLoader;
import org.netbeans.modules.languages.dataobject.LanguagesDataNode;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.DataEditorSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguagesDataObject
extends MultiDataObject {
    public LanguagesDataObject(FileObject fileObject, LanguagesDataLoader languagesDataLoader) throws DataObjectExistsException, IOException {
        super(fileObject, (MultiFileLoader)languagesDataLoader);
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add((Node.Cookie)DataEditorSupport.create((DataObject)this, (MultiDataObject.Entry)this.getPrimaryEntry(), (CookieSet)cookieSet));
    }

    protected Node createNodeDelegate() {
        return new LanguagesDataNode(this);
    }

    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String string) throws IOException {
        DataObject dataObject = super.handleCreateFromTemplate(dataFolder, string);
        FileObject fileObject = dataObject.getPrimaryFile();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("__CLASS_NAME__", string);
        hashMap.put("__PACKAGE_NAME__", LanguagesDataObject.getPackageName(fileObject));
        LanguagesDataObject.createFileWithSubstitutions(this.getPrimaryFile(), fileObject, hashMap);
        return dataObject;
    }

    static String getPackageName(FileObject fileObject) {
        FileObject fileObject2;
        for (fileObject2 = fileObject.getParent(); fileObject2 != null && !"src".equals(fileObject2.getNameExt()); fileObject2 = fileObject2.getParent()) {
        }
        return fileObject2 == null ? "test" : fileObject.getParent().getPath().substring(fileObject2.getPath().length() + 1).replace('/', '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createFileWithSubstitutions(FileObject fileObject, FileObject fileObject2, Map<String, String> map) throws IOException {
        FileLock fileLock = fileObject2.lock();
        try {
            LanguagesDataObject.copyAndSubstituteTokens(fileObject.getURL(), fileLock, fileObject2, map);
        }
        finally {
            fileLock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyAndSubstituteTokens(URL uRL, FileLock fileLock, FileObject fileObject, Map<String, String> map) throws IOException {
        OutputStream outputStream = fileObject.getOutputStream(fileLock);
        try {
            PrintWriter printWriter = new PrintWriter(outputStream);
            try {
                InputStream inputStream = uRL.openStream();
                try {
                    String string;
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    while ((string = bufferedReader.readLine()) != null) {
                        printWriter.println(map == null ? string : LanguagesDataObject.replaceTokens(map, string));
                    }
                }
                finally {
                    inputStream.close();
                }
            }
            finally {
                printWriter.close();
            }
        }
        finally {
            outputStream.close();
        }
    }

    private static String replaceTokens(Map<String, String> map, String string) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            string = string.replaceAll(entry.getKey(), entry.getValue());
        }
        return string;
    }
}

