/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.dataobject;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.TextAction;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.Settings;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUI;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.features.AnnotationManager;
import org.netbeans.modules.languages.features.BraceCompletionDeleteAction;
import org.netbeans.modules.languages.features.BraceCompletionInsertAction;
import org.netbeans.modules.languages.features.CodeCommentAction;
import org.netbeans.modules.languages.features.CodeUncommentAction;
import org.netbeans.modules.languages.features.CollapseFoldTypeAction;
import org.netbeans.modules.languages.features.DatabaseManager;
import org.netbeans.modules.languages.features.ExpandFoldTypeAction;
import org.netbeans.modules.languages.features.HyperlinkListener;
import org.netbeans.modules.languages.features.InstantRenameAction;
import org.netbeans.modules.languages.features.LanguagesGenerateFoldPopupAction;
import org.netbeans.modules.languages.features.MarkOccurrencesSupport;
import org.netbeans.modules.languages.features.SyntaxErrorHighlighter;
import org.netbeans.modules.languages.features.ToggleCommentAction;
import org.netbeans.modules.languages.parser.Pattern;

public class LanguagesEditorKit
extends NbEditorKit {
    private final String mimeType;
    static final Settings.Initializer INITIALIZER = new Settings.AbstractInitializer("LanguagesEditorKit.Settings.Initializer"){

        public void updateSettingsMap(Class clazz, Map map) {
            if (clazz != null && LanguagesEditorKit.class.isAssignableFrom(clazz)) {
                map.put("code-folding-enable", Boolean.TRUE);
            }
        }
    };
    private JLabel label;

    public LanguagesEditorKit(String string) {
        this.mimeType = string;
        if (string == null) {
            throw new NullPointerException();
        }
    }

    private JLabel createToolTipComponent() {
        if (this.label == null) {
            this.label = new JLabel(){

                public void setSize(int n, int n2) {
                    if (this.getText() == null) {
                        super.setSize(n, n2);
                        return;
                    }
                    int n3 = this.getText().length();
                    if (n3 > 0) {
                        Dimension dimension = this.getPreferredSize();
                        if (n > dimension.width) {
                            n = dimension.width;
                            n2 = n2 >= dimension.height ? dimension.height : -1;
                        } else {
                            super.setSize(n, 100000);
                            int n4 = this.getPreferredSize().height;
                            n2 = n4 < n2 ? n4 : -1;
                        }
                    }
                    if (n2 >= 0) {
                        super.setSize(n, n2);
                    } else {
                        this.putClientProperty(PopupManager.Placement.class, null);
                    }
                }
            };
            this.label.setActionMap(new ActionMap());
            this.label.setInputMap(1, null);
            Font font = UIManager.getFont("ToolTip.font");
            Color color = UIManager.getColor("ToolTip.background");
            Color color2 = UIManager.getColor("ToolTip.foreground");
            if (font != null) {
                this.label.setFont(font);
            }
            if (color2 != null) {
                this.label.setForeground(color2);
            }
            if (color != null) {
                this.label.setBackground(color);
            }
            this.label.setOpaque(true);
            this.label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.label.getForeground()), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        }
        return this.label;
    }

    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new BraceCompletionInsertAction(), new BraceCompletionDeleteAction(), new InstantRenameAction(), new LanguagesGenerateFoldPopupAction(), new ToggleCommentAction(), new CodeCommentAction(), new CodeUncommentAction()};
        return TextAction.augmentList(super.createActions(), actionArray);
    }

    public Action getActionByName(String string) {
        if (string == null) {
            return super.getActionByName(string);
        }
        if (string.startsWith("Expand:")) {
            string = string.substring("Expand:".length(), string.length());
            return new ExpandFoldTypeAction(string);
        }
        if (string.startsWith("Collapse:")) {
            string = string.substring("Collapse:".length(), string.length());
            return new CollapseFoldTypeAction(string);
        }
        return super.getActionByName(string);
    }

    protected EditorUI createEditorUI() {
        return new NbEditorUI(){
            private ToolTipSupport toolTipSupport;

            public ToolTipSupport getToolTipSupport() {
                if (this.toolTipSupport == null) {
                    this.toolTipSupport = new ToolTipSupport((ExtEditorUI)this){

                        public void setToolTipText(String string) {
                            if (string == null) {
                                return;
                            }
                            JLabel jLabel = LanguagesEditorKit.this.createToolTipComponent();
                            jLabel.setText(string);
                            this.setToolTip(jLabel);
                        }
                    };
                }
                return this.toolTipSupport;
            }
        };
    }

    public Document createDefaultDocument() {
        LanguagesDocument languagesDocument = new LanguagesDocument(((Object)((Object)this)).getClass());
        this.initDocument((Document)((Object)languagesDocument));
        return languagesDocument;
    }

    protected void initDocument(Document document) {
        document.putProperty("mimeType", this.mimeType);
        new AnnotationManager(document);
        new SyntaxErrorHighlighter(document);
        new DatabaseManager(document);
    }

    public void install(JEditorPane jEditorPane) {
        super.install(jEditorPane);
        HyperlinkListener hyperlinkListener = new HyperlinkListener();
        jEditorPane.addMouseMotionListener(hyperlinkListener);
        jEditorPane.addMouseListener(hyperlinkListener);
        jEditorPane.addKeyListener(hyperlinkListener);
        jEditorPane.addCaretListener(new MarkOccurrencesSupport(jEditorPane));
    }

    public String getContentType() {
        return this.mimeType;
    }

    public Object clone() {
        return new LanguagesEditorKit(this.mimeType);
    }

    private static final class LanguagesDocument
    extends NbEditorDocument {
        public LanguagesDocument(Class clazz) {
            super(clazz);
        }

        public boolean isIdentifierPart(char c) {
            try {
                Pattern pattern;
                String string = (String)this.getProperty("mimeType");
                Language language = LanguagesManager.getDefault().getLanguage(string);
                Feature feature = language.getFeatureList().getFeature("SELECTION");
                if (feature != null && (pattern = feature.getPattern()) != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(c);
                    return pattern.matches(stringBuffer.toString());
                }
            }
            catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
                // empty catch block
            }
            return super.isIdentifierPart(c);
        }
    }
}

