/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.Context;
import org.netbeans.api.languages.Highlighting;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.languages.database.DatabaseContext;
import org.netbeans.api.languages.database.DatabaseDefinition;
import org.netbeans.api.languages.database.DatabaseItem;
import org.netbeans.api.languages.database.DatabaseUsage;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.features.DatabaseManager;
import org.netbeans.modules.languages.features.FileNotParsedException;
import org.netbeans.modules.languages.features.Index;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;

public class HyperlinkListener
implements MouseMotionListener,
MouseListener,
KeyListener {
    private Highlighting.Highlight highlight;
    private Runnable runnable = null;
    private static AttributeSet hyperlinkAS = null;
    private static AttributeSet hyperlinkPressedAS = null;

    public void mouseMoved(MouseEvent mouseEvent) {
        JEditorPane jEditorPane = (JEditorPane)mouseEvent.getComponent();
        NbEditorDocument nbEditorDocument = (NbEditorDocument)jEditorPane.getDocument();
        if (this.highlight != null) {
            this.highlight.remove();
        }
        this.highlight = null;
        this.runnable = null;
        if (((mouseEvent.getModifiers() | mouseEvent.getModifiersEx()) & 0x80) != 128) {
            return;
        }
        int n = jEditorPane.viewToModel(mouseEvent.getPoint());
        this.highlight(nbEditorDocument, n);
        jEditorPane.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.runnable != null) {
            this.runnable.run();
            this.runnable = null;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (!keyEvent.isControlDown()) {
            if (this.highlight != null) {
                this.highlight.remove();
                this.highlight = null;
            }
            this.runnable = null;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void highlight(NbEditorDocument nbEditorDocument, int n) {
        block18: {
            try {
                Object object;
                Object object2;
                Object object3;
                ASTNode aSTNode = ParserManagerImpl.getImpl((Document)nbEditorDocument).getAST();
                if (aSTNode == null) {
                    String string = (String)nbEditorDocument.getProperty((Object)"mimeType");
                    TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)nbEditorDocument);
                    nbEditorDocument.readLock();
                    try {
                        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                        tokenSequence.move(n);
                        tokenSequence.moveNext();
                        Language language = LanguagesManager.getDefault().getLanguage(string);
                        Token token = tokenSequence.token();
                        if (token == null) {
                            return;
                        }
                        Feature feature = language.getFeatureList().getFeature("HYPERLINK", token.id().name());
                        if (feature == null) {
                            return;
                        }
                        ASTToken aSTToken = ASTToken.create(language, token.id().ordinal(), ((Object)token.text()).toString(), tokenSequence.offset());
                        this.highlight = Highlighting.getHighlighting((Document)nbEditorDocument).highlight(tokenSequence.offset(), tokenSequence.offset() + token.length(), HyperlinkListener.getHyperlinkAS());
                        this.runnable = (Runnable)feature.getValue(Context.create((Document)nbEditorDocument, n));
                    }
                    finally {
                        nbEditorDocument.readUnlock();
                    }
                    return;
                }
                ASTPath aSTPath = aSTNode.findPath(n);
                if (aSTPath == null) {
                    return;
                }
                int n2 = aSTPath.size();
                for (int i = 0; i < n2; ++i) {
                    object3 = aSTPath.subPath(i);
                    object2 = (Language)((ASTPath)object3).getLeaf().getLanguage();
                    if (object2 == null || (object = ((Language)object2).getFeatureList().getFeature("HYPERLINK", (ASTPath)object3)) == null) continue;
                    this.highlight = Highlighting.getHighlighting((Document)nbEditorDocument).highlight(((ASTPath)object3).getLeaf().getOffset(), ((ASTPath)object3).getLeaf().getEndOffset(), HyperlinkListener.getHyperlinkAS());
                    this.runnable = (Runnable)((Feature)object).getValue(SyntaxContext.create((Document)nbEditorDocument, (ASTPath)object3));
                }
                object3 = DatabaseManager.getRoot(aSTNode);
                if (object3 == null) break block18;
                object2 = ((DatabaseContext)object3).getDatabaseItem(n);
                if (object2 != null && object2 instanceof DatabaseUsage) {
                    this.highlight = Highlighting.getHighlighting((Document)nbEditorDocument).highlight(aSTPath.getLeaf().getOffset(), aSTPath.getLeaf().getEndOffset(), HyperlinkListener.getHyperlinkAS());
                    this.runnable = new Runnable((DatabaseItem)object2, nbEditorDocument){
                        final /* synthetic */ DatabaseItem val$item;
                        final /* synthetic */ NbEditorDocument val$document;
                        {
                            this.val$item = databaseItem;
                            this.val$document = nbEditorDocument;
                        }

                        public void run() {
                            Line line;
                            Line.Set set;
                            File file;
                            DatabaseDefinition databaseDefinition = ((DatabaseUsage)this.val$item).getDefinition();
                            int n = databaseDefinition.getOffset();
                            DataObject dataObject = null;
                            Object object = null;
                            URL uRL = databaseDefinition.getSourceFileUrl();
                            if (uRL == null) {
                                dataObject = NbEditorUtilities.getDataObject((Document)this.val$document);
                                object = this.val$document;
                            } else {
                                file = null;
                                try {
                                    file = new File(uRL.toURI());
                                }
                                catch (URISyntaxException uRISyntaxException) {
                                    uRISyntaxException.printStackTrace();
                                }
                                if (file != null && file.exists()) {
                                    file = FileUtil.normalizeFile((File)file);
                                    set = FileUtil.toFileObject((File)file);
                                    try {
                                        dataObject = DataObject.find((FileObject)set);
                                    }
                                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                                        dataObjectNotFoundException.printStackTrace();
                                    }
                                    if (dataObject != null) {
                                        line = dataObject.getNodeDelegate();
                                        EditorCookie editorCookie = (EditorCookie)line.getCookie(EditorCookie.class);
                                        try {
                                            object = editorCookie.openDocument();
                                        }
                                        catch (IOException iOException) {
                                            iOException.printStackTrace();
                                        }
                                    }
                                }
                            }
                            if (dataObject == null) {
                                return;
                            }
                            file = (LineCookie)dataObject.getCookie(LineCookie.class);
                            set = file.getLineSet();
                            line = set.getCurrent(NbDocument.findLineNumber((StyledDocument)object, (int)n));
                            int n2 = NbDocument.findLineColumn((StyledDocument)object, (int)n);
                            line.show(2, n2);
                        }
                    };
                }
                if (object2 != null) break block18;
                object = NbEditorUtilities.getFileObject((Document)nbEditorDocument);
                ASTItem aSTItem = aSTPath.getLeaf();
                if (!(aSTItem instanceof ASTToken)) {
                    return;
                }
                String string = ((ASTToken)aSTItem).getIdentifier();
                try {
                    Map<FileObject, List<DatabaseDefinition>> map = Index.getGlobalItem((FileObject)object, string, false);
                    if (!map.isEmpty()) {
                        final FileObject fileObject = map.keySet().iterator().next();
                        final DatabaseDefinition databaseDefinition = map.get(fileObject).iterator().next();
                        this.highlight = Highlighting.getHighlighting((Document)nbEditorDocument).highlight(aSTPath.getLeaf().getOffset(), aSTPath.getLeaf().getEndOffset(), HyperlinkListener.getHyperlinkAS());
                        this.runnable = new Runnable(){

                            public void run() {
                                int n = databaseDefinition.getOffset();
                                try {
                                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                                    EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                                    StyledDocument styledDocument = editorCookie.openDocument();
                                    LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
                                    Line.Set set = lineCookie.getLineSet();
                                    Line line = set.getCurrent(NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n));
                                    int n2 = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
                                    line.show(2, n2);
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                            }
                        };
                    }
                }
                catch (FileNotParsedException fileNotParsedException) {}
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private static AttributeSet getHyperlinkAS() {
        if (hyperlinkAS == null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(StyleConstants.Foreground, Color.blue);
            simpleAttributeSet.addAttribute(StyleConstants.Underline, Color.blue);
            hyperlinkAS = simpleAttributeSet;
        }
        return hyperlinkAS;
    }

    private static AttributeSet getHyperlinkPressedAS() {
        if (hyperlinkPressedAS == null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(StyleConstants.Foreground, Color.red);
            simpleAttributeSet.addAttribute(StyleConstants.Underline, Color.red);
            hyperlinkPressedAS = simpleAttributeSet;
        }
        return hyperlinkPressedAS;
    }
}

