/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.anttasks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.netbeans.modules.compapp.projects.jbi.anttasks.CasaBuilder;
import org.netbeans.modules.compapp.projects.jbi.anttasks.ConnectionResolver;
import org.netbeans.modules.compapp.projects.jbi.descriptor.XmlUtil;
import org.netbeans.modules.compapp.projects.jbi.descriptor.endpoints.model.Connection;
import org.netbeans.modules.compapp.projects.jbi.descriptor.endpoints.model.Endpoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAConnectionsBuilder
implements Serializable {
    public static final String QOS_NAMESPACE_URI = "http://www.sun.com/jbi/qos";
    public static final String VERSION_ATTR_NAME = "version";
    public static final String VERSION_ATTR_VALUE = "1.0";
    public static final String NS_ATTR_NAME = "xmlns";
    public static final String NS_ATTR_VALUE = "http://java.sun.com/xml/ns/jbi";
    public static final String NS_XSI_ATTR_NAME = "xmlns:xsi";
    public static final String NS_XSI_ATTR_VALUE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XSI_ATTR_NAME = "xsi:schemaLocation";
    public static final String XSI_ATTR_VALUE = "http://java.sun.com/xml/ns/jbi jbi.xsd";
    public static final String NAMESPACE_PREFIX = "ns";
    static Document document;

    public void buildDOMTree(ConnectionResolver container, String saName, String saDescription, Document casaDocument) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        document = builder.newDocument();
        Element root = document.createElement("jbi");
        root.setAttribute(VERSION_ATTR_NAME, VERSION_ATTR_VALUE);
        root.setAttribute(NS_ATTR_NAME, NS_ATTR_VALUE);
        Map<String, String> nsMap = container.getNamespaceMap();
        for (String key : nsMap.keySet()) {
            if (key == null) continue;
            String value = nsMap.get(key);
            root.setAttribute("xmlns:" + key, value);
        }
        document.appendChild(root);
        Element sroot = document.createElement("service-assembly");
        root.appendChild(sroot);
        Element id = document.createElement("identification");
        id.appendChild(this.createTextNode("name", saName));
        id.appendChild(this.createTextNode("description", saDescription));
        sroot.appendChild(id);
        List<Element> connectionsElements = this.createConnections(container, document, casaDocument);
        for (Element connections : connectionsElements) {
            sroot.appendChild(connections);
        }
    }

    public List<Element> createConnections(ConnectionResolver container, Document document, Document casaDocument) {
        ArrayList<Element> ret = new ArrayList<Element>();
        NodeList rs = document.getElementsByTagName("jbi");
        if (rs != null && rs.getLength() > 0) {
            Element root = (Element)rs.item(0);
            Element connections = document.createElement("connections");
            Element qosConnections = null;
            List<Element> casaConnectionElementsWithExtension = SAConnectionsBuilder.getCasaConnectionsWithExtensions(casaDocument);
            Map<String, String> nsMap = container.getNamespaceMap();
            for (Connection con : container.getConnectionList()) {
                Element casaConnection;
                Endpoint p;
                Endpoint c = con.getConsume();
                if (c.equals((Object)(p = con.getProvide()))) continue;
                Element connection = document.createElementNS(NS_ATTR_VALUE, "connection");
                Element consumes = this.createEndpoint(c, "consumer", root, nsMap, document);
                Element provides = this.createEndpoint(p, "provider", root, nsMap, document);
                connection.appendChild(consumes);
                connection.appendChild(provides);
                connections.appendChild(connection);
                if (casaDocument == null || (casaConnection = SAConnectionsBuilder.getCasaConnection(casaConnectionElementsWithExtension, casaDocument, c, p)) == null || casaConnection.getChildNodes().getLength() <= 0) continue;
                if (qosConnections == null) {
                    qosConnections = document.createElementNS(QOS_NAMESPACE_URI, "connections");
                }
                Element qosConnection = document.createElement("connection");
                qosConnection.appendChild(consumes.cloneNode(false));
                qosConnection.appendChild(provides.cloneNode(false));
                qosConnections.appendChild(qosConnection);
                CasaBuilder.deepCloneChildren(casaConnection, qosConnection);
            }
            ret.add(connections);
            if (qosConnections != null) {
                ret.add(qosConnections);
            }
        }
        return ret;
    }

    private static List<Element> getCasaConnectionsWithExtensions(Document casaDocument) {
        ArrayList<Element> ret = new ArrayList<Element>();
        if (casaDocument != null) {
            NodeList casaConnections = casaDocument.getElementsByTagName("connection");
            for (int i = 0; i < casaConnections.getLength(); ++i) {
                Element casaConnection = (Element)casaConnections.item(i);
                if (!casaConnection.hasChildNodes()) continue;
                ret.add(casaConnection);
            }
        }
        return ret;
    }

    private static Element getCasaConnection(List<Element> casaConnectionElements, Document casaDocument, Endpoint c, Endpoint p) {
        assert (casaConnectionElements != null && c != null && p != null);
        for (Element casaConnection : casaConnectionElements) {
            String consumerEndpointID = casaConnection.getAttribute("consumer");
            String providerEndpointID = casaConnection.getAttribute("provider");
            Endpoint consumer = CasaBuilder.getEndpoint(casaDocument, consumerEndpointID);
            Endpoint provider = CasaBuilder.getEndpoint(casaDocument, providerEndpointID);
            if (!c.equals((Object)consumer) || !p.equals((Object)provider)) continue;
            return casaConnection;
        }
        return null;
    }

    private Element createTextNode(String name, String text) {
        Element element = document.createElement(name);
        element.appendChild(document.createTextNode(text));
        return element;
    }

    private Element createEndpoint(Endpoint ep, String type, Element root, Map map, Document document) {
        Element endpointNode = document.createElement(type);
        endpointNode.setAttribute("service-name", this.xlateQName(ep.getServiceQName().toString(), root, map));
        endpointNode.setAttribute("endpoint-name", ep.getEndpointName());
        return endpointNode;
    }

    private String xlateQName(String qname, Element root, Map map) {
        String ns = this.getNS(qname);
        if (ns == null) {
            return qname;
        }
        String name = this.stripNS(qname);
        String prefix = this.findNamespacePrefix(map, ns, root);
        return prefix + ":" + name;
    }

    private String getNS(String name) {
        int k;
        if (name == null) {
            return null;
        }
        if (name.startsWith("{") && (k = name.indexOf(125)) > 0) {
            return name.substring(1, k);
        }
        return null;
    }

    private String stripNS(String name) {
        if (name == null) {
            return null;
        }
        int k = name.indexOf(125);
        if (k > 0) {
            return name.substring(k + 1);
        }
        return name;
    }

    private String findNamespacePrefix(Map<String, String> nsMap, String uri, Element root) {
        for (String prefix : nsMap.keySet()) {
            if (nsMap.get(prefix).compareTo(uri) != 0) continue;
            return prefix;
        }
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            String prefix;
            prefix = NAMESPACE_PREFIX + i;
            if (nsMap.get(prefix) != null) continue;
            nsMap.put(prefix, uri);
            root.setAttribute("xmlns:" + prefix, uri);
            return prefix;
        }
        return null;
    }

    public void writeToFile(String fileLocation) throws TransformerConfigurationException, TransformerException, Exception {
        XmlUtil.writeToFile((String)fileLocation, (Document)document);
    }

    public byte[] writeToBytes() throws TransformerConfigurationException, TransformerException, Exception {
        return XmlUtil.writeToBytes((Document)document);
    }

    public static void main(String[] args) {
    }
}

