/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLCompletionQuery;
import org.netbeans.editor.ext.html.SyntaxElement;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.dtd.InvalidateEvent;
import org.netbeans.editor.ext.html.dtd.InvalidateListener;
import org.netbeans.editor.ext.html.dtd.Registry;

public class HTMLSyntaxSupport
extends ExtSyntaxSupport
implements InvalidateListener {
    private static final String FALLBACK_DOCTYPE = "-//W3C//DTD HTML 4.01 Transitional//EN";
    private DTD dtd;
    private String docType;

    public static synchronized HTMLSyntaxSupport get(Document document) {
        HTMLSyntaxSupport hTMLSyntaxSupport = (HTMLSyntaxSupport)document.getProperty(HTMLSyntaxSupport.class);
        if (hTMLSyntaxSupport == null) {
            hTMLSyntaxSupport = new HTMLSyntaxSupport((BaseDocument)document);
            document.putProperty(HTMLSyntaxSupport.class, hTMLSyntaxSupport);
        }
        return hTMLSyntaxSupport;
    }

    public HTMLSyntaxSupport(BaseDocument baseDocument) {
        super(baseDocument);
    }

    public void dtdInvalidated(InvalidateEvent invalidateEvent) {
        if (this.dtd != null && invalidateEvent.isInvalidatedIdentifier(this.docType)) {
            this.dtd = null;
        }
    }

    public DTD getDTD() {
        String string = this.getDocType();
        if (string == null) {
            string = FALLBACK_DOCTYPE;
        }
        if (this.dtd != null && string == this.docType) {
            return this.dtd;
        }
        this.docType = string;
        this.dtd = Registry.getDTD(this.docType, null);
        if (this.dtd == null) {
            this.dtd = Registry.getDTD(FALLBACK_DOCTYPE, null);
        }
        return this.dtd;
    }

    protected String getDocType() {
        try {
            SyntaxElement syntaxElement = this.getElementChain(0);
            if (syntaxElement == null) {
                return null;
            }
            int n = syntaxElement.getType();
            while (n != 1 && n != 4 && (syntaxElement = syntaxElement.getNext()) != null) {
                n = syntaxElement.getType();
            }
            if (n == 1) {
                return ((SyntaxElement.Declaration)syntaxElement).getPublicIdentifier();
            }
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] findMatchingBlock(int n, boolean bl) throws BadLocationException {
        BaseDocument baseDocument = this.getDocument();
        baseDocument.readLock();
        try {
            Object object;
            int n2;
            int n3;
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            TokenSequence tokenSequence = HTMLSyntaxSupport.tokenSequence(tokenHierarchy, n);
            if (tokenSequence == null) {
                int[] nArray = null;
                return nArray;
            }
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                int[] nArray = null;
                return nArray;
            }
            Token token = tokenSequence.token();
            if (token.id() == HTMLTokenId.TAG_CLOSE_SYMBOL) {
                tokenSequence.moveIndex(tokenSequence.index() - 2);
                if (tokenSequence.moveNext()) {
                    token = tokenSequence.token();
                }
            }
            boolean bl2 = false;
            if (HTMLSyntaxSupport.isTagButNotSymbol(token)) {
                bl2 = true;
            } else {
                if (!tokenSequence.moveNext()) {
                    int[] nArray = null;
                    return nArray;
                }
                token = tokenSequence.token();
                if (token.id() == HTMLTokenId.TAG_OPEN_SYMBOL) {
                    if (token.id() != HTMLTokenId.TAG_CLOSE && token.id() != HTMLTokenId.TAG_OPEN) {
                        int[] nArray = null;
                        return nArray;
                    }
                    bl2 = true;
                } else {
                    n3 = 0;
                    while (!HTMLSyntaxSupport.isTagButNotSymbol(token) && token.id() != HTMLTokenId.TAG_CLOSE_SYMBOL && tokenSequence.movePrevious()) {
                        token = tokenSequence.token();
                    }
                    if (tokenSequence.index() != -1 && HTMLSyntaxSupport.isTagButNotSymbol(token)) {
                        bl2 = true;
                    }
                }
            }
            if (tokenSequence.index() != -1 && HTMLSyntaxSupport.isTagButNotSymbol(token) && bl2) {
                String string;
                n2 = -1;
                object = ((Object)token.text()).toString().toLowerCase().trim();
                if (token.id() == HTMLTokenId.TAG_CLOSE) {
                    do {
                        if (!HTMLSyntaxSupport.isTagButNotSymbol(token = tokenSequence.token())) continue;
                        string = ((Object)token.text()).toString().toLowerCase().trim();
                        if (string.equals(object) && token.id() == HTMLTokenId.TAG_OPEN && !this.isSingletonTag(tokenSequence)) {
                            if (n2 == 0) {
                                tokenSequence.movePrevious();
                                n3 = tokenSequence.token().offset(tokenHierarchy);
                                tokenSequence.moveIndex(tokenSequence.index() + 2);
                                tokenSequence.moveNext();
                                Token token2 = tokenSequence.token();
                                int n4 = token2.offset(tokenHierarchy) + (token2.id() == HTMLTokenId.TAG_CLOSE_SYMBOL ? token2.text().length() : 0);
                                int[] nArray = new int[]{n3, n4};
                                return nArray;
                            }
                            --n2;
                            continue;
                        }
                        if (string.indexOf((String)object) <= -1 || this.isSingletonTag(tokenSequence)) continue;
                        ++n2;
                    } while (tokenSequence.movePrevious());
                } else {
                    if (((String)object).charAt(0) == '>') {
                        int[] nArray = null;
                        return nArray;
                    }
                    if (this.isSingletonTag(tokenSequence)) {
                        int[] nArray = null;
                        return nArray;
                    }
                    do {
                        if (!HTMLSyntaxSupport.isTagButNotSymbol(token = tokenSequence.token())) continue;
                        string = ((Object)token.text()).toString().toLowerCase().trim();
                        if (string.equals(object) && token.id() == HTMLTokenId.TAG_CLOSE) {
                            if (n2 == 0) {
                                int n5 = token.offset(tokenHierarchy) + token.text().length() + 1;
                                tokenSequence.movePrevious();
                                n3 = tokenSequence.token().offset(tokenHierarchy);
                                do {
                                    token = tokenSequence.token();
                                } while (tokenSequence.moveNext() && token.id() != HTMLTokenId.TAG_CLOSE_SYMBOL);
                                if (tokenSequence.index() != -1) {
                                    n5 = token.offset(tokenHierarchy) + token.text().length();
                                }
                                int[] nArray = new int[]{n3, n5};
                                return nArray;
                            }
                            --n2;
                            continue;
                        }
                        if (!string.equals(object) || this.isSingletonTag(tokenSequence)) continue;
                        ++n2;
                    } while (tokenSequence.moveNext());
                }
            }
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                int[] nArray = null;
                return nArray;
            }
            token = tokenSequence.token();
            if (tokenSequence.index() == -1) return null;
            if (token.id() != HTMLTokenId.BLOCK_COMMENT) return null;
            String string = ((Object)token.text()).toString();
            if (string.startsWith("<!--") && n < token.offset(tokenHierarchy) + "<!--".length()) {
                do {
                    token = tokenSequence.token();
                    string = ((Object)token.text()).toString();
                    if (token.id() != HTMLTokenId.BLOCK_COMMENT) break;
                    if (!string.endsWith("-->")) continue;
                    int n6 = token.offset(tokenHierarchy) + string.length();
                    n2 = n6 - "-->".length();
                    object = new int[]{n2, n6};
                    return object;
                } while (tokenSequence.moveNext());
            }
            if (!string.endsWith("-->")) return null;
            if (n < token.offset(tokenHierarchy) + string.length() - "-->".length()) return null;
            do {
                if ((token = tokenSequence.token()).id() != HTMLTokenId.BLOCK_COMMENT) return null;
                if (!((Object)token.text()).toString().startsWith("<!--")) continue;
                int n7 = token.offset(tokenHierarchy);
                n2 = n7 + "<!--".length();
                object = new int[]{n7, n2};
                return object;
            } while (tokenSequence.movePrevious());
            return null;
        }
        finally {
            baseDocument.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSingletonTag(TokenSequence tokenSequence) {
        int n = tokenSequence.index();
        if (n != -1) {
            try {
                do {
                    Token token;
                    if ((token = tokenSequence.token()).id() == HTMLTokenId.TAG_CLOSE_SYMBOL) {
                        if ("/>".equals(((Object)token.text()).toString())) {
                            boolean bl = true;
                            return bl;
                        }
                        if (">".equals(((Object)token.text()).toString())) {
                            break;
                        }
                    }
                    if (token.id() == HTMLTokenId.TEXT) break;
                    if (token.id() != HTMLTokenId.TAG_OPEN_SYMBOL) continue;
                    break;
                } while (tokenSequence.moveNext());
            }
            finally {
                tokenSequence.moveIndex(n);
                tokenSequence.moveNext();
            }
        }
        return false;
    }

    public SyntaxElement getPreviousElement(int n) throws BadLocationException {
        return n == 0 ? null : this.getElementChain(n - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyntaxElement getElementChain(int n) throws BadLocationException {
        this.getDocument().readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.getDocument());
            TokenSequence tokenSequence = HTMLSyntaxSupport.tokenSequence(tokenHierarchy, n);
            if (tokenSequence == null) {
                Object object;
                TokenSequence tokenSequence2 = tokenHierarchy.tokenSequence();
                tokenSequence2.move(n);
                if (!tokenSequence2.movePrevious() && !tokenSequence2.moveNext()) {
                    SyntaxElement syntaxElement = null;
                    return syntaxElement;
                }
                int n2 = 0;
                while (tokenSequence2.movePrevious()) {
                    object = tokenSequence2.embedded(HTMLTokenId.language());
                    if (object == null || !object.moveNext() && !object.movePrevious()) continue;
                    n2 = object.offset() + object.token().length();
                    break;
                }
                object = this.getNextElement(n2);
                return object;
            }
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                SyntaxElement syntaxElement = null;
                return syntaxElement;
            }
            Token token = tokenSequence.token();
            int n3 = tokenSequence.offset();
            if (token.id() == HTMLTokenId.CHARACTER) {
                do {
                    token = tokenSequence.token();
                    n3 = tokenSequence.offset();
                } while (token.id() == HTMLTokenId.CHARACTER && tokenSequence.movePrevious());
                if (token.id() != HTMLTokenId.VALUE && token.id() != HTMLTokenId.TEXT) {
                    SyntaxElement syntaxElement = this.getNextElement(n3);
                    return syntaxElement;
                }
            }
            if (token.id() == HTMLTokenId.WS || token.id() == HTMLTokenId.ARGUMENT || token.id() == HTMLTokenId.OPERATOR || token.id() == HTMLTokenId.VALUE) {
                while (tokenSequence.movePrevious() && !HTMLSyntaxSupport.isTag(token = tokenSequence.token())) {
                }
                SyntaxElement syntaxElement = this.getNextElement(token.offset(tokenHierarchy));
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.TEXT) {
                do {
                    n3 = tokenSequence.offset();
                } while (tokenSequence.movePrevious() && (tokenSequence.token().id() == HTMLTokenId.TEXT || tokenSequence.token().id() == HTMLTokenId.CHARACTER));
                SyntaxElement syntaxElement = this.getNextElement(n3);
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.SCRIPT) {
                SyntaxElement syntaxElement = this.getNextElement(tokenSequence.token().offset(tokenHierarchy));
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.STYLE) {
                SyntaxElement syntaxElement = this.getNextElement(tokenSequence.token().offset(tokenHierarchy));
                return syntaxElement;
            }
            if (HTMLSyntaxSupport.isTag(token)) {
                if (token.id() == HTMLTokenId.TAG_OPEN || token.id() == HTMLTokenId.TAG_OPEN_SYMBOL) {
                    SyntaxElement syntaxElement = this.getNextElement(token.offset(tokenHierarchy));
                    return syntaxElement;
                }
                do {
                    if (tokenSequence.movePrevious()) continue;
                    SyntaxElement syntaxElement = this.getNextElement(token.offset(tokenHierarchy));
                    return syntaxElement;
                } while ((token = tokenSequence.token()).id() != HTMLTokenId.TAG_OPEN_SYMBOL);
                SyntaxElement syntaxElement = this.getNextElement(token.offset(tokenHierarchy));
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.ERROR) {
                SyntaxElement syntaxElement = new SyntaxElement(this, token.offset(tokenHierarchy), HTMLSyntaxSupport.getTokenEnd(tokenHierarchy, token), 2);
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.BLOCK_COMMENT) {
                while (token.id() == HTMLTokenId.BLOCK_COMMENT && !((Object)token.text()).toString().startsWith("<!--") && tokenSequence.movePrevious()) {
                    token = tokenSequence.token();
                }
                SyntaxElement syntaxElement = this.getNextElement(token.offset(tokenHierarchy));
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.DECLARATION || token.id() == HTMLTokenId.SGML_COMMENT) {
                while ((token.id() != HTMLTokenId.DECLARATION || !((Object)token.text()).toString().startsWith("<!")) && tokenSequence.movePrevious()) {
                    token = tokenSequence.token();
                }
                SyntaxElement syntaxElement = this.getNextElement(token.offset(tokenHierarchy));
                return syntaxElement;
            }
        }
        finally {
            this.getDocument().readUnlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyntaxElement getNextElement(int n) throws BadLocationException {
        this.getDocument().readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.getDocument());
            TokenSequence tokenSequence = HTMLSyntaxSupport.tokenSequence(tokenHierarchy, n);
            if (tokenSequence == null) {
                Object object;
                TokenSequence tokenSequence2 = tokenHierarchy.tokenSequence();
                tokenSequence2.move(n);
                if (!tokenSequence2.movePrevious() && !tokenSequence2.moveNext()) {
                    SyntaxElement syntaxElement = null;
                    return syntaxElement;
                }
                int n2 = this.getDocument().getLength();
                while (tokenSequence2.moveNext()) {
                    object = tokenSequence2.embedded(HTMLTokenId.language());
                    if (object == null) continue;
                    if (!object.moveNext()) {
                        SyntaxElement syntaxElement = null;
                        return syntaxElement;
                    }
                    n2 = object.offset();
                    break;
                }
                if (n == n2) {
                    object = null;
                    return object;
                }
                object = new SyntaxElement(this, n, n2, 8);
                return object;
            }
            tokenSequence.move(n);
            if (!tokenSequence.moveNext()) {
                SyntaxElement syntaxElement = null;
                return syntaxElement;
            }
            Token token = tokenSequence.token();
            int n3 = HTMLSyntaxSupport.getTokenEnd(tokenHierarchy, token);
            if (token.id() == HTMLTokenId.BLOCK_COMMENT) {
                do {
                    n3 = HTMLSyntaxSupport.getTokenEnd(tokenHierarchy, tokenSequence.token());
                } while (tokenSequence.token().id() == HTMLTokenId.BLOCK_COMMENT && tokenSequence.moveNext());
                SyntaxElement syntaxElement = new SyntaxElement(this, n, n3, 0);
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.DECLARATION) {
                Object object;
                String string;
                StringBuffer stringBuffer = new StringBuffer(token.text());
                while (token.id() == HTMLTokenId.DECLARATION || token.id() == HTMLTokenId.SGML_COMMENT) {
                    n3 = HTMLSyntaxSupport.getTokenEnd(tokenHierarchy, token);
                    if (!tokenSequence.moveNext()) break;
                    token = tokenSequence.token();
                    if (token.id() != HTMLTokenId.DECLARATION) continue;
                    stringBuffer.append(((Object)token.text()).toString());
                }
                if (!(string = stringBuffer.toString()).startsWith("<!DOCTYPE")) {
                    SyntaxElement.Declaration declaration = new SyntaxElement.Declaration(this, n, n3, null, null, null);
                    return declaration;
                }
                int n4 = (string = string.substring(9).trim()).indexOf(32);
                if (n4 < 0) {
                    SyntaxElement.Declaration declaration = new SyntaxElement.Declaration(this, n, n3, null, null, null);
                    return declaration;
                }
                String string2 = string.substring(0, n4);
                if ((string = string.substring(n4).trim()).startsWith("PUBLIC")) {
                    stringBuffer = new StringBuffer(string = string.substring(6).trim());
                    object = HTMLSyntaxSupport.getQuotedString(stringBuffer);
                    if (object != null) {
                        String string3 = HTMLSyntaxSupport.getQuotedString(stringBuffer);
                        SyntaxElement.Declaration declaration = new SyntaxElement.Declaration(this, n, n3, string2, (String)object, string3);
                        return declaration;
                    }
                } else if (string.startsWith("SYSTEM") && (object = HTMLSyntaxSupport.getQuotedString(stringBuffer = new StringBuffer(string = string.substring(6).trim()))) != null) {
                    SyntaxElement.Declaration declaration = new SyntaxElement.Declaration(this, n, n3, string2, null, (String)object);
                    return declaration;
                }
                object = new SyntaxElement.Declaration(this, n, n3, null, null, null);
                return object;
            }
            if (token.id() == HTMLTokenId.ERROR) {
                SyntaxElement syntaxElement = new SyntaxElement(this, token.offset(tokenHierarchy), n3, 2);
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.TEXT || token.id() == HTMLTokenId.CHARACTER) {
                do {
                    n3 = HTMLSyntaxSupport.getTokenEnd(tokenHierarchy, token);
                    token = tokenSequence.token();
                } while (tokenSequence.moveNext() && (token.id() == HTMLTokenId.TEXT || token.id() == HTMLTokenId.CHARACTER));
                SyntaxElement syntaxElement = new SyntaxElement(this, n, n3, 3);
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.SCRIPT) {
                SyntaxElement syntaxElement = new SyntaxElement(this, n, HTMLSyntaxSupport.getTokenEnd(tokenHierarchy, token), 6);
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.STYLE) {
                SyntaxElement syntaxElement = new SyntaxElement(this, n, HTMLSyntaxSupport.getTokenEnd(tokenHierarchy, token), 7);
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.TAG_CLOSE || token.id() == HTMLTokenId.TAG_OPEN_SYMBOL && ((Object)token.text()).toString().equals("</")) {
                String string = ((Object)token.text()).toString();
                if (token.id() == HTMLTokenId.TAG_OPEN_SYMBOL) {
                    tokenSequence.moveNext();
                    string = ((Object)tokenSequence.token().text()).toString();
                }
                tokenSequence.moveNext();
                token = tokenSequence.token();
                do {
                    token = tokenSequence.token();
                    n3 = HTMLSyntaxSupport.getTokenEnd(tokenHierarchy, token);
                } while (token.id() == HTMLTokenId.WS && tokenSequence.moveNext());
                if (token.id() == HTMLTokenId.TAG_CLOSE_SYMBOL) {
                    SyntaxElement.Named named = new SyntaxElement.Named(this, n, HTMLSyntaxSupport.getTokenEnd(tokenHierarchy, token), 5, string);
                    return named;
                }
                SyntaxElement.Named named = new SyntaxElement.Named(this, n, n3, 5, string);
                return named;
            }
            if (token.id() == HTMLTokenId.TAG_OPEN || token.id() == HTMLTokenId.TAG_OPEN_SYMBOL && !((Object)token.text()).toString().equals("</")) {
                Object object;
                String string = ((Object)token.text()).toString();
                ArrayList<SyntaxElement.TagAttribute> arrayList = new ArrayList<SyntaxElement.TagAttribute>();
                if (token.id() == HTMLTokenId.TAG_OPEN_SYMBOL) {
                    tokenSequence.moveNext();
                    string = ((Object)tokenSequence.token().text()).toString();
                }
                tokenSequence.moveNext();
                token = tokenSequence.token();
                Token token2 = null;
                do {
                    if ((token = tokenSequence.token()).id() == HTMLTokenId.ARGUMENT) {
                        token2 = token;
                    } else if (token.id() == HTMLTokenId.VALUE && token2 != null) {
                        object = new StringBuffer();
                        Token token3 = null;
                        do {
                            token3 = tokenSequence.token();
                            ((StringBuffer)object).append(((Object)token3.text()).toString());
                        } while (tokenSequence.moveNext() && (tokenSequence.token().id() == HTMLTokenId.VALUE || tokenSequence.token().id() == HTMLTokenId.CHARACTER));
                        SyntaxElement.TagAttribute tagAttribute = new SyntaxElement.TagAttribute(((Object)token2.text()).toString(), ((StringBuffer)object).toString(), token2.offset(tokenHierarchy), token.offset(tokenHierarchy));
                        arrayList.add(tagAttribute);
                        token2 = null;
                    }
                    n3 = HTMLSyntaxSupport.getTokenEnd(tokenHierarchy, token);
                } while ((token.id() == HTMLTokenId.WS || token.id() == HTMLTokenId.ARGUMENT || token.id() == HTMLTokenId.OPERATOR || token.id() == HTMLTokenId.VALUE || token.id() == HTMLTokenId.CHARACTER) && tokenSequence.moveNext());
                if (token.id() == HTMLTokenId.TAG_CLOSE_SYMBOL) {
                    object = new SyntaxElement.Tag(this, n, HTMLSyntaxSupport.getTokenEnd(tokenHierarchy, token), string, arrayList, ((Object)token.text()).toString().equals("/>"));
                    return object;
                }
                object = new SyntaxElement.Tag(this, n, n3, string, arrayList);
                return object;
            }
        }
        finally {
            this.getDocument().readUnlock();
        }
        return null;
    }

    public static boolean isTag(Token token) {
        return token.id() == HTMLTokenId.TAG_OPEN || token.id() == HTMLTokenId.TAG_CLOSE || token.id() == HTMLTokenId.TAG_OPEN_SYMBOL || token.id() == HTMLTokenId.TAG_CLOSE_SYMBOL;
    }

    public static boolean isTagButNotSymbol(Token token) {
        return token.id() == HTMLTokenId.TAG_OPEN || token.id() == HTMLTokenId.TAG_CLOSE;
    }

    private static int getTokenEnd(TokenHierarchy tokenHierarchy, Token token) {
        return token.offset(tokenHierarchy) + token.text().length();
    }

    private static String getQuotedString(StringBuffer stringBuffer) {
        char c;
        int n = 0;
        if (stringBuffer == null || stringBuffer.length() == 0) {
            return null;
        }
        while (stringBuffer.charAt(n) == ' ') {
            ++n;
        }
        if ((c = stringBuffer.charAt(n++)) == '\"' || c == '\'') {
            for (int i = n; i < stringBuffer.length(); ++i) {
                if (stringBuffer.charAt(i) != c) continue;
                String string = stringBuffer.substring(n, i);
                stringBuffer.delete(0, i + 1);
                return string;
            }
        }
        return null;
    }

    private static TokenSequence tokenSequence(TokenHierarchy tokenHierarchy, int n) {
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(HTMLTokenId.language());
        if (tokenSequence == null) {
            tokenSequence = tokenHierarchy.tokenSequence();
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return null;
            }
            tokenSequence = tokenSequence.embedded(HTMLTokenId.language());
        }
        return tokenSequence;
    }

    public List getPossibleEndTags(int n, String string) throws BadLocationException {
        string = string.toUpperCase();
        int n2 = string.length();
        SyntaxElement syntaxElement = this.getElementChain(n);
        Stack<String> stack = new Stack<String>();
        ArrayList<HTMLCompletionQuery.EndTagItem> arrayList = new ArrayList<HTMLCompletionQuery.EndTagItem>();
        HashSet<String> hashSet = new HashSet<String>();
        DTD dTD = this.getDTD();
        if (syntaxElement == null) {
            if (n > 0) {
                syntaxElement = this.getElementChain(n - 1);
                if (syntaxElement == null) {
                    return arrayList;
                }
            } else {
                return arrayList;
            }
        }
        int n3 = 0;
        for (syntaxElement = syntaxElement.getPrevious(); syntaxElement != null; syntaxElement = syntaxElement.getPrevious()) {
            DTD.Element element;
            if (syntaxElement.getType() == 5) {
                element = dTD.getElement(((SyntaxElement.Named)syntaxElement).getName().toUpperCase());
                if (element == null) continue;
                stack.push(((SyntaxElement.Named)syntaxElement).getName().toUpperCase());
                continue;
            }
            if (syntaxElement.getType() != 4 || (element = dTD.getElement(((SyntaxElement.Tag)syntaxElement).getName().toUpperCase())) == null || ((SyntaxElement.Tag)syntaxElement).isEmpty()) continue;
            String string2 = element.getName();
            if (stack.empty()) {
                if (string2.startsWith(string) && !hashSet.contains(string2)) {
                    hashSet.add(string2);
                    arrayList.add(new HTMLCompletionQuery.EndTagItem(string2, n - 2 - n2, n2 + 2, string2, n3));
                }
                if (element.hasOptionalEnd()) continue;
                break;
            }
            if (stack.peek().equals(string2)) {
                stack.pop();
                continue;
            }
            if (!element.hasOptionalEnd()) break;
        }
        return arrayList;
    }

    public List getAutocompletedEndTag(int n) {
        ArrayList<HTMLCompletionQuery.AutocompleteEndTagItem> arrayList = new ArrayList<HTMLCompletionQuery.AutocompleteEndTagItem>();
        try {
            SyntaxElement syntaxElement = this.getElementChain(n - 1);
            if (syntaxElement != null && syntaxElement.getType() == 4) {
                String string = ((SyntaxElement.Named)syntaxElement).getName();
                DTD.Element element = this.getDTD().getElement(string.toUpperCase());
                if (!(((SyntaxElement.Tag)syntaxElement).isEmpty() || element != null && element.isEmpty())) {
                    HTMLCompletionQuery.AutocompleteEndTagItem autocompleteEndTagItem = new HTMLCompletionQuery.AutocompleteEndTagItem(string, n);
                    arrayList.add(autocompleteEndTagItem);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkCompletion(JTextComponent jTextComponent, String string, boolean bl) {
        boolean bl2 = true;
        int n = jTextComponent.getCaret().getDot();
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        switch (string.charAt(string.length() - 1)) {
            case '/': {
                if (n < 2) break;
                try {
                    String string2 = baseDocument.getText(n - 2, 2);
                    if (string2.equals("</")) {
                        return 0;
                    }
                }
                catch (BadLocationException badLocationException) {}
                break;
            }
            case ' ': {
                baseDocument.readLock();
                try {
                    TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                    TokenSequence tokenSequence = HTMLSyntaxSupport.tokenSequence(tokenHierarchy, n - 1);
                    if (tokenSequence == null) {
                        int n2 = 3;
                        return n2;
                    }
                    tokenSequence.move(n - 1);
                    if ((tokenSequence.moveNext() || tokenSequence.movePrevious()) && tokenSequence.token().id() == HTMLTokenId.WS) {
                        int n3 = 0;
                        return n3;
                    }
                    break;
                }
                finally {
                    baseDocument.readUnlock();
                }
            }
            case '&': 
            case '<': {
                return 0;
            }
            case ';': {
                return 4;
            }
            case '>': {
                try {
                    SyntaxElement syntaxElement = this.getElementChain(n - 1);
                    if (syntaxElement != null && syntaxElement.getType() == 4) {
                        return 0;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                return 4;
            }
        }
        return 3;
    }
}

