/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.dtd;

import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.dtd.DTDParser;
import org.netbeans.editor.ext.html.dtd.InvalidateEvent;
import org.netbeans.editor.ext.html.dtd.InvalidateListener;
import org.netbeans.editor.ext.html.dtd.ReaderProvider;

public class Registry {
    private static Map dtdMap = new HashMap();
    private static List providers = new ArrayList();
    private static LinkedList listeners = new LinkedList();
    private static Map provider2dtds = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvalidateListener(InvalidateListener invalidateListener) {
        LinkedList linkedList = listeners;
        synchronized (linkedList) {
            listeners.add(new WeakReference<InvalidateListener>(invalidateListener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvalidateListener(InvalidateListener invalidateListener) {
        LinkedList linkedList = listeners;
        synchronized (linkedList) {
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference weakReference = (WeakReference)iterator.next();
                InvalidateListener invalidateListener2 = (InvalidateListener)weakReference.get();
                if (invalidateListener2 != null && invalidateListener2 != invalidateListener) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireInvalidateEvent(Set set) {
        Object object;
        Iterator iterator;
        Object object2 = set.iterator();
        while (object2.hasNext()) {
            dtdMap.remove(object2.next());
        }
        object2 = new ArrayList();
        Object object3 = listeners;
        synchronized (object3) {
            iterator = listeners.iterator();
            while (iterator.hasNext()) {
                object = (WeakReference)iterator.next();
                InvalidateListener invalidateListener = (InvalidateListener)((Reference)object).get();
                if (invalidateListener == null) {
                    iterator.remove();
                    continue;
                }
                object2.add(invalidateListener);
            }
        }
        object3 = new InvalidateEvent(set);
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = (InvalidateListener)iterator.next();
            object.dtdInvalidated((InvalidateEvent)object3);
        }
    }

    public static void registerReaderProvider(ReaderProvider readerProvider) {
        providers.add(readerProvider);
    }

    public static void invalidateReaderProvider(ReaderProvider readerProvider) {
        Set set = (Set)provider2dtds.get(readerProvider);
        if (set != null) {
            Registry.fireInvalidateEvent(set);
            provider2dtds.remove(readerProvider);
        }
    }

    public static void unregisterReaderProvider(ReaderProvider readerProvider) {
        providers.remove(readerProvider);
        Registry.invalidateReaderProvider(readerProvider);
    }

    private static DTD getWeak(String string) {
        WeakReference weakReference = (WeakReference)dtdMap.get(string);
        if (weakReference == null) {
            return null;
        }
        DTD dTD = (DTD)weakReference.get();
        if (dTD == null) {
            dtdMap.remove(string);
        }
        return dTD;
    }

    private static void putWeak(String string, DTD dTD) {
        dtdMap.put(string, new WeakReference<DTD>(dTD));
    }

    private static ReaderProvider getProvider(String string, String string2) {
        for (ReaderProvider readerProvider : providers) {
            Reader reader = readerProvider.getReaderForIdentifier(string, string2);
            if (reader == null) continue;
            return readerProvider;
        }
        return null;
    }

    private static DTD parseDTD(String string, String string2) {
        ReaderProvider readerProvider = Registry.getProvider(string, string2);
        if (readerProvider == null) {
            return null;
        }
        try {
            DTD dTD = new DTDParser().createDTD(readerProvider, string, string2);
            if (dTD != null) {
                HashSet<String> hashSet = (HashSet<String>)provider2dtds.get(readerProvider);
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                    provider2dtds.put(readerProvider, hashSet);
                }
                hashSet.add(string);
                Registry.putWeak(string, dTD);
            }
            return dTD;
        }
        catch (DTDParser.WrongDTDException wrongDTDException) {
            return null;
        }
    }

    public static DTD getDTD(String string, String string2) {
        DTD dTD = Registry.getWeak(string);
        if (dTD == null) {
            dTD = Registry.parseDTD(string, string2);
        }
        return dTD;
    }
}

