/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalogsupport.util;

import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.openide.filesystems.FileObject;

public class ProjectWSDL {
    private FileObject myFile;
    private Project myProject;

    public ProjectWSDL(FileObject fileObject, Project project) {
        this.myFile = fileObject;
        this.myProject = project;
    }

    public FileObject getFile() {
        return this.myFile;
    }

    public String getName() {
        return "[" + ProjectUtils.getInformation((Project)this.myProject).getDisplayName() + "] " + this.calculateRelativeName(this.myFile, this.myProject);
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ProjectWSDL)) {
            return false;
        }
        ProjectWSDL projectWSDL = (ProjectWSDL)object;
        return this.myFile.equals(projectWSDL.myFile) && this.myProject.equals(projectWSDL.myProject);
    }

    public int hashCode() {
        return this.myFile.hashCode() * this.myProject.hashCode();
    }

    private String calculateRelativeName(FileObject fileObject, Project project) {
        SourceGroup[] sourceGroupArray;
        if (fileObject == null) {
            return null;
        }
        String string = fileObject.getPath();
        Sources sources = ProjectUtils.getSources((Project)project);
        for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("generic")) {
            String string2 = sourceGroup.getRootFolder().getPath();
            if (!string.startsWith(string2)) continue;
            return this.removeSrcPrefix(string.substring(string2.length()));
        }
        return this.removeSrcPrefix(string);
    }

    private String removeSrcPrefix(String string) {
        if (string.startsWith("/src/")) {
            return string.substring("/src/".length());
        }
        return string;
    }
}

