/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.cnd.highlight.semantic.options.SemanticHighlightingOptions;
import org.openide.util.NbBundle;

public class SemanticHighlightingOptionsPanel
extends JPanel
implements ActionListener {
    private boolean isChanged = false;
    private JCheckBox cbClassFields;
    private JCheckBox cbFunctionNames;
    private JCheckBox cbKeepMarks;
    private JCheckBox cbMacros;
    private JCheckBox cbMarkOccurrences;
    private JCheckBox cbSysMacro;

    public SemanticHighlightingOptionsPanel() {
        this.initComponents();
        this.initMnemonics();
        this.cbKeepMarks.addActionListener(this);
        this.setName("TAB_SemanticHighlightingTab");
        if (!SemanticHighlightingOptions.SEMANTIC_ADVANCED) {
            this.cbClassFields.setVisible(false);
            this.cbFunctionNames.setVisible(false);
        }
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            this.setOpaque(false);
        }
    }

    void applyChanges() {
        SemanticHighlightingOptions.setEnableMarkOccurences(this.cbMarkOccurrences.isSelected());
        SemanticHighlightingOptions.setKeepMarks(this.cbKeepMarks.isSelected());
        SemanticHighlightingOptions.setEnableMacros(this.cbMacros.isSelected());
        SemanticHighlightingOptions.setDifferSystemMacros(this.cbSysMacro.isSelected());
        SemanticHighlightingOptions.setEnableClassFields(this.cbClassFields.isSelected());
        SemanticHighlightingOptions.setEnableFunctionNames(this.cbFunctionNames.isSelected());
        this.isChanged = false;
    }

    void update() {
        this.cbMarkOccurrences.setSelected(SemanticHighlightingOptions.getEnableMarkOccurences());
        this.cbKeepMarks.setSelected(SemanticHighlightingOptions.getKeepMarks());
        this.cbMacros.setSelected(SemanticHighlightingOptions.getEnableMacros());
        this.cbSysMacro.setSelected(SemanticHighlightingOptions.getDifferSystemMacros());
        this.cbClassFields.setSelected(SemanticHighlightingOptions.getEnableClassFields());
        this.cbFunctionNames.setSelected(SemanticHighlightingOptions.getEnableFunctionNames());
        this.updateValidation();
    }

    void cancel() {
        this.isChanged = false;
    }

    boolean isChanged() {
        return this.isChanged;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.isChanged = true;
    }

    private void updateValidation() {
        this.cbKeepMarks.setEnabled(this.cbMarkOccurrences.isSelected());
        this.cbSysMacro.setEnabled(this.cbMacros.isSelected());
    }

    private void initMnemonics() {
        this.cbMarkOccurrences.setMnemonic(SemanticHighlightingOptionsPanel.getString("EnableMarkOccurrences_Mnemonic").charAt(0));
        this.cbKeepMarks.setMnemonic(SemanticHighlightingOptionsPanel.getString("KeepMarks_Mnemonic").charAt(0));
        this.cbMacros.setMnemonic(SemanticHighlightingOptionsPanel.getString("EnableMacros_Mnemonic").charAt(0));
        this.cbSysMacro.setMnemonic(SemanticHighlightingOptionsPanel.getString("DifferSystemMacros_Mnemonic").charAt(0));
        this.cbClassFields.setMnemonic(SemanticHighlightingOptionsPanel.getString("ShowClassFields_Mnemonic").charAt(0));
        this.cbFunctionNames.setMnemonic(SemanticHighlightingOptionsPanel.getString("ShowFunctionNames_Mnemonic").charAt(0));
        this.cbMarkOccurrences.getAccessibleContext().setAccessibleDescription(SemanticHighlightingOptionsPanel.getString("EnableMarkOccurrences_AD"));
        this.cbKeepMarks.getAccessibleContext().setAccessibleDescription(SemanticHighlightingOptionsPanel.getString("KeepMarks_AD"));
        this.cbMacros.getAccessibleContext().setAccessibleDescription(SemanticHighlightingOptionsPanel.getString("EnableMacros_AD"));
        this.cbSysMacro.getAccessibleContext().setAccessibleDescription(SemanticHighlightingOptionsPanel.getString("DifferSystemMacros_AD"));
        this.cbClassFields.getAccessibleContext().setAccessibleDescription(SemanticHighlightingOptionsPanel.getString("ShowClassFields_AD"));
        this.cbFunctionNames.getAccessibleContext().setAccessibleDescription(SemanticHighlightingOptionsPanel.getString("ShowFunctionNames_AD"));
    }

    private void initComponents() {
        this.cbKeepMarks = new JCheckBox();
        this.cbMarkOccurrences = new JCheckBox();
        this.cbMacros = new JCheckBox();
        this.cbClassFields = new JCheckBox();
        this.cbFunctionNames = new JCheckBox();
        this.cbSysMacro = new JCheckBox();
        this.cbKeepMarks.setText(SemanticHighlightingOptionsPanel.getString("KeepMarks"));
        this.cbKeepMarks.setOpaque(false);
        this.cbMarkOccurrences.setText(SemanticHighlightingOptionsPanel.getString("EnableMarkOccurrences"));
        this.cbMarkOccurrences.setOpaque(false);
        this.cbMarkOccurrences.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SemanticHighlightingOptionsPanel.this.cbMarkOccurrencesActionPerformed(actionEvent);
            }
        });
        this.cbMacros.setText(SemanticHighlightingOptionsPanel.getString("EnableMacros"));
        this.cbMacros.setOpaque(false);
        this.cbMacros.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SemanticHighlightingOptionsPanel.this.cbMacrosActionPerformed(actionEvent);
            }
        });
        this.cbClassFields.setText(SemanticHighlightingOptionsPanel.getString("ShowClassFields"));
        this.cbClassFields.setOpaque(false);
        this.cbFunctionNames.setText(SemanticHighlightingOptionsPanel.getString("ShowFunctionNames"));
        this.cbFunctionNames.setOpaque(false);
        this.cbSysMacro.setText(SemanticHighlightingOptionsPanel.getString("DifferSystemMacros"));
        this.cbSysMacro.setOpaque(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(29, 29, 29).add((Component)this.cbKeepMarks)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.cbMarkOccurrences)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((Component)this.cbSysMacro)).add((Component)this.cbMacros))).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbClassFields).add((Component)this.cbFunctionNames)))).addContainerGap(283, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.cbMarkOccurrences).addPreferredGap(0).add((Component)this.cbKeepMarks).addPreferredGap(0).add((Component)this.cbMacros).addPreferredGap(0).add((Component)this.cbSysMacro).add(18, 18, 18).add((Component)this.cbClassFields).addPreferredGap(0).add((Component)this.cbFunctionNames).addContainerGap(112, Short.MAX_VALUE)));
    }

    private void cbMarkOccurrencesActionPerformed(ActionEvent actionEvent) {
        this.updateValidation();
    }

    private void cbMacrosActionPerformed(ActionEvent actionEvent) {
        this.updateValidation();
    }

    private static String getString(String string) {
        return NbBundle.getMessage(SemanticHighlightingOptionsPanel.class, (String)string);
    }
}

