/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.perforce;

import java.io.IOException;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.optional.perforce.P4Handler;
import org.apache.tools.ant.taskdefs.optional.perforce.SimpleP4OutputHandler;
import org.apache.tools.ant.types.Commandline;

public abstract class P4Base
extends Task {
    protected Perl5Util util = null;
    protected String shell;
    protected String P4Port = "";
    protected String P4Client = "";
    protected String P4User = "";
    protected String P4View = "";
    protected boolean failOnError = true;
    protected String P4Opts = "";
    protected String P4CmdOpts = "";
    private boolean inError = false;
    private String errorMessage = "";

    public boolean getInError() {
        return this.inError;
    }

    public void setInError(boolean inError) {
        this.inError = inError;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setPort(String p4Port) {
        this.P4Port = "-p" + p4Port;
    }

    public void setClient(String p4Client) {
        this.P4Client = "-c" + p4Client;
    }

    public void setUser(String p4User) {
        this.P4User = "-u" + p4User;
    }

    public void setGlobalopts(String p4Opts) {
        this.P4Opts = p4Opts;
    }

    public void setView(String p4View) {
        this.P4View = p4View;
    }

    public void setCmdopts(String p4CmdOpts) {
        this.P4CmdOpts = p4CmdOpts;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void init() {
        this.util = new Perl5Util();
        String tmpprop = this.getProject().getProperty("p4.port");
        if (tmpprop != null) {
            this.setPort(tmpprop);
        }
        if ((tmpprop = this.getProject().getProperty("p4.client")) != null) {
            this.setClient(tmpprop);
        }
        if ((tmpprop = this.getProject().getProperty("p4.user")) != null) {
            this.setUser(tmpprop);
        }
    }

    protected void execP4Command(String command) throws BuildException {
        this.execP4Command(command, null);
    }

    protected void execP4Command(String command, P4Handler handler) throws BuildException {
        try {
            this.inError = false;
            this.errorMessage = "";
            Commandline commandline = new Commandline();
            commandline.setExecutable("p4");
            if (this.P4Port != null && this.P4Port.length() != 0) {
                commandline.createArgument().setValue(this.P4Port);
            }
            if (this.P4User != null && this.P4User.length() != 0) {
                commandline.createArgument().setValue(this.P4User);
            }
            if (this.P4Client != null && this.P4Client.length() != 0) {
                commandline.createArgument().setValue(this.P4Client);
            }
            if (this.P4Opts != null && this.P4Opts.length() != 0) {
                commandline.createArgument().setLine(this.P4Opts);
            }
            commandline.createArgument().setLine(command);
            this.log(commandline.describeCommand(), 3);
            if (handler == null) {
                handler = new SimpleP4OutputHandler(this);
            }
            Execute exe = new Execute((ExecuteStreamHandler)handler, null);
            exe.setAntRun(this.getProject());
            exe.setCommandline(commandline.getCommandline());
            try {
                exe.execute();
                if (this.inError && this.failOnError) {
                    throw new BuildException(this.errorMessage);
                }
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            finally {
                try {
                    handler.stop();
                }
                catch (Exception e) {
                    this.log(e.toString(), 0);
                }
            }
        }
        catch (Exception e) {
            String failMsg = "Problem exec'ing P4 command: " + e.getMessage();
            if (this.failOnError) {
                throw new BuildException(failMsg);
            }
            this.log(failMsg, 0);
        }
    }
}

