/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoImage;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoRectangle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.util.AccessibleArea;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.util.JGoLabel;

public class BasicTitleBarUI
extends AccessibleArea {
    private static final Logger LOGGER = Logger.getLogger(BasicTitleBarUI.class.getName());
    private static final String EXPENDED_IMAGE_PATH = "expended.gif";
    private static final String COLLAPSED_IMAGE_PATH = "collapsed.gif";
    private static final JGoBrush TITLE_BRUSH = JGoBrush.makeStockBrush((Color)new Color(255, 255, 255, 0));
    private static final Color COLOR_INNER_BORDER = new Color(186, 205, 240);
    private static final Color DEFAULT_TEXT_COLOR = Color.BLACK;
    private int mLeftSpace = 2;
    private int mTitleIconAndTextGap = 2;
    private int mTitleTextAndButtonsGap = 2;
    private int mTopSpace = 1;
    private int mBottomSpace = 1;
    private int mButtonsGap = 2;
    private int minWidth = 0;
    private int minHeight = 0;
    private static Image mDefaultCollapsedIcon;
    private static Image mDefaultExpendedIcon;
    private JGoRectangle mBorderRect = new JGoRectangle();
    private JGoImage mCollapsedJGoImage;
    private JGoImage mExpandedJGoImage;
    private JGoImage mTitleJGoImage = new JGoImage();
    private JGoLabel mTitleLabel;

    public BasicTitleBarUI() {
        this(null);
    }

    public BasicTitleBarUI(String string) {
        this(string, null);
    }

    public BasicTitleBarUI(String string, Image image) {
        this(string, image, mDefaultExpendedIcon, mDefaultCollapsedIcon);
    }

    public BasicTitleBarUI(String string, Image image, Image image2, Image image3) {
        this.mExpandedJGoImage = new JGoImage();
        this.mCollapsedJGoImage = new JGoImage();
        this.mTitleLabel = new JGoLabel(string);
        this.mTitleLabel.setSelectable(false);
        this.mTitleLabel.setInsets(new Insets(0, 0, 0, 0));
        this.mTitleLabel.setPen(null);
        this.mTitleLabel.setTextColor(DEFAULT_TEXT_COLOR);
        this.setTitleIcon(image);
        this.setExpendedIcon(image2);
        this.setCollapseIcon(image3);
        this.mBorderRect.setSelectable(false);
        this.mTitleLabel.setSelectable(false);
        this.mTitleJGoImage.setSelectable(false);
        this.mExpandedJGoImage.setSelectable(false);
        this.mCollapsedJGoImage.setSelectable(false);
        this.mBorderRect.setResizable(false);
        this.mTitleLabel.setResizable(false);
        this.mTitleJGoImage.setResizable(false);
        this.mExpandedJGoImage.setResizable(false);
        this.mCollapsedJGoImage.setResizable(false);
        this.mTitleJGoImage.setDraggable(false);
        this.mTitleLabel.setDraggable(false);
        this.mExpandedJGoImage.setDraggable(false);
        this.mCollapsedJGoImage.setDraggable(false);
        this.mBorderRect.setDraggable(false);
        this.setResizable(false);
        this.setSelectable(false);
        this.setDraggable(true);
        this.mBorderRect.setBrush(TITLE_BRUSH);
        this.mBorderRect.setPen(JGoPen.makeStockPen((Color)COLOR_INNER_BORDER));
        this.addObjectAtTail((JGoObject)this.mTitleLabel);
        this.addObjectAtTail((JGoObject)this.mTitleJGoImage);
        this.addObjectAtTail((JGoObject)this.mExpandedJGoImage);
        this.addObjectAtTail((JGoObject)this.mCollapsedJGoImage);
        this.addObjectAtHead((JGoObject)this.mBorderRect);
        this.expand();
        this.ensureSize();
    }

    public Image getCollapseIcon() {
        return this.mCollapsedJGoImage.getImage();
    }

    public Image getExpendedIcon() {
        return this.mExpandedJGoImage.getImage();
    }

    public Font getFont() {
        return this.mTitleLabel.getFont();
    }

    public String getTitle() {
        return this.mTitleLabel.getText();
    }

    public Image getTitleIcon() {
        return this.mTitleJGoImage.getImage();
    }

    public boolean isInButton(Point point) {
        Rectangle rectangle = null;
        rectangle = this.mCollapsedJGoImage.isVisible() ? new Rectangle(this.mCollapsedJGoImage.getLocation(), this.mCollapsedJGoImage.getSize()) : new Rectangle(this.mExpandedJGoImage.getLocation(), this.mExpandedJGoImage.getSize());
        return rectangle.contains(point);
    }

    public void setCollapseIcon(Image image) {
        if (image == null) {
            this.removeObject((JGoObject)this.mCollapsedJGoImage);
            this.mCollapsedJGoImage = new JGoImage();
            this.mCollapsedJGoImage.setSelectable(false);
            this.mCollapsedJGoImage.setDraggable(false);
            this.mCollapsedJGoImage.setResizable(false);
            this.mCollapsedJGoImage.setSize(0, 0);
            this.addObjectAtTail((JGoObject)this.mCollapsedJGoImage);
        } else {
            this.mCollapsedJGoImage.loadImage(image, true);
            this.mCollapsedJGoImage.setSize(image.getWidth(null), image.getHeight(null));
        }
        this.ensureSize();
    }

    public void setExpendedIcon(Image image) {
        if (image == null) {
            this.removeObject((JGoObject)this.mExpandedJGoImage);
            this.mExpandedJGoImage = new JGoImage();
            this.mExpandedJGoImage.setSelectable(false);
            this.mExpandedJGoImage.setDraggable(false);
            this.mExpandedJGoImage.setResizable(false);
            this.mExpandedJGoImage.setSize(0, 0);
            this.addObjectAtTail((JGoObject)this.mExpandedJGoImage);
        } else {
            this.mExpandedJGoImage.loadImage(image, true);
            this.mExpandedJGoImage.setSize(image.getWidth(null), image.getHeight(null));
        }
        this.ensureSize();
    }

    public void setTitle(String string) {
        this.mTitleLabel.setText(string);
        this.ensureSize();
    }

    public void setTitleIcon(Image image) {
        if (image == null) {
            this.removeObject((JGoObject)this.mTitleJGoImage);
            this.mTitleJGoImage = new JGoImage();
            this.mTitleJGoImage.setSelectable(false);
            this.mTitleJGoImage.setDraggable(false);
            this.mTitleJGoImage.setResizable(false);
            this.mTitleJGoImage.setSize(0, 0);
            this.addObjectAtTail((JGoObject)this.mTitleJGoImage);
        } else {
            this.mTitleJGoImage.loadImage(image, true);
            this.mTitleJGoImage.setSize(image.getWidth(null), image.getHeight(null));
        }
        this.ensureSize();
    }

    public void collapse() {
        this.mCollapsedJGoImage.setVisible(true);
        this.mExpandedJGoImage.setVisible(false);
    }

    public void expand() {
        this.mCollapsedJGoImage.setVisible(false);
        this.mExpandedJGoImage.setVisible(true);
    }

    public void geometryChange(Rectangle rectangle) {
        if (rectangle.width == this.getWidth() && rectangle.height == this.getHeight()) {
            super.geometryChange(rectangle);
        } else {
            this.ensureSize();
        }
    }

    public int getMinimumWidth() {
        return this.mLeftSpace + this.mTitleJGoImage.getWidth() + this.mTitleIconAndTextGap + this.mTitleLabel.getWidth() + this.mTitleTextAndButtonsGap + Math.max(this.mExpandedJGoImage.getWidth(), this.mCollapsedJGoImage.getWidth()) + this.mButtonsGap;
    }

    public int getMinimumHeight() {
        return this.mTopSpace + Math.max(Math.max(this.mTitleLabel.getHeight(), this.mTitleJGoImage.getHeight()), Math.max(this.mExpandedJGoImage.getWidth(), this.mCollapsedJGoImage.getWidth())) + this.mBottomSpace;
    }

    public void resizeToMinimum() {
        this.setSize(this.getMinimumWidth(), this.getMinimumHeight());
    }

    private void ensureSize() {
        int n = this.getMinimumWidth();
        if (this.getWidth() < n) {
            this.setWidth(n);
            return;
        }
        int n2 = this.getMinimumHeight();
        if (this.getHeight() < n2) {
            this.setHeight(n2);
            return;
        }
        this.layoutChildren();
    }

    protected void layoutChildren() {
        this.mTitleJGoImage.setLeft(this.getLeft() + this.mLeftSpace);
        this.mTitleJGoImage.setTop(this.getTop() + this.mTopSpace);
        this.mTitleLabel.setSpotLocation(1, (JGoObject)this.mTitleJGoImage, 3);
        this.mTitleLabel.setLeft(this.mTitleLabel.getLeft() + this.mTitleIconAndTextGap);
        this.mExpandedJGoImage.setSpotLocation(3, (JGoObject)this, 3);
        this.mExpandedJGoImage.setLeft(this.mExpandedJGoImage.getLeft() - this.mButtonsGap);
        this.mExpandedJGoImage.setTop(this.mExpandedJGoImage.getTop() + this.mButtonsGap);
        this.mCollapsedJGoImage.setSpotLocation(1, (JGoObject)this.mExpandedJGoImage, 1);
        this.mBorderRect.setBoundingRect(this.getBoundingRect());
    }

    public void setTitleBarBackground(Color color) {
    }

    public void resetTitleBarBackground() {
    }

    public Color getTitleBarBackground() {
        return this.mBorderRect.getBrush().getColor();
    }

    static {
        try {
            mDefaultExpendedIcon = new ImageIcon(BasicTitleBarUI.class.getResource(EXPENDED_IMAGE_PATH)).getImage();
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.SEVERE, "unable to load default expended icon", throwable);
        }
        try {
            mDefaultCollapsedIcon = new ImageIcon(BasicTitleBarUI.class.getResource(COLLAPSED_IMAGE_PATH)).getImage();
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.SEVERE, "unable to load default collapsed icon", throwable);
        }
    }
}

