/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.util;

import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicCanvasFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasMapperLink;

public class DrawPort
extends JGoRectangle {
    public static final Color COLOR_NORMAL = new Color(0, 24, 127);
    public static final Color COLOR_ACTIVATED = ICanvasMapperLink.DEFAULT_LINK_SELECTED_COLOR;
    public static final Dimension SIZE_NORMAL = new Dimension(8, 8);
    public static final Dimension SIZE_HOVER = new Dimension(10, 10);
    private BasicCanvasFieldNode mFieldNode;
    private boolean mIsHovering;
    private boolean mIsActivated;
    private boolean mIsConnected;
    private int mSideLength;
    private Dimension mDrawSize;
    private Point mDrawLocation = new Point(0, 0);

    public DrawPort(BasicCanvasFieldNode basicCanvasFieldNode) {
        this.mFieldNode = basicCanvasFieldNode;
        this.setIsHovering(false);
    }

    public BasicCanvasFieldNode getFieldNode() {
        return this.mFieldNode;
    }

    public void setIsHovering(boolean bl) {
        this.mIsHovering = bl;
        this.mDrawSize = bl ? SIZE_HOVER : SIZE_NORMAL;
        this.mSideLength = this.mDrawSize.width;
    }

    public boolean isHovering() {
        return this.mIsHovering;
    }

    public void setIsActivated(boolean bl) {
        this.mIsActivated = bl;
    }

    public boolean isActivated() {
        return this.mIsActivated;
    }

    public void setIsConnected(boolean bl) {
        this.mIsConnected = bl;
    }

    public boolean isConnected() {
        return this.mIsConnected;
    }

    public void setDrawLocation(int n, int n2) {
        this.mDrawLocation = new Point(n, n2);
    }

    public Dimension getDrawSize() {
        return this.mDrawSize;
    }

    protected static void setAntiAliasing(Graphics2D graphics2D, boolean bl) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    protected static void drawDashedSquare(Graphics2D graphics2D, Point point, int n, int n2) {
        int n3 = (n - n2) / 2;
        int n4 = n3 - 1;
        int n5 = n - n3;
        int n6 = point.x + (n - 1);
        int n7 = point.y + (n - 1);
        graphics2D.drawLine(point.x, point.y, point.x + n4, point.y);
        graphics2D.drawLine(point.x + n5, point.y, n6, point.y);
        graphics2D.drawLine(point.x, n7, point.x + n4, n7);
        graphics2D.drawLine(point.x + n5, n7, n6, n7);
        graphics2D.drawLine(point.x, point.y, point.x, point.y + n4);
        graphics2D.drawLine(point.x, point.y + n5, point.x, n7);
        graphics2D.drawLine(n6, point.y, n6, point.y + n4);
        graphics2D.drawLine(n6, point.y + n5, n6, n7);
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        Point point = this.mDrawLocation;
        graphics2D.setColor(this.mIsActivated ? COLOR_ACTIVATED : COLOR_NORMAL);
        if (this.mIsConnected) {
            DrawPort.setAntiAliasing(graphics2D, false);
            if (this.mIsHovering) {
                graphics2D.fillRect(point.x + 3, point.y + 3, 4, 4);
                DrawPort.drawDashedSquare(graphics2D, point, this.mSideLength, 4);
            } else {
                graphics2D.fillRect(point.x + 2, point.y + 2, 4, 4);
                DrawPort.drawDashedSquare(graphics2D, point, this.mSideLength, 2);
            }
            DrawPort.setAntiAliasing(graphics2D, true);
        } else if (this.mIsHovering) {
            DrawPort.setAntiAliasing(graphics2D, false);
            DrawPort.drawDashedSquare(graphics2D, point, this.mSideLength, 4);
            DrawPort.setAntiAliasing(graphics2D, true);
        }
    }
}

