/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.literal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.netbeans.modules.soa.mapper.basicmapper.literal.AbstractLiteralEditor;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.basicmapper.literal.ILiteralUpdater;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;

public class BasicCharacterLiteralEditor
extends AbstractLiteralEditor {
    private JTextField mEditorComponent = new JTextField();

    public BasicCharacterLiteralEditor(Window window, IBasicMapper iBasicMapper, IFieldNode iFieldNode, ILiteralUpdater iLiteralUpdater) {
        super(window, iBasicMapper, iFieldNode, iLiteralUpdater);
        this.mEditorComponent.setHorizontalAlignment(0);
        this.mEditorComponent.setDocument(new PlainDocument(){

            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (string != null && string.length() > 0) {
                    super.remove(0, super.getLength());
                    super.insertString(0, string.substring(0, 1), attributeSet);
                }
            }
        });
        this.mEditorComponent.setText(iFieldNode.getLiteralName());
        this.mEditorComponent.selectAll();
        this.initializeLiteralComponent(iBasicMapper.getMapperViewManager().getCanvasView(), this.mEditorComponent, this.mEditorComponent);
        if (this.mIsLiteralMethoid) {
            this.mEditorComponent.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        } else {
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 1), BorderFactory.createEmptyBorder(1, 2, 1, 1));
            this.mEditorComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), compoundBorder));
        }
        this.getContentPane().add(this.mEditorComponent);
    }

    protected Dimension getInitialSize() {
        Dimension dimension = this.mCanvasFieldNode.getBounding().getSize();
        return new Dimension(dimension.width - 1, dimension.height - 1);
    }

    protected String updateLiteral() {
        return this.mEditorComponent.getText();
    }
}

