/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.util;

import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;

public class DragableLabel
extends JButton
implements DragGestureListener,
Transferable {
    protected static final DataFlavor[] DEFAULT_FLAVORS = new DataFlavor[1];
    protected boolean mIsDraggable = true;
    protected Cursor mDragCursor = DragSource.DefaultCopyDrop;
    protected Map dataFlavorMap;
    protected Object mDefaultData;
    protected DragGestureRecognizer mRecognizer;

    public DragableLabel() {
        this.init();
    }

    public DragableLabel(Icon icon) {
        super(icon);
        this.init();
    }

    public DragableLabel(Icon icon, int n) {
        super(icon);
        this.setHorizontalAlignment(n);
        this.init();
    }

    public DragableLabel(String string) {
        super(string);
        this.init();
    }

    public DragableLabel(String string, Icon icon, int n) {
        super(string, icon);
        this.setHorizontalAlignment(n);
        this.init();
    }

    public DragableLabel(String string, int n) {
        super(string);
        this.setHorizontalAlignment(n);
        this.init();
    }

    public DataFlavor getDefaultDataFlavor() {
        return DEFAULT_FLAVORS[0];
    }

    public int getDragAction() {
        return this.mRecognizer.getSourceActions();
    }

    public Cursor getDragCursor() {
        return this.mDragCursor;
    }

    public Object getTransferData(DataFlavor dataFlavor) {
        return this.dataFlavorMap.get(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.dataFlavorMap.keySet().toArray(new DataFlavor[0]);
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        if (dataFlavorArray != null && dataFlavorArray.length > 0) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavor.equals(dataFlavorArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDraggable() {
        return this.mIsDraggable;
    }

    public void setDefaultTransferData(Object object) {
        if (object == null) {
            this.dataFlavorMap.put(this.getDefaultDataFlavor(), this);
        }
        this.dataFlavorMap.put(this.getDefaultDataFlavor(), object);
    }

    public void setDragAction(int n) {
        this.mRecognizer.setSourceActions(n);
    }

    public void setDragCursor(Cursor cursor) {
        if (cursor == null) {
            this.mDragCursor = DragSource.DefaultCopyDrop;
        }
        this.mDragCursor = cursor;
    }

    public void setDraggable(boolean bl) {
        this.mIsDraggable = bl;
    }

    public void addDataFlavor(DataFlavor dataFlavor, Object object) {
        this.dataFlavorMap.put(dataFlavor, object);
    }

    public void addDragSourceListener(DragSourceListener dragSourceListener) {
        DragSource.getDefaultDragSource().addDragSourceListener(dragSourceListener);
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
        this.doClick(0);
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if (this.isEnabled() && this.isVisible() && this.isDraggable()) {
            DragSource.getDefaultDragSource().startDrag(dragGestureEvent, this.mDragCursor, this, null);
        }
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void removeDataFlavor(DataFlavor dataFlavor) {
        this.dataFlavorMap.remove(dataFlavor);
    }

    public void removeDragSourceListener(DragSourceListener dragSourceListener) {
        DragSource.getDefaultDragSource().removeDragSourceListener(dragSourceListener);
    }

    private void init() {
        this.mRecognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 3, this);
        this.dataFlavorMap = Collections.synchronizedMap(new HashMap());
        this.dataFlavorMap.put(DEFAULT_FLAVORS[0], this);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseExit(MouseEvent mouseEvent) {
                DragableLabel.this.doClick(0);
            }
        });
    }

    static {
        try {
            DragableLabel.DEFAULT_FLAVORS[0] = new DataFlavor("application/x-java-jvm-local-objectref");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

