/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.common.palette;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.modules.soa.mapper.common.palette.PaletteManager;
import org.netbeans.modules.soa.mapper.common.palette.PaletteNode;
import org.openide.ErrorManager;
import org.openide.nodes.Index;

class PalettePopupMenu
extends JPopupMenu {
    private PaletteNode mPalNode;

    public PalettePopupMenu(PaletteNode paletteNode) {
        this.mPalNode = paletteNode;
        ResourceBundle resourceBundle = PaletteManager.getBundle();
        JMenuItem jMenuItem = new JMenuItem(resourceBundle.getString("CTL_CreateCategory"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PalettePopupMenu.this.createCategory();
            }
        });
        this.add(jMenuItem);
        this.addSeparator();
        jMenuItem = new JMenuItem(resourceBundle.getString("CTL_OrderCategories"));
        jMenuItem.setEnabled(this.mPalNode.getCookie(Index.class) != null);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PalettePopupMenu.this.reorderCategories();
            }
        });
        this.add(jMenuItem);
    }

    private void reorderCategories() {
        Index index = (Index)this.mPalNode.getCookie(Index.class);
        if (index != null) {
            index.reorder();
        }
    }

    private void createCategory() {
        try {
            this.mPalNode.createNewCategory();
        }
        catch (IOException iOException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                iOException.printStackTrace(System.err);
            }
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }
}

