/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.common.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DNDTable
extends JTable
implements DropTargetListener,
DragSourceListener,
DragGestureListener,
MouseListener,
KeyListener {
    protected TableModel mTableModel;
    protected Object mDataObject;
    protected DropTarget mDropTarget = null;
    protected DragSource mDragSource = null;
    protected DataFlavor[] mDataFlavorArray = new DataFlavor[1];
    private int mDragTargetRow;

    public DNDTable(TableModel tableModel) {
        super(tableModel);
        this.init();
    }

    protected void init() {
        this.mDragTargetRow = -1;
        this.mDropTarget = new DropTarget(this, this);
        this.mDragSource = new DragSource();
        this.mDragSource.createDefaultDragGestureRecognizer(this, 1, this);
        try {
            this.mDataFlavorArray[0] = new DataFlavor("application/x-java-jvm-local-objectref");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    public void setDataObject(Object object) {
        this.mDataObject = object;
    }

    public Object getDataObject() {
        return this.mDataObject;
    }

    public void setColumnWidth(int n, int n2) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        tableColumnModel.getColumn(n).setPreferredWidth(n2);
    }

    public void setColumnMinWidth(int n, int n2) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        tableColumnModel.getColumn(n).setMinWidth(n2);
    }

    public void setResizable(int n, boolean bl) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        tableColumnModel.getColumn(n).setResizable(bl);
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Object object = this.mDataObject;
        if (object != null) {
            StringSelection stringSelection = new StringSelection(object.toString());
            this.mDragSource.startDrag(dragGestureEvent, DragSource.DefaultMoveDrop, stringSelection, this);
        } else {
            System.out.println("nothing was selected");
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(1);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(this.mDataFlavorArray[0])) {
                dropTargetDropEvent.acceptDrop(1);
                Object object = transferable.getTransferData(this.mDataFlavorArray[0]);
                this.setDataObject(object);
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println("Exception" + iOException.getMessage());
            dropTargetDropEvent.rejectDrop();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
            System.err.println("Exception" + unsupportedFlavorException.getMessage());
            dropTargetDropEvent.rejectDrop();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        if (dragSourceDropEvent.getDropSuccess()) {
            System.out.println(" dragDropEnd -> DropSuccess");
        } else {
            System.out.println(" dragDropEnd -> DropRejected");
        }
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

