/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.bracesmatching.support;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.netbeans.spi.editor.bracesmatching.support.CharacterMatcher;

public final class BracesMatcherSupport {
    private static final char[] DEFAULT_CHARS = new char[]{'(', ')', '[', ']', '{', '}', '<', '>'};

    public static BracesMatcher defaultMatcher(MatcherContext matcherContext, int n, int n2) {
        return new CharacterMatcher(matcherContext, n, n2, DEFAULT_CHARS);
    }

    public static BracesMatcher characterMatcher(MatcherContext matcherContext, int n, int n2, char ... cArray) {
        return new CharacterMatcher(matcherContext, n, n2, cArray);
    }

    public static int[] findChar(Document document, int n, int n2, char ... cArray) throws BadLocationException {
        assert (cArray.length % 2 == 0) : "The pairs parameter must contain even number of characters.";
        boolean bl = n2 < n;
        int n3 = bl ? n - n2 : n2 - n;
        int[] nArray = new int[3];
        if (bl) {
            Segment segment = new Segment();
            document.getText(n - n3, n3, segment);
            for (int i = n3 - 1; i >= 0; --i) {
                if (MatcherContext.isTaskCanceled()) {
                    return null;
                }
                if (!BracesMatcherSupport.detectOrigin(nArray, segment.array[segment.offset + i], cArray)) continue;
                nArray[0] = n - (n3 - i);
                return nArray;
            }
        } else {
            Segment segment = new Segment();
            document.getText(n, n3, segment);
            for (int i = 0; i < n3; ++i) {
                if (MatcherContext.isTaskCanceled()) {
                    return null;
                }
                if (!BracesMatcherSupport.detectOrigin(nArray, segment.array[segment.offset + i], cArray)) continue;
                nArray[0] = n + i;
                return nArray;
            }
        }
        return null;
    }

    public static int matchChar(Document document, int n, int n2, char c, char c2) throws BadLocationException {
        int n3;
        boolean bl = n2 < n;
        int n4 = n3 = bl ? n - n2 : n2 - n;
        if (bl) {
            Segment segment = new Segment();
            document.getText(n - n3, n3, segment);
            int n5 = 0;
            for (int i = n3 - 1; i >= 0; --i) {
                if (MatcherContext.isTaskCanceled()) {
                    return -1;
                }
                if (c == segment.array[segment.offset + i]) {
                    ++n5;
                    continue;
                }
                if (c2 != segment.array[segment.offset + i]) continue;
                if (n5 == 0) {
                    return n - (n3 - i);
                }
                --n5;
            }
        } else {
            Segment segment = new Segment();
            document.getText(n, n3, segment);
            int n6 = 0;
            for (int i = 0; i < n3; ++i) {
                if (MatcherContext.isTaskCanceled()) {
                    return -1;
                }
                if (c == segment.array[segment.offset + i]) {
                    ++n6;
                    continue;
                }
                if (c2 != segment.array[segment.offset + i]) continue;
                if (n6 == 0) {
                    return n + i;
                }
                --n6;
            }
        }
        return -1;
    }

    private static boolean detectOrigin(int[] nArray, char c, char ... cArray) {
        int n = cArray.length / 2;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n2 = 2 * j + i;
                if (c != cArray[n2]) continue;
                nArray[1] = n2;
                nArray[2] = i == 0 ? 1 : -1;
                return true;
            }
        }
        return false;
    }

    private static BracesMatcherFactory defaultMatcherFactory() {
        return new BracesMatcherFactory(){

            public BracesMatcher createMatcher(MatcherContext matcherContext) {
                return BracesMatcherSupport.defaultMatcher(matcherContext, -1, -1);
            }
        };
    }

    private BracesMatcherSupport() {
    }
}

