/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.ui.basic.SchemaTreeCategory;
import org.netbeans.modules.xml.schema.ui.basic.UIUtilities;
import org.netbeans.modules.xml.schema.ui.nodes.DefaultExpandedCookie;
import org.netbeans.modules.xml.schema.ui.nodes.SchemaNodeFactory;
import org.netbeans.modules.xml.schema.ui.nodes.StructuralSchemaNodeFactory;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.CategorizedSchemaNodeFactory;
import org.netbeans.modules.xml.schema.ui.nodes.schema.SchemaNode;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class SchemaTreeView
extends JPanel
implements ExplorerManager.Provider,
Lookup.Provider,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private ExplorerManager explorerManager;
    private Lookup lookup;
    private TreeView treeView = new BeanTreeView();

    public SchemaTreeView(SchemaModel schemaModel, ViewType viewType, Lookup lookup) {
        super(new BorderLayout());
        SchemaNodeFactory schemaNodeFactory;
        this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SchemaTreeCategory.class, (String)"LBL_SchemaCategory_Tree"));
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SchemaTreeCategory.class, (String)"HINT_SchemaCategory_Tree"));
        this.treeView.setRootVisible(true);
        this.treeView.setSelectionMode(4);
        this.treeView.setVerticalScrollBarPolicy(22);
        this.add((Component)this.treeView, "Center");
        switch (viewType) {
            case CATEGORIZED: {
                schemaNodeFactory = new CategorizedSchemaNodeFactory(schemaModel, lookup);
                break;
            }
            case STRUCTURAL: {
                schemaNodeFactory = new StructuralSchemaNodeFactory(schemaModel, lookup);
                break;
            }
            default: {
                schemaNodeFactory = null;
            }
        }
        SchemaNode schemaNode = schemaNodeFactory.createRootNode();
        this.explorerManager = new ExplorerManager();
        this.explorerManager.setRootContext((Node)schemaNode);
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.explorerManager));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.explorerManager));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.explorerManager));
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.explorerManager, (boolean)false));
        this.lookup = ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)actionMap);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SchemaTreeView.this.expandDefaultNodes();
            }
        });
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public void requestFocus() {
        super.requestFocus();
        this.treeView.requestFocus();
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.treeView.requestFocusInWindow();
    }

    private void expandDefaultNodes() {
        Object object;
        Node node = this.getExplorerManager().getRootContext();
        int n = 0;
        do {
            if (((Node[])(object = node.getChildren().getNodes())).length == 1) {
                this.treeView.expandNode(object[0]);
                node = object[0];
                ++n;
                continue;
            }
            for (Node node2 : object) {
                DefaultExpandedCookie defaultExpandedCookie = (DefaultExpandedCookie)node2.getCookie(DefaultExpandedCookie.class);
                if (defaultExpandedCookie == null || !defaultExpandedCookie.isDefaultExpanded()) continue;
                this.treeView.expandNode(node2);
            }
            node = null;
        } while (node != null && n < 5);
        object = (JTree)this.treeView.getViewport().getView();
        if (((JTree)object).getRowCount() > ((JTree)object).getVisibleRowCount()) {
            node = this.getExplorerManager().getRootContext();
            Enumeration enumeration = node.getChildren().nodes();
            while (enumeration.hasMoreElements()) {
                Node node3 = (Node)enumeration.nextElement();
                this.treeView.collapseNode(node3);
            }
        }
    }

    private TopComponent findParentTopComponent() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof TopComponent)) continue;
            return (TopComponent)container;
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        TopComponent topComponent;
        Node[] nodeArray;
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName()) && (nodeArray = (Node[])propertyChangeEvent.getNewValue()) != null && nodeArray.length >= 1 && (topComponent = this.findParentTopComponent()) != null) {
            topComponent.setActivatedNodes(nodeArray);
        }
    }

    public void showComponent(SchemaComponent schemaComponent) {
        List<Node> list = UIUtilities.findPathFromRoot(this.getExplorerManager().getRootContext(), schemaComponent);
        if (list == null || list.isEmpty()) {
            return;
        }
        Node node = list.get(list.size() - 1);
        try {
            this.getExplorerManager().setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ViewType {
        CATEGORIZED,
        STRUCTURAL;

    }
}

