/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.nodes.categorized;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponentReference;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.ui.nodes.DefaultExpandedCookie;
import org.netbeans.modules.xml.schema.ui.nodes.ReadOnlyCookie;
import org.netbeans.modules.xml.schema.ui.nodes.RefreshableChildren;
import org.netbeans.modules.xml.schema.ui.nodes.SchemaUIContext;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.AdvancedNewTypesFactory;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ui.ComponentPasteType;
import org.netbeans.modules.xml.xam.ui.XAMUtils;
import org.netbeans.modules.xml.xam.ui.cookies.CountChildrenCookie;
import org.netbeans.modules.xml.xam.ui.highlight.Highlight;
import org.netbeans.modules.xml.xam.ui.highlight.HighlightManager;
import org.netbeans.modules.xml.xam.ui.highlight.Highlighted;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryNode
extends AbstractNode
implements Node.Cookie,
ComponentListener,
Highlighted,
CountChildrenCookie {
    private static final SystemAction[] ACTIONS = new SystemAction[]{SystemAction.get(PasteAction.class), null, SystemAction.get(NewAction.class)};
    private static final SystemAction[] ACTIONS_READONLY = new SystemAction[0];
    private SchemaUIContext context;
    private SchemaComponentReference<? extends SchemaComponent> reference;
    private Set<Component> referenceSet;
    private List<Highlight> highlights;
    private Class<? extends SchemaComponent> childType;
    private InstanceContent lookupContents;
    private ComponentListener weakComponentListener;
    private String badge;

    public CategoryNode(SchemaUIContext schemaUIContext, SchemaComponentReference<? extends SchemaComponent> schemaComponentReference, Class<? extends SchemaComponent> clazz, RefreshableChildren refreshableChildren) {
        this(schemaUIContext, schemaComponentReference, clazz, (Children)refreshableChildren, new InstanceContent());
    }

    private CategoryNode(SchemaUIContext schemaUIContext, SchemaComponentReference<? extends SchemaComponent> schemaComponentReference, Class<? extends SchemaComponent> clazz, Children children, InstanceContent instanceContent) {
        Object object;
        block7: {
            super(children, CategoryNode.createLookup(schemaUIContext, instanceContent));
            this.context = schemaUIContext;
            this.reference = schemaComponentReference;
            this.childType = clazz;
            this.lookupContents = instanceContent;
            try {
                object = (FileObject)this.reference.get().getModel().getModelSource().getLookup().lookup(FileObject.class);
                if (object != null) {
                    instanceContent.add((Object)DataObject.find((FileObject)object));
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
            instanceContent.add((Object)this);
            instanceContent.add((Object)schemaUIContext);
            instanceContent.add((Object)new DefaultExpandedCookie(true));
            if (clazz.equals(SchemaComponent.class) && children instanceof Index) {
                instanceContent.add((Object)children);
            }
            object = clazz.getName();
            try {
                object = NbBundle.getMessage(CategoryNode.class, (String)("LBL_CategoryNode_" + (String)object));
            }
            catch (MissingResourceException missingResourceException) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)missingResourceException);
            }
        }
        this.setName((String)object);
        this.setDisplayName((String)object);
        SchemaModel schemaModel = schemaComponentReference.get().getModel();
        this.weakComponentListener = (ComponentListener)WeakListeners.create(ComponentListener.class, (EventListener)((Object)this), (Object)schemaModel);
        schemaModel.addComponentListener(this.weakComponentListener);
        this.referenceSet = new HashSet<Component>();
        this.highlights = new LinkedList<Highlight>();
        HighlightManager highlightManager = HighlightManager.getDefault();
        SchemaComponent schemaComponent = this.reference.get();
        List list = schemaComponent.getChildren(clazz);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.referenceSet.add((Component)iterator.next());
        }
        highlightManager.addHighlighted((Highlighted)this);
    }

    private static Lookup createLookup(SchemaUIContext schemaUIContext, InstanceContent instanceContent) {
        return new ProxyLookup(new Lookup[]{Lookups.exclude((Lookup)schemaUIContext.getLookup(), (Class[])new Class[]{Node.class, DataObject.class}), new AbstractLookup((AbstractLookup.Content)instanceContent)});
    }

    public boolean equals(Object object) {
        if (object instanceof CategoryNode) {
            CategoryNode categoryNode = (CategoryNode)((Object)object);
            String string = this.getName();
            String string2 = categoryNode.getName();
            if (string != null && string2 != null) {
                SchemaComponentReference<? extends SchemaComponent> schemaComponentReference = categoryNode.getReference();
                return string.equals(string2) && schemaComponentReference.equals(this.reference);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public int getChildCount() {
        return this.getReference().get().getChildren(this.getChildType()).size();
    }

    public SchemaUIContext getContext() {
        return this.context;
    }

    public SchemaComponentReference<? extends SchemaComponent> getReference() {
        return this.reference;
    }

    public Class<? extends SchemaComponent> getChildType() {
        return this.childType;
    }

    protected InstanceContent getLookupContents() {
        return this.lookupContents;
    }

    public boolean isDefaultExpanded() {
        DefaultExpandedCookie defaultExpandedCookie = (DefaultExpandedCookie)this.getCookie(DefaultExpandedCookie.class);
        if (defaultExpandedCookie != null) {
            return defaultExpandedCookie.isDefaultExpanded();
        }
        return false;
    }

    public void setDefaultExpanded(boolean bl) {
        DefaultExpandedCookie defaultExpandedCookie = (DefaultExpandedCookie)this.getCookie(DefaultExpandedCookie.class);
        if (defaultExpandedCookie != null) {
            defaultExpandedCookie.setDefaultExpanded(bl);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    public boolean canCut() {
        return false;
    }

    public boolean canCopy() {
        return false;
    }

    protected void createPasteTypes(Transferable transferable, List list) {
        PasteType pasteType;
        if (this.isValid() && this.isEditable() && (pasteType = ComponentPasteType.getPasteType((Component)this.reference.get(), (Transferable)transferable, this.childType)) != null) {
            list.add(pasteType);
        }
    }

    public PasteType getDropType(Transferable transferable, int n, int n2) {
        PasteType pasteType;
        if (this.isValid() && this.isEditable() && (pasteType = ComponentPasteType.getDropType((Component)this.reference.get(), (Transferable)transferable, this.childType, (int)n, (int)n2)) != null) {
            return pasteType;
        }
        return null;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public Action[] getActions(boolean bl) {
        ReadOnlyCookie readOnlyCookie = (ReadOnlyCookie)this.getContext().getLookup().lookup(ReadOnlyCookie.class);
        if (readOnlyCookie != null && readOnlyCookie.isReadOnly()) {
            return ACTIONS_READONLY;
        }
        return ACTIONS;
    }

    public NewType[] getNewTypes() {
        SchemaModel schemaModel = this.getReference().get().getModel();
        if (schemaModel != null && this.isEditable()) {
            return new AdvancedNewTypesFactory().getNewTypes(this.getReference(), this.getChildType());
        }
        return new NewType[0];
    }

    public boolean isValid() {
        return this.getReference().get() != null && this.getReference().get().getModel() != null;
    }

    protected boolean isEditable() {
        SchemaModel schemaModel = this.getReference().get().getModel();
        return schemaModel != null && schemaModel == this.getContext().getModel() && XAMUtils.isWritable((Model)schemaModel);
    }

    public void childrenAdded(ComponentEvent componentEvent) {
        if (!this.isValid()) {
            return;
        }
        if (componentEvent.getSource() == this.getReference().get()) {
            ((RefreshableChildren)this.getChildren()).refreshChildren();
        }
    }

    public void childrenDeleted(ComponentEvent componentEvent) {
        if (!this.isValid()) {
            return;
        }
        if (componentEvent.getSource() == this.getReference().get()) {
            ((RefreshableChildren)this.getChildren()).refreshChildren();
        }
    }

    public void valueChanged(ComponentEvent componentEvent) {
        if (!this.isValid()) {
            return;
        }
    }

    public Set<Component> getComponents() {
        return this.referenceSet;
    }

    public void highlightAdded(Highlight highlight) {
        this.highlights.add(highlight);
        this.fireDisplayNameChange("TempName", this.getDisplayName());
    }

    public void highlightRemoved(Highlight highlight) {
        this.highlights.remove(highlight);
        this.fireDisplayNameChange("TempName", this.getDisplayName());
    }

    protected String applyHighlights(String string) {
        int n = this.highlights.size();
        if (n > 0) {
            String string2 = null;
            Highlight highlight = this.highlights.get(n - 1);
            String string3 = highlight.getType();
            if (string3.equals("searchResult") || string3.equals("searchResultParent")) {
                string2 = "ffc73c";
            } else if (string3.equals("find-usages-result") || string3.equals("find-usages-result-parent")) {
                string2 = "c7ff3c";
            }
            string = "<strong><font color=\"#" + string2 + "\">" + string + "</font></strong>";
        }
        return string;
    }

    private Node getFolderNode() {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().getRoot();
        Node node = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            node = dataObject.getNodeDelegate();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return node;
    }

    public Image getIcon(int n) {
        Node node = this.getFolderNode();
        Image image = super.getIcon(n);
        if (node != null) {
            image = node.getIcon(n);
        }
        return this.badgeImage(image);
    }

    public Image getOpenedIcon(int n) {
        Node node = this.getFolderNode();
        Image image = super.getOpenedIcon(n);
        if (node != null) {
            image = node.getOpenedIcon(n);
        }
        return this.badgeImage(image);
    }

    private Image badgeImage(Image image) {
        Image image2 = image;
        if (this.badge != null) {
            Image image3 = Utilities.loadImage((String)this.badge);
            image2 = Utilities.mergeImages((Image)image, (Image)image3, (int)8, (int)8);
        }
        return image2;
    }

    public void setBadge(String string) {
        this.badge = string;
    }

    public String getHtmlDisplayName() {
        String string = this.getDisplayName();
        string = string.replace("<", "&lt;").replace(">", "&gt;");
        return this.applyHighlights(string);
    }
}

