/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.List;
import org.netbeans.modules.xml.schema.model.LocalSimpleType;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponentFactory;
import org.netbeans.modules.xml.schema.model.SchemaComponentReference;
import org.netbeans.modules.xml.schema.model.SimpleType;
import org.netbeans.modules.xml.schema.model.SimpleTypeDefinition;
import org.netbeans.modules.xml.schema.model.SimpleTypeRestriction;
import org.netbeans.modules.xml.schema.model.Union;
import org.netbeans.modules.xml.schema.ui.basic.editors.SchemaComponentSelectionPanel;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer.AbstractSchemaComponentCustomizer;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer.ElementCustomizer;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ui.customizer.MessageDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTypeCustomizer<T extends SimpleType>
extends AbstractSchemaComponentCustomizer<T>
implements PropertyChangeListener {
    static final long serialVersionUID = 1L;
    public JLabel baseTypeLabel;
    public ButtonGroup derivationGroup;
    public JRadioButton inlineTypeButton;
    public JScrollPane jScrollPane1;
    public JRadioButton listButton;
    public JPanel mPanel;
    public JLabel nameLabel;
    public JPanel namePanel;
    public JTextField nameTextField;
    public JLabel previewLabel;
    public JEditorPane previewPane;
    public JRadioButton restrictionButton;
    public JPanel typeDefPanel;
    public ButtonGroup typeGroup;
    public JLabel typeLabel;
    public JPanel typePanel;
    public JRadioButton unionButton;
    public JRadioButton useExistingButton;
    private DocumentListener nameListener;
    private transient ItemListener buttonListener;
    private transient GlobalSimpleType currentGlobalSimpleType;
    private transient DerivationType derivation;
    private transient TypeDefinition typeDef;
    private transient SchemaComponentSelectionPanel<GlobalSimpleType> componentSelectionPanel;

    public SimpleTypeCustomizer(SchemaComponentReference<T> schemaComponentReference) {
        this(schemaComponentReference, null, null);
    }

    public SimpleTypeCustomizer(SchemaComponentReference<T> schemaComponentReference, SchemaComponent schemaComponent, GlobalSimpleType globalSimpleType) {
        super(schemaComponentReference, schemaComponent);
        this.currentGlobalSimpleType = globalSimpleType;
        this.initComponents();
        this.reset();
    }

    public void applyChanges() throws IOException {
        SimpleType simpleType = (SimpleType)this.getReference().get();
        this.saveName();
        DerivationType derivationType = this.getUIDerivationType();
        TypeDefinition typeDefinition = this.getUITypeDefinition();
        switch (derivationType) {
            case RESTRICTION: 
            case LIST: {
                if (typeDefinition == TypeDefinition.EXISTING && this.getUIType() == null || derivationType == this._getDerivationType() && typeDefinition == this._getTypeDefinition() && this.getUIType() == this._getType()) break;
                this.setModelType();
                break;
            }
            case UNION: {
                if (derivationType == this._getDerivationType()) break;
                this.setModelType();
            }
        }
    }

    public void reset() {
        this.removeListeners();
        this.initializeModel();
        this.initializeUISelection();
        this.addListeners();
        if (this.hasParent()) {
            this.setSaveEnabled(false);
        } else {
            this.setSaveEnabled(true);
        }
        this.setResetEnabled(false);
    }

    private void initializeModel() {
        SimpleType simpleType = (SimpleType)this.getReference().get();
        SimpleTypeDefinition simpleTypeDefinition = simpleType.getDefinition();
        if (simpleTypeDefinition instanceof SimpleTypeRestriction) {
            this.derivation = DerivationType.RESTRICTION;
            SimpleTypeRestriction simpleTypeRestriction = (SimpleTypeRestriction)simpleTypeDefinition;
            if (simpleTypeRestriction.getBase() != null) {
                if (this.hasParent()) {
                    this.currentGlobalSimpleType = (GlobalSimpleType)simpleTypeRestriction.getBase().get();
                }
                this.typeDef = TypeDefinition.EXISTING;
            } else if (simpleTypeRestriction.getInlineType() != null) {
                this.typeDef = TypeDefinition.INLINE;
            }
        } else if (simpleTypeDefinition instanceof List) {
            this.derivation = DerivationType.LIST;
            List list = (List)simpleTypeDefinition;
            if (list.getType() != null) {
                this.currentGlobalSimpleType = (GlobalSimpleType)list.getType().get();
                this.typeDef = TypeDefinition.EXISTING;
            } else if (list.getInlineType() != null) {
                this.typeDef = TypeDefinition.INLINE;
            }
        } else if (simpleTypeDefinition instanceof Union) {
            this.derivation = DerivationType.UNION;
            Union union = (Union)simpleTypeDefinition;
        }
    }

    private void initializeUISelection() {
        TypeDefinition typeDefinition;
        DerivationType derivationType;
        this.getMessageDisplayer().clear();
        if (this.isNameable()) {
            this.nameTextField.setText(this._getName());
            if (!this.hasParent()) {
                this.nameTextField.setSelectionStart(0);
            }
        } else {
            this.namePanel.setVisible(false);
        }
        if ((derivationType = this._getDerivationType()) != null) {
            switch (derivationType) {
                case RESTRICTION: {
                    this.restrictionButton.setSelected(true);
                    break;
                }
                case LIST: {
                    this.listButton.setSelected(true);
                    break;
                }
                case UNION: {
                    this.unionButton.setSelected(true);
                }
            }
        }
        if ((typeDefinition = this._getTypeDefinition()) != null) {
            switch (typeDefinition) {
                case EXISTING: {
                    this.useExistingButton.setSelected(true);
                    break;
                }
                case INLINE: {
                    this.inlineTypeButton.setSelected(true);
                }
            }
        }
        this.switchTypePanels();
        this.selectModelNode();
        this.setPreviewText();
    }

    private void addListeners() {
        if (this.nameListener == null) {
            this.nameListener = new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    SimpleTypeCustomizer.this.setPreviewText();
                    SimpleTypeCustomizer.this.determineValidity();
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    SimpleTypeCustomizer.this.setPreviewText();
                    SimpleTypeCustomizer.this.determineValidity();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    SimpleTypeCustomizer.this.setPreviewText();
                    SimpleTypeCustomizer.this.determineValidity();
                }
            };
        }
        this.nameTextField.getDocument().addDocumentListener(this.nameListener);
        if (this.buttonListener == null) {
            this.buttonListener = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    Object object = itemEvent.getSource();
                    if (itemEvent.getStateChange() == 1) {
                        SimpleTypeCustomizer.this.switchTypePanels();
                        SimpleTypeCustomizer.this.setPreviewText();
                        SimpleTypeCustomizer.this.determineValidity();
                    }
                }
            };
        }
        this.restrictionButton.addItemListener(this.buttonListener);
        this.listButton.addItemListener(this.buttonListener);
        this.unionButton.addItemListener(this.buttonListener);
        this.useExistingButton.addItemListener(this.buttonListener);
        this.inlineTypeButton.addItemListener(this.buttonListener);
    }

    private void removeListeners() {
        this.nameTextField.getDocument().removeDocumentListener(this.nameListener);
    }

    private void switchTypePanels() {
        boolean bl = this.getUIDerivationType() != DerivationType.UNION;
        this.typeDefPanel.setEnabled(bl);
        this.useExistingButton.setEnabled(bl);
        this.inlineTypeButton.setEnabled(bl);
        if (bl && this.getUITypeDefinition() == null) {
            this.useExistingButton.setSelected(true);
        }
        boolean bl2 = bl && this.useExistingButton.isSelected();
        this.componentSelectionPanel.setEnabled(bl2);
    }

    private void selectModelNode() {
        this.componentSelectionPanel.setInitialSelection(this._getType());
    }

    private GlobalSimpleType _getType() {
        return this.currentGlobalSimpleType;
    }

    private DerivationType _getDerivationType() {
        return this.derivation;
    }

    private TypeDefinition _getTypeDefinition() {
        return this.typeDef;
    }

    @Override
    protected String getUIName() {
        return this.nameTextField.getText();
    }

    private DerivationType getUIDerivationType() {
        if (this.restrictionButton.isSelected()) {
            return DerivationType.RESTRICTION;
        }
        if (this.listButton.isSelected()) {
            return DerivationType.LIST;
        }
        if (this.unionButton.isSelected()) {
            return DerivationType.UNION;
        }
        return null;
    }

    private TypeDefinition getUITypeDefinition() {
        if (this.getUIDerivationType() == DerivationType.UNION) {
            return null;
        }
        if (this.useExistingButton.isSelected()) {
            return TypeDefinition.EXISTING;
        }
        if (this.inlineTypeButton.isSelected()) {
            return TypeDefinition.INLINE;
        }
        return null;
    }

    private GlobalSimpleType getUIType() {
        if (this.getUIDerivationType() == DerivationType.UNION) {
            return null;
        }
        if (this.getUITypeDefinition() == TypeDefinition.INLINE) {
            return null;
        }
        return this.componentSelectionPanel.getCurrentSelection();
    }

    private void setModelType() {
        SimpleType simpleType = (SimpleType)this.getReference().get();
        SimpleTypeDefinition simpleTypeDefinition = simpleType.getDefinition();
        SchemaComponentFactory schemaComponentFactory = simpleType.getModel().getFactory();
        GlobalSimpleType globalSimpleType = this.getUIType();
        LocalSimpleType localSimpleType = null;
        if (simpleTypeDefinition instanceof SimpleTypeRestriction) {
            localSimpleType = ((SimpleTypeRestriction)simpleTypeDefinition).getInlineType();
        } else if (simpleTypeDefinition instanceof List) {
            localSimpleType = ((List)simpleTypeDefinition).getInlineType();
        }
        switch (this.getUIDerivationType()) {
            case RESTRICTION: {
                if (simpleTypeDefinition instanceof SimpleTypeRestriction) {
                    SimpleTypeRestriction simpleTypeRestriction = (SimpleTypeRestriction)simpleTypeDefinition;
                    if (globalSimpleType != null) {
                        if (localSimpleType != null) {
                            simpleTypeRestriction.setInlineType(null);
                        }
                        simpleTypeRestriction.setBase(schemaComponentFactory.createGlobalReference((ReferenceableSchemaComponent)globalSimpleType, GlobalSimpleType.class, (SchemaComponent)simpleTypeRestriction));
                        break;
                    }
                    if (simpleTypeRestriction.getBase() != null) {
                        simpleTypeRestriction.setBase(null);
                    }
                    if (localSimpleType != null) break;
                    simpleTypeRestriction.setInlineType(this.createLocalSimpleType(schemaComponentFactory));
                    break;
                }
                SimpleTypeRestriction simpleTypeRestriction = schemaComponentFactory.createSimpleTypeRestriction();
                if (globalSimpleType != null) {
                    simpleTypeRestriction.setBase(schemaComponentFactory.createGlobalReference((ReferenceableSchemaComponent)globalSimpleType, GlobalSimpleType.class, (SchemaComponent)simpleTypeRestriction));
                } else if (localSimpleType != null) {
                    simpleTypeRestriction.setInlineType((LocalSimpleType)localSimpleType.copy((Component)simpleTypeRestriction));
                } else {
                    simpleTypeRestriction.setInlineType(this.createLocalSimpleType(schemaComponentFactory));
                }
                simpleType.setDefinition((SimpleTypeDefinition)simpleTypeRestriction);
                break;
            }
            case LIST: {
                if (simpleTypeDefinition instanceof List) {
                    List list = (List)simpleTypeDefinition;
                    if (globalSimpleType != null) {
                        if (localSimpleType != null) {
                            list.setInlineType(null);
                        }
                        list.setType(schemaComponentFactory.createGlobalReference((ReferenceableSchemaComponent)globalSimpleType, GlobalSimpleType.class, (SchemaComponent)list));
                        break;
                    }
                    if (list.getType() != null) {
                        list.setType(null);
                    }
                    if (localSimpleType != null) break;
                    list.setInlineType(this.createLocalSimpleType(schemaComponentFactory));
                    break;
                }
                List list = schemaComponentFactory.createList();
                if (globalSimpleType != null) {
                    list.setType(schemaComponentFactory.createGlobalReference((ReferenceableSchemaComponent)globalSimpleType, GlobalSimpleType.class, (SchemaComponent)list));
                } else if (localSimpleType != null) {
                    list.setInlineType((LocalSimpleType)localSimpleType.copy((Component)list));
                } else {
                    list.setInlineType(this.createLocalSimpleType(schemaComponentFactory));
                }
                simpleType.setDefinition((SimpleTypeDefinition)list);
                break;
            }
            case UNION: {
                if (simpleTypeDefinition instanceof Union) break;
                Union union = schemaComponentFactory.createUnion();
                simpleType.setDefinition((SimpleTypeDefinition)union);
            }
        }
    }

    private LocalSimpleType createLocalSimpleType(SchemaComponentFactory schemaComponentFactory) {
        LocalSimpleType localSimpleType = schemaComponentFactory.createLocalSimpleType();
        SimpleTypeRestriction simpleTypeRestriction = schemaComponentFactory.createSimpleTypeRestriction();
        simpleTypeRestriction.setBase(ElementCustomizer.createStringTypeReference(schemaComponentFactory, (SchemaComponent)simpleTypeRestriction));
        localSimpleType.setDefinition((SimpleTypeDefinition)simpleTypeRestriction);
        return localSimpleType;
    }

    private void initializeTypeView() {
        this.componentSelectionPanel = new SchemaComponentSelectionPanel<Object>(((SimpleType)this.getReference().get()).getModel(), GlobalSimpleType.class, null, Collections.singleton(this.getReference().get()), true);
        this.componentSelectionPanel.addPropertyChangeListener(this);
        this.typePanel.add((java.awt.Component)this.componentSelectionPanel.getTypeSelectionPanel(), "Center");
        this.componentSelectionPanel.getTypeSelectionPanel().getAccessibleContext().setAccessibleParent(this.typePanel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("selectionChanged")) {
            this.setPreviewText();
            this.determineValidity();
        }
    }

    private void determineValidity() {
        boolean bl;
        this.getMessageDisplayer().clear();
        boolean bl2 = bl = this.isNameable() && this.isNameChanged();
        if (!bl && this.getUIDerivationType() == this._getDerivationType() && this.getUITypeDefinition() == this._getTypeDefinition() && this.getUIType() == this._getType()) {
            if (this.hasParent()) {
                this.setSaveEnabled(false);
            } else {
                this.setSaveEnabled(true);
            }
            this.setResetEnabled(false);
            return;
        }
        this.setResetEnabled(true);
        boolean bl3 = false;
        DerivationType derivationType = this.getUIDerivationType();
        TypeDefinition typeDefinition = this.getUITypeDefinition();
        switch (derivationType) {
            case RESTRICTION: 
            case LIST: {
                if ((typeDefinition != TypeDefinition.EXISTING || this.getUIType() == null) && typeDefinition != TypeDefinition.INLINE) break;
                bl3 = true;
                break;
            }
            case UNION: {
                bl3 = true;
            }
        }
        this.setSaveEnabled(bl3 && (!this.isNameChanged() || this.isNameValid()));
        if (!bl3) {
            this.getMessageDisplayer().annotate(NbBundle.getMessage(SimpleTypeCustomizer.class, (String)"MSG_Type_Error"), MessageDisplayer.Type.ERROR);
        }
    }

    private String getInlineTypePreviewText() {
        StringBuffer stringBuffer = new StringBuffer("\n        <");
        String string = ((SimpleType)this.getReference().get()).getPeer().getPrefix();
        if (string != null) {
            stringBuffer.append(string + ":");
        }
        stringBuffer.append("simpleType>");
        stringBuffer.append("\n            <");
        if (string != null) {
            stringBuffer.append(string + ":");
        }
        stringBuffer.append("restriction base=\"");
        if (string != null) {
            stringBuffer.append(string + ":");
        }
        stringBuffer.append("string\">");
        stringBuffer.append("\n        </");
        if (string != null) {
            stringBuffer.append(string + ":");
        }
        stringBuffer.append("simpleType>");
        return stringBuffer.toString();
    }

    private void setPreviewText() {
        StringBuffer stringBuffer = new StringBuffer("<");
        String string = ((SimpleType)this.getReference().get()).getPeer().getPrefix();
        if (string != null) {
            stringBuffer.append(string + ":");
        }
        stringBuffer.append("simpleType");
        if (this.isNameable()) {
            stringBuffer.append(" name=\"");
            stringBuffer.append(this.getUIName());
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        DerivationType derivationType = this.getUIDerivationType();
        TypeDefinition typeDefinition = this.getUITypeDefinition();
        GlobalSimpleType globalSimpleType = this.getUIType();
        if (derivationType != null) {
            switch (derivationType) {
                case RESTRICTION: {
                    stringBuffer.append("\n    <");
                    if (string != null) {
                        stringBuffer.append(string + ":");
                    }
                    stringBuffer.append("restriction");
                    if (typeDefinition == TypeDefinition.EXISTING) {
                        stringBuffer.append(" base=\"");
                        if (globalSimpleType != null) {
                            stringBuffer.append(globalSimpleType.getName());
                        }
                        stringBuffer.append("\"/>");
                        break;
                    }
                    if (typeDefinition == TypeDefinition.INLINE) {
                        stringBuffer.append(">");
                        stringBuffer.append(this.getInlineTypePreviewText());
                        stringBuffer.append("\n    </");
                        if (string != null) {
                            stringBuffer.append(string + ":");
                        }
                        stringBuffer.append("restriction>");
                        break;
                    }
                    stringBuffer.append("/>");
                    break;
                }
                case LIST: {
                    stringBuffer.append("\n    <");
                    if (string != null) {
                        stringBuffer.append(string + ":");
                    }
                    stringBuffer.append("list");
                    if (typeDefinition == TypeDefinition.EXISTING) {
                        stringBuffer.append(" itemType=\"");
                        if (globalSimpleType != null) {
                            stringBuffer.append(globalSimpleType.getName());
                        }
                        stringBuffer.append("\"/>");
                        break;
                    }
                    if (typeDefinition == TypeDefinition.INLINE) {
                        stringBuffer.append(">");
                        stringBuffer.append(this.getInlineTypePreviewText());
                        stringBuffer.append("\n    </");
                        if (string != null) {
                            stringBuffer.append(string + ":");
                        }
                        stringBuffer.append("list>");
                        break;
                    }
                    stringBuffer.append("/>");
                    break;
                }
                case UNION: {
                    stringBuffer.append("\n    <");
                    if (string != null) {
                        stringBuffer.append(string + ":");
                    }
                    stringBuffer.append("union/>");
                }
            }
        }
        stringBuffer.append("\n</");
        if (string != null) {
            stringBuffer.append(string + ":");
        }
        stringBuffer.append("simpleType>\n");
        this.previewPane.setText(stringBuffer.toString());
    }

    private void initComponents() {
        this.derivationGroup = new ButtonGroup();
        this.typeGroup = new ButtonGroup();
        this.typeDefPanel = new JPanel();
        this.typePanel = new JPanel();
        this.useExistingButton = new JRadioButton();
        this.inlineTypeButton = new JRadioButton();
        this.baseTypeLabel = new JLabel();
        this.previewLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.previewPane = new JEditorPane(){
            static final long serialVersionUID = 1L;

            protected void processMouseEvent(MouseEvent mouseEvent) {
                mouseEvent.consume();
            }

            protected void processMouseMotionEvent(MouseEvent mouseEvent) {
                mouseEvent.consume();
            }
        };
        this.typeLabel = new JLabel();
        this.restrictionButton = new JRadioButton();
        this.listButton = new JRadioButton();
        this.unionButton = new JRadioButton();
        this.mPanel = new JPanel();
        this.namePanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.setToolTipText("");
        this.typePanel.setLayout(new BorderLayout());
        this.initializeTypeView();
        this.typeGroup.add(this.useExistingButton);
        Mnemonics.setLocalizedText((AbstractButton)this.useExistingButton, (String)NbBundle.getMessage(SimpleTypeCustomizer.class, (String)"LBL_SimpleTypeForm_Existing_Definition_Button"));
        this.useExistingButton.setToolTipText(NbBundle.getMessage(SimpleTypeCustomizer.class, (String)"HINT_SimpleTypeForm_Existing_Definition_Button"));
        this.useExistingButton.setMargin(new Insets(0, 0, 0, 0));
        this.typeGroup.add(this.inlineTypeButton);
        Mnemonics.setLocalizedText((AbstractButton)this.inlineTypeButton, (String)NbBundle.getMessage(SimpleTypeCustomizer.class, (String)"LBL_SimpleTypeForm_Inline_Definition_Button"));
        this.inlineTypeButton.setToolTipText(NbBundle.getMessage(SimpleTypeCustomizer.class, (String)"HINT_SimpleTypeForm_Inline_Definition_Button"));
        this.inlineTypeButton.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.baseTypeLabel, (String)NbBundle.getMessage(SimpleTypeCustomizer.class, (String)"TITLE_SimpleTypeForm_BaseTypePanel", (Object[])new Object[0]));
        this.baseTypeLabel.setToolTipText(NbBundle.getMessage(SimpleTypeCustomizer.class, (String)"HINT_SimpleTypeForm_BaseTypePanel"));
        GroupLayout groupLayout = new GroupLayout((Container)this.typeDefPanel);
        this.typeDefPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((java.awt.Component)this.baseTypeLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(11, 11, 11).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((java.awt.Component)this.inlineTypeButton).add((java.awt.Component)this.useExistingButton))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(30, 30, 30).add((java.awt.Component)this.typePanel, -1, 450, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((java.awt.Component)this.baseTypeLabel).addPreferredGap(0).add((java.awt.Component)this.inlineTypeButton).addPreferredGap(0).add((java.awt.Component)this.useExistingButton).addPreferredGap(0).add((java.awt.Component)this.typePanel, -1, 195, Short.MAX_VALUE)));
        this.previewLabel.setLabelFor(this.previewPane);
        Mnemonics.setLocalizedText((JLabel)this.previewLabel, (String)NbBundle.getMessage(SimpleTypeCustomizer.class, (String)"TITLE_CustomizerForm_Preview"));
        this.previewLabel.setToolTipText(NbBundle.getMessage(SimpleTypeCustomizer.class, (String)"HINT_SimpleTypeForm_Preview"));
        this.previewPane.setEditable(false);
        this.previewPane.setContentType("text/xml");
        this.previewPane.setEnabled(false);
        this.jScrollPane1.setViewportView(this.previewPane);
        Mnemonics.setLocalizedText((JLabel)this.typeLabel, (String)NbBundle.getMessage(SimpleTypeCustomizer.class, (String)"TITLE_SimpleTypeForm_DerivationTypePanel", (Object[])new Object[0]));
        this.typeLabel.setToolTipText(NbBundle.getMessage(SimpleTypeCustomizer.class, (String)"HINT_SimpleTypeForm_DerivationTypePanel"));
        this.derivationGroup.add(this.restrictionButton);
        Mnemonics.setLocalizedText((AbstractButton)this.restrictionButton, (String)NbBundle.getMessage(SimpleTypeCustomizer.class, (String)"LBL_SimpleTypeForm_Restriction_Button"));
        this.restrictionButton.setToolTipText(NbBundle.getMessage(SimpleTypeCustomizer.class, (String)"HINT_SimpleTypeForm_Restriction_Button"));
        this.restrictionButton.setMargin(new Insets(0, 0, 0, 0));
        this.derivationGroup.add(this.listButton);
        Mnemonics.setLocalizedText((AbstractButton)this.listButton, (String)NbBundle.getMessage(SimpleTypeCustomizer.class, (String)"LBL_SimpleTypeForm_List_Button"));
        this.listButton.setToolTipText(NbBundle.getMessage(SimpleTypeCustomizer.class, (String)"HINT_SimpleTypeForm_List_Button"));
        this.listButton.setMargin(new Insets(0, 0, 0, 0));
        this.derivationGroup.add(this.unionButton);
        Mnemonics.setLocalizedText((AbstractButton)this.unionButton, (String)NbBundle.getMessage(SimpleTypeCustomizer.class, (String)"LBL_SimpleTypeForm_Union_Button"));
        this.unionButton.setToolTipText(NbBundle.getMessage(SimpleTypeCustomizer.class, (String)"HINT_SimpleTypeForm_Union_Button"));
        this.unionButton.setMargin(new Insets(0, 0, 0, 0));
        this.mPanel.setLayout(new BorderLayout());
        this.mPanel.add((java.awt.Component)this.getMessageDisplayer().getComponent(), "Center");
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(SimpleTypeCustomizer.class, (String)"LBL_CustomizerForm_Name"));
        this.nameLabel.setToolTipText(NbBundle.getMessage(SimpleTypeCustomizer.class, (String)"HINT_SimpleTypeForm_Name"));
        this.nameTextField.setEditable(!this.hasParent());
        GroupLayout groupLayout2 = new GroupLayout((Container)this.namePanel);
        this.namePanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((java.awt.Component)this.nameLabel).addPreferredGap(0).add((java.awt.Component)this.nameTextField, -1, 445, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((java.awt.Component)this.nameLabel).add((java.awt.Component)this.nameTextField, -2, -1, -2))));
        GroupLayout groupLayout3 = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((java.awt.Component)this.typeLabel).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add(11, 11, 11).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((java.awt.Component)this.listButton).add((java.awt.Component)this.restrictionButton).add((java.awt.Component)this.unionButton)))).addContainerGap(398, Short.MAX_VALUE)).add((java.awt.Component)this.namePanel, -1, -1, Short.MAX_VALUE).add(2, (java.awt.Component)this.mPanel, -1, 500, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((java.awt.Component)this.jScrollPane1, -1, 480, Short.MAX_VALUE).add((java.awt.Component)this.previewLabel)).addContainerGap()).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((java.awt.Component)this.typeDefPanel, -1, -1, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().add((java.awt.Component)this.namePanel, -2, -1, -2).add(11, 11, 11).add((java.awt.Component)this.typeLabel).addPreferredGap(0).add((java.awt.Component)this.restrictionButton).addPreferredGap(0).add((java.awt.Component)this.listButton).addPreferredGap(0).add((java.awt.Component)this.unionButton).add(11, 11, 11).add((java.awt.Component)this.typeDefPanel, -1, -1, Short.MAX_VALUE).add(11, 11, 11).add((java.awt.Component)this.previewLabel).addPreferredGap(0).add((java.awt.Component)this.jScrollPane1, -1, 70, Short.MAX_VALUE).add(0, 0, 0).add((java.awt.Component)this.mPanel, -1, 60, Short.MAX_VALUE)));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SimpleTypeCustomizer.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TypeDefinition {
        EXISTING,
        INLINE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DerivationType {
        RESTRICTION,
        LIST,
        UNION;

    }
}

