/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.actions.AutoupdateCheckScheduler;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardIterator;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.LazyInstallUnitWizardIterator;
import org.netbeans.modules.autoupdate.ui.wizards.OperationDescriptionPanel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.PanelBodyContainer;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyOperationDescriptionStep
implements WizardDescriptor.Panel<WizardDescriptor> {
    private static final String HEAD = "OperationDescriptionStep_Header_Head";
    private static final String CONTENT = "OperationDescriptionStep_Header_Content";
    private static final String TABLE_TITLE_INSTALL = "OperationDescriptionStep_TableInstall_Title";
    private static final String TABLE_TITLE_UPDATE = "OperationDescriptionStep_TableUpdate_Title";
    private PanelBodyContainer component;
    private Collection<LazyInstallUnitWizardIterator.LazyUnit> installModel = null;
    private boolean hasUpdates = false;
    private OperationWizardModel.OperationType operationType = null;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private RequestProcessor.Task checkRealUpdatesTask = null;
    private WizardDescriptor wd = null;
    private boolean forceReload;

    public LazyOperationDescriptionStep(Collection<LazyInstallUnitWizardIterator.LazyUnit> collection, OperationWizardModel.OperationType operationType, boolean bl) {
        this.installModel = collection;
        this.operationType = operationType;
        this.hasUpdates = this.installModel != null && !this.installModel.isEmpty();
        this.forceReload = bl;
    }

    public Component getComponent() {
        if (this.component == null) {
            String string = null;
            String string2 = null;
            String string3 = null;
            switch (this.operationType) {
                case INSTALL: {
                    string = this.getBundle(TABLE_TITLE_INSTALL, new Object[0]);
                    string2 = this.getBundle(HEAD, new Object[0]);
                    string3 = this.getBundle(CONTENT, new Object[0]);
                    break;
                }
                case UPDATE: {
                    string = this.getBundle(TABLE_TITLE_UPDATE, new Object[0]);
                    string2 = this.getBundle(HEAD, new Object[0]);
                    string3 = this.getBundle(CONTENT, new Object[0]);
                    break;
                }
                default: {
                    assert (false) : "Unexcepted operationType " + (Object)((Object)this.operationType);
                    return null;
                }
            }
            if (!this.hasUpdates) {
                string = this.getBundle("LazyOperationDescriptionStep_FindUpdates_Title", new Object[0]);
            }
            OperationDescriptionPanel operationDescriptionPanel = new OperationDescriptionPanel(string, this.preparePluginsForShow(this.installModel, this.operationType), "", "", false);
            this.component = new PanelBodyContainer(string2, string3, operationDescriptionPanel);
            this.component.setPreferredSize(OperationWizardModel.PREFFERED_DIMENSION);
            long l = Utilities.getTimeOfInitialization();
            if (this.forceReload) {
                long l2 = Utilities.getTimeOfRefreshUpdateCenters();
                l = l > 0L && l2 > 0L ? l + l2 : 0L;
            }
            this.component.setWaitingState(true, l);
            this.checkRealUpdates();
        }
        return this.component;
    }

    private void checkRealUpdates() {
        this.checkRealUpdatesTask = RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                final Collection<UpdateElement> collection = AutoupdateCheckScheduler.checkUpdateElements(LazyOperationDescriptionStep.this.operationType, true);
                LazyOperationDescriptionStep.this.hasUpdates = collection != null && !collection.isEmpty();
                if (LazyOperationDescriptionStep.this.hasUpdates) {
                    assert (LazyOperationDescriptionStep.this.wd != null) : "WizardDescriptor must found!";
                    OperationContainer operationContainer = OperationWizardModel.OperationType.UPDATE == LazyOperationDescriptionStep.this.operationType ? OperationContainer.createForUpdate() : OperationContainer.createForInstall();
                    boolean bl = true;
                    for (UpdateElement updateElement : collection) {
                        bl &= operationContainer.canBeAdded(updateElement.getUpdateUnit(), updateElement);
                    }
                    LazyOperationDescriptionStep.this.hasUpdates = LazyOperationDescriptionStep.this.hasUpdates && bl;
                    if (bl) {
                        operationContainer.add(collection);
                        final InstallUnitWizardIterator installUnitWizardIterator = new InstallUnitWizardIterator(new InstallUnitWizardModel(LazyOperationDescriptionStep.this.operationType, (OperationContainer<InstallSupport>)operationContainer), true);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                LazyOperationDescriptionStep.this.wd.setPanelsAndSettings(installUnitWizardIterator, (Object)LazyOperationDescriptionStep.this.wd);
                                LazyOperationDescriptionStep.this.fireChange();
                                LazyInstallUnitWizardIterator.LazyUnit.storeUpdateElements(LazyOperationDescriptionStep.this.operationType, collection);
                                AutoupdateCheckScheduler.notifyAvailable(LazyInstallUnitWizardIterator.LazyUnit.loadLazyUnits(LazyOperationDescriptionStep.this.operationType), LazyOperationDescriptionStep.this.operationType);
                            }
                        });
                    }
                }
            }
        });
        this.checkRealUpdatesTask.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                task.removeTaskListener((TaskListener)this);
                if (!LazyOperationDescriptionStep.this.hasUpdates) {
                    final OperationDescriptionPanel operationDescriptionPanel = new OperationDescriptionPanel(LazyOperationDescriptionStep.this.getBundle("LazyOperationDescriptionStep_NoUpdates_Title", new Object[0]), LazyOperationDescriptionStep.this.getBundle("LazyOperationDescriptionStep_NoUpdates", new Object[0]), "", "", false);
                    LazyOperationDescriptionStep.this.installModel = Collections.EMPTY_SET;
                    LazyInstallUnitWizardIterator.LazyUnit.storeLazyUnits(LazyOperationDescriptionStep.this.operationType, LazyOperationDescriptionStep.this.installModel);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            LazyOperationDescriptionStep.this.component.setBody(operationDescriptionPanel);
                            LazyOperationDescriptionStep.this.component.setWaitingState(false);
                            AutoupdateCheckScheduler.notifyAvailable(LazyOperationDescriptionStep.this.installModel, LazyOperationDescriptionStep.this.operationType);
                            LazyOperationDescriptionStep.this.fireChange();
                        }
                    });
                }
            }
        });
    }

    private String preparePluginsForShow(Collection<LazyInstallUnitWizardIterator.LazyUnit> collection, OperationWizardModel.OperationType operationType) {
        String string = new String();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (collection != null && !collection.isEmpty()) {
            for (LazyInstallUnitWizardIterator.LazyUnit object : collection) {
                String string2 = "<b>" + object.getDisplayName() + "</b> ";
                string2 = OperationWizardModel.OperationType.UPDATE == operationType ? string2 + this.getBundle("OperationDescriptionStep_UpdatePluginVersionFormat", object.getOldVersion(), object.getNewVersion()) : string2 + this.getBundle("OperationDescriptionStep_PluginVersionFormat", object.getNewVersion());
                string2 = string2 + "<br>";
                String string3 = object.getNotification();
                if (string3 != null && string3.length() > 0) {
                    string2 = string2 + "<font color=\"red\">" + string3 + "</font><br><br>";
                }
                arrayList.add(string2);
            }
            Collections.sort(arrayList);
            for (String string4 : arrayList) {
                string = string + string4;
            }
        }
        return string.trim();
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        this.wd = wizardDescriptor;
    }

    public void storeSettings(WizardDescriptor wizardDescriptor) {
        if ((WizardDescriptor.CANCEL_OPTION.equals(wizardDescriptor.getValue()) || WizardDescriptor.CLOSED_OPTION.equals(wizardDescriptor.getValue())) && this.checkRealUpdatesTask != null && !this.checkRealUpdatesTask.isFinished()) {
            this.checkRealUpdatesTask.cancel();
        }
    }

    public boolean isValid() {
        return false;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> arrayList;
        ChangeEvent changeEvent = new ChangeEvent(this);
        LazyOperationDescriptionStep lazyOperationDescriptionStep = this;
        synchronized (lazyOperationDescriptionStep) {
            arrayList = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener changeListener : arrayList) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private String getBundle(String string, Object ... objectArray) {
        return NbBundle.getMessage(OperationDescriptionPanel.class, (String)string, (Object[])objectArray);
    }
}

