/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.reader.util;

import com.sun.msv.reader.GrammarReader;
import com.sun.msv.reader.GrammarReaderController;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class GrammarReaderControllerAdaptor
implements ErrorHandler {
    private final GrammarReader reader;
    private final GrammarReaderController controller;

    public GrammarReaderControllerAdaptor(GrammarReader grammarReader, GrammarReaderController grammarReaderController) {
        this.reader = grammarReader;
        this.controller = grammarReaderController;
    }

    public GrammarReaderControllerAdaptor(GrammarReader grammarReader) {
        this(grammarReader, grammarReader.controller);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.error(sAXParseException);
        throw sAXParseException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.reader != null) {
            this.reader.hadError = true;
        }
        this.controller.error(this.getLocator(sAXParseException), sAXParseException.getMessage(), sAXParseException.getException());
    }

    public void warning(SAXParseException sAXParseException) {
        this.controller.warning(this.getLocator(sAXParseException), sAXParseException.getMessage());
    }

    protected Locator[] getLocator(SAXParseException sAXParseException) {
        LocatorImpl locatorImpl = new LocatorImpl();
        locatorImpl.setColumnNumber(sAXParseException.getColumnNumber());
        locatorImpl.setLineNumber(sAXParseException.getLineNumber());
        locatorImpl.setSystemId(sAXParseException.getSystemId());
        locatorImpl.setPublicId(sAXParseException.getPublicId());
        return new Locator[]{locatorImpl};
    }
}

