/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.spi.java.project.support.ui.EditJarSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class EditJarPanel
extends JPanel {
    private EditJarSupport.Item item;
    private AntProjectHelper helper;
    private JButton btnJavadoc;
    private JButton btnSource;
    private JLabel lblJar;
    private JLabel lblJavadoc;
    private JLabel lblSource;
    private JTextField txtJar;
    private JTextField txtJavadoc;
    private JTextField txtSource;

    private EditJarPanel() {
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_EditJarPanel"));
    }

    EditJarPanel(EditJarSupport.Item item, AntProjectHelper antProjectHelper) {
        this();
        this.item = item;
        this.helper = antProjectHelper;
        this.txtJar.setText(item.getJarFile());
        if (item.getSourceFile() != null) {
            this.txtSource.setText(item.getSourceFile());
        }
        if (item.getJavadocFile() != null) {
            this.txtJavadoc.setText(item.getJavadocFile());
        }
    }

    EditJarSupport.Item assignValues() {
        if (this.txtSource.getText() != null && this.txtSource.getText().trim().length() > 0) {
            this.item.setSourceFile(this.txtSource.getText().trim());
        } else {
            this.item.setSourceFile(null);
        }
        if (this.txtJavadoc.getText() != null && this.txtJavadoc.getText().trim().length() > 0) {
            this.item.setJavadocFile(this.txtJavadoc.getText().trim());
        } else {
            this.item.setJavadocFile(null);
        }
        return this.item;
    }

    private void initComponents() {
        this.lblJar = new JLabel();
        this.txtJar = new JTextField();
        this.lblJavadoc = new JLabel();
        this.txtJavadoc = new JTextField();
        this.btnJavadoc = new JButton();
        this.lblSource = new JLabel();
        this.txtSource = new JTextField();
        this.btnSource = new JButton();
        this.lblJar.setLabelFor(this.txtJar);
        Mnemonics.setLocalizedText((JLabel)this.lblJar, (String)NbBundle.getMessage(EditJarPanel.class, (String)"EditJarPanel.lblJar.text"));
        this.txtJar.setEditable(false);
        this.lblJavadoc.setLabelFor(this.txtJavadoc);
        Mnemonics.setLocalizedText((JLabel)this.lblJavadoc, (String)NbBundle.getMessage(EditJarPanel.class, (String)"EditJarPanel.lblJavadoc.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnJavadoc, (String)NbBundle.getMessage(EditJarPanel.class, (String)"EditJarPanel.btnJavadoc.text"));
        this.btnJavadoc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditJarPanel.this.btnJavadocActionPerformed(actionEvent);
            }
        });
        this.lblSource.setLabelFor(this.txtSource);
        Mnemonics.setLocalizedText((JLabel)this.lblSource, (String)NbBundle.getMessage(EditJarPanel.class, (String)"EditJarPanel.lblSource.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSource, (String)NbBundle.getMessage(EditJarPanel.class, (String)"EditJarPanel.btnSource.text"));
        this.btnSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditJarPanel.this.btnSourceActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblJar).add((Component)this.lblJavadoc).add((Component)this.lblSource)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.txtSource, -1, 330, Short.MAX_VALUE).add((Component)this.txtJavadoc, -1, 330, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.btnSource).add((Component)this.btnJavadoc))).add((Component)this.txtJar, -1, 435, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblJar).add((Component)this.txtJar, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblJavadoc).add((Component)this.btnJavadoc).add((Component)this.txtJavadoc, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblSource).add((Component)this.btnSource).add((Component)this.txtSource, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.lblJar.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_lblJar"));
        this.txtJar.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_lblJar"));
        this.lblJavadoc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_lblJavadoc"));
        this.txtJavadoc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_lblJavadoc"));
        this.btnJavadoc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_btnJavadoc"));
        this.lblSource.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_lblSource"));
        this.txtSource.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_lblSource"));
        this.btnSource.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_btnSource"));
    }

    private void btnJavadocActionPerformed(ActionEvent actionEvent) {
        FileChooser fileChooser = new FileChooser(this.helper, true);
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)fileChooser, null);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogTitle(NbBundle.getMessage(EditJarPanel.class, (String)"LBL_Edit_Jar_Panel_browse"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter((FileFilter)new SimpleFileFilter("Javadoc Entry (folder, ZIP or JAR file)", new String[]{"ZIP", "JAR"}));
        File file = this.helper.resolveFile(this.item.getJarFile());
        fileChooser.setCurrentDirectory(file);
        int n = fileChooser.showOpenDialog((Component)SwingUtilities.getWindowAncestor(this));
        if (n == 0) {
            String[] stringArray;
            try {
                stringArray = fileChooser.getSelectedPaths();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return;
            }
            this.txtJavadoc.setText(stringArray[0]);
        }
    }

    private void btnSourceActionPerformed(ActionEvent actionEvent) {
        FileChooser fileChooser = new FileChooser(this.helper, true);
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)fileChooser, null);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogTitle(NbBundle.getMessage(EditJarPanel.class, (String)"LBL_Edit_Jar_Panel_browse"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter((FileFilter)new SimpleFileFilter("Source Entry (folder, ZIP or JAR file)", new String[]{"ZIP", "JAR"}));
        File file = this.helper.resolveFile(this.item.getJarFile());
        fileChooser.setCurrentDirectory(file);
        int n = fileChooser.showOpenDialog((Component)SwingUtilities.getWindowAncestor(this));
        if (n == 0) {
            String[] stringArray;
            try {
                stringArray = fileChooser.getSelectedPaths();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return;
            }
            this.txtSource.setText(stringArray[0]);
        }
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String string, String[] stringArray) {
            this.description = string;
            this.extensions = Arrays.asList(stringArray);
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            int n = string.lastIndexOf(46);
            if (n <= 0 || n == string.length() - 1) {
                return false;
            }
            String string2 = string.substring(n + 1).toUpperCase();
            return this.extensions.contains(string2);
        }

        public String getDescription() {
            return this.description;
        }
    }
}

