/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.i18n.wizard.SourceData;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.loaders.DataObject;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class I18nWizardDescriptor
extends WizardDescriptor {
    public static final Dimension PREFERRED_DIMENSION = new Dimension(500, 300);
    private final WizardDescriptor.Iterator<Settings> panels;
    private final Settings settings;
    private final JButton nextButton = new JButton();
    private final JButton previousButton = new JButton();
    private final JButton finishButton = new JButton();
    private final JButton cancelButton = new JButton();
    private PropertyChangeListener rootListener;

    private I18nWizardDescriptor(WizardDescriptor.Iterator<Settings> iterator, Settings settings) {
        super(iterator, (Object)settings);
        Listener listener = new Listener();
        Mnemonics.setLocalizedText((AbstractButton)this.nextButton, (String)NbBundle.getMessage(I18nWizardDescriptor.class, (String)"CTL_Next"));
        this.nextButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(I18nWizardDescriptor.class, (String)"ACSD_NEXT"));
        Mnemonics.setLocalizedText((AbstractButton)this.previousButton, (String)NbBundle.getMessage(I18nWizardDescriptor.class, (String)"CTL_Previous"));
        this.previousButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(I18nWizardDescriptor.class, (String)"ACSD_PREVIOUS"));
        Mnemonics.setLocalizedText((AbstractButton)this.finishButton, (String)NbBundle.getMessage(I18nWizardDescriptor.class, (String)"CTL_Finish"));
        this.finishButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(I18nWizardDescriptor.class, (String)"ACSD_FINISH"));
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(I18nWizardDescriptor.class, (String)"CTL_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(I18nWizardDescriptor.class, (String)"ACSD_CANCEL"));
        this.nextButton.addActionListener(listener);
        this.previousButton.addActionListener(listener);
        this.finishButton.addActionListener(listener);
        this.cancelButton.addActionListener(listener);
        this.setOptions(new Object[]{this.previousButton, this.nextButton, this.finishButton, this.cancelButton});
        this.setClosingOptions(new Object[]{this.cancelButton});
        this.panels = iterator;
        this.settings = settings;
    }

    static WizardDescriptor createI18nWizardDescriptor(WizardDescriptor.Iterator<Settings> iterator, Settings settings) {
        return new I18nWizardDescriptor(iterator, settings);
    }

    protected synchronized void updateState() {
        super.updateState();
        WizardDescriptor.Panel panel = this.panels.current();
        boolean bl = this.panels.hasNext();
        boolean bl2 = this.panels.hasPrevious();
        boolean bl3 = panel.isValid();
        this.nextButton.setEnabled(bl && bl3);
        this.previousButton.setEnabled(bl2);
        this.finishButton.setEnabled(bl3 && (!bl || panel instanceof WizardDescriptor.FinishablePanel && ((WizardDescriptor.FinishablePanel)panel).isFinishPanel()));
        if (bl) {
            this.setValue(this.nextButton);
        } else {
            this.setValue(this.finishButton);
        }
        this.setHelpCtx(panel.getHelp());
        this.updateDefaultButton();
    }

    private void updateDefaultButton() {
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane == null) {
            return;
        }
        WizardDescriptor.Panel panel = this.panels.current();
        if (panel instanceof WizardDescriptor.FinishablePanel && ((WizardDescriptor.FinishablePanel)panel).isFinishPanel()) {
            jRootPane.setDefaultButton(this.finishButton);
        } else {
            jRootPane.setDefaultButton(this.nextButton);
        }
    }

    private JRootPane getRootPane() {
        JRootPane jRootPane = null;
        Component component = this.panels.current().getComponent();
        if (component instanceof JComponent) {
            jRootPane = ((JComponent)component).getRootPane();
        }
        if (jRootPane != null && this.rootListener == null) {
            this.rootListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Object object;
                    if ("defaultButton".equals(propertyChangeEvent.getPropertyName()) && (object = propertyChangeEvent.getNewValue()) != I18nWizardDescriptor.this.nextButton && object != I18nWizardDescriptor.this.finishButton) {
                        RequestProcessor.getDefault().post(new Runnable(){

                            public void run() {
                                I18nWizardDescriptor.this.updateDefaultButton();
                            }
                        });
                    }
                }
            };
            jRootPane.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.rootListener, (Object)jRootPane));
        }
        return jRootPane;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Settings {
        public Map<DataObject, SourceData> map;
        public Project project;

        public Settings(Map<DataObject, SourceData> map, Project project) {
            this.map = map;
            this.project = project;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Panel
    implements WizardDescriptor.Panel<Settings> {
        private Component component;
        private ChangeListener changeListener;
        private Settings settings = null;

        public final synchronized Component getComponent() {
            if (this.component == null) {
                this.component = this.createComponent();
            }
            return this.component;
        }

        protected abstract Component createComponent();

        public boolean isValid() {
            return true;
        }

        public void readSettings(Settings settings) {
            this.settings = settings;
        }

        public void storeSettings(Settings settings) {
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeListener = changeListener;
        }

        public void removeChangeListener(ChangeListener changeListener) {
            if (this.changeListener != null && this.changeListener == changeListener) {
                this.changeListener = null;
            }
        }

        public final void fireStateChanged() {
            if (this.changeListener != null) {
                this.changeListener.stateChanged(new ChangeEvent(this));
            }
        }

        public Project getProject() {
            return this.settings.project;
        }

        public Map<DataObject, SourceData> getMap() {
            return this.settings.map;
        }
    }

    public static interface ProgressMonitor {
        public void doLongTimeChanges();

        public void reset();
    }

    private abstract class ProgressThread
    implements Runnable {
        private ProgressMonitor progressMonitor;

        public ProgressThread(ProgressMonitor progressMonitor) {
            this.progressMonitor = progressMonitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                I18nWizardDescriptor.this.previousButton.setEnabled(false);
                I18nWizardDescriptor.this.nextButton.setEnabled(false);
                I18nWizardDescriptor.this.finishButton.setEnabled(false);
                I18nWizardDescriptor.this.cancelButton.setEnabled(false);
                this.progressMonitor.doLongTimeChanges();
                this.handleAction();
            }
            finally {
                this.progressMonitor.reset();
                I18nWizardDescriptor.this.cancelButton.setEnabled(true);
            }
        }

        public abstract void handleAction();
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == I18nWizardDescriptor.this.nextButton) {
                WizardDescriptor.Panel panel = I18nWizardDescriptor.this.panels.current();
                if (panel instanceof ProgressMonitor) {
                    RequestProcessor.getDefault().post((Runnable)new ProgressThread((ProgressMonitor)panel){

                        public void handleAction() {
                            Listener.this.handleNextButton();
                        }
                    });
                } else {
                    this.handleNextButton();
                }
            } else if (actionEvent.getSource() == I18nWizardDescriptor.this.previousButton) {
                I18nWizardDescriptor.this.panels.previousPanel();
                I18nWizardDescriptor.this.updateState();
            } else if (actionEvent.getSource() == I18nWizardDescriptor.this.finishButton) {
                final WizardDescriptor.Panel panel = I18nWizardDescriptor.this.panels.current();
                panel.storeSettings((Object)I18nWizardDescriptor.this.settings);
                I18nWizardDescriptor.this.setValue(NotifyDescriptor.OK_OPTION);
                if (panel instanceof ProgressMonitor) {
                    RequestProcessor.getDefault().post((Runnable)new ProgressThread((ProgressMonitor)panel){

                        public void handleAction() {
                            Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, panel.getComponent());
                            dialog.setVisible(false);
                            dialog.dispose();
                        }
                    });
                }
            } else if (actionEvent.getSource() == I18nWizardDescriptor.this.cancelButton) {
                I18nWizardDescriptor.this.panels.current().storeSettings((Object)I18nWizardDescriptor.this.settings);
                I18nWizardDescriptor.this.setValue(NotifyDescriptor.CANCEL_OPTION);
            }
        }

        private void handleNextButton() {
            Runnable runnable = new Runnable(){

                public void run() {
                    I18nWizardDescriptor.this.panels.nextPanel();
                    try {
                        I18nWizardDescriptor.this.updateState();
                    }
                    catch (IllegalStateException illegalStateException) {
                        I18nWizardDescriptor.this.panels.previousPanel();
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)illegalStateException.getMessage()));
                        I18nWizardDescriptor.this.updateState();
                    }
                    WizardDescriptor.Panel panel = I18nWizardDescriptor.this.panels.current();
                    panel.getComponent().requestFocus();
                }
            };
            Mutex.EVENT.writeAccess(runnable);
        }
    }
}

