/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.propertysupport.customizers;

import java.util.EventObject;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyDefinition;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyElement;
import org.netbeans.modules.uml.propertysupport.DefinitionPropertyBuilder;
import org.netbeans.modules.uml.propertysupport.customizers.PropertyDataFormatter;

public class ListCellEditor
extends DefaultCellEditor {
    private IPropertyElement mElement = null;
    private boolean mIsInitialized = false;

    public ListCellEditor() {
        this(new JComboBox());
    }

    public ListCellEditor(JComboBox jComboBox) {
        super(jComboBox);
        jComboBox.setBorder(null);
        jComboBox.setEditable(true);
        this.delegate = new PropertyElementListDelegate(this.delegate);
    }

    class PropertyElementListDelegate
    extends DefaultCellEditor.EditorDelegate {
        private DefaultCellEditor.EditorDelegate mEditorDelegate;
        private boolean mInitializing;

        public PropertyElementListDelegate(DefaultCellEditor.EditorDelegate editorDelegate) {
            super(ListCellEditor.this);
            this.mEditorDelegate = null;
            this.mInitializing = false;
            this.mEditorDelegate = editorDelegate;
        }

        public Object getCellEditorValue() {
            Object object = this.mEditorDelegate.getCellEditorValue();
            return object;
        }

        public boolean stopCellEditing() {
            if (ListCellEditor.this.mElement != null && !this.mInitializing) {
                String string = (String)this.getCellEditorValue();
                ListCellEditor.this.mElement.setValue(PropertyDataFormatter.translateToFullyQualifiedName(string));
                ListCellEditor.this.mElement = null;
            }
            this.mInitializing = false;
            return this.mEditorDelegate.stopCellEditing();
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public void setValue(Object object) {
            Object object2 = object;
            if (object instanceof IPropertyElement) {
                ListCellEditor.this.mElement = (IPropertyElement)object;
                object2 = ListCellEditor.this.mElement.getValue();
                this.initializeList();
            }
            this.mInitializing = true;
            if (object2 instanceof String) {
                object2 = PropertyDataFormatter.translateFullyQualifiedName((String)object2);
                this.mEditorDelegate.setValue(object2);
            } else {
                this.mEditorDelegate.setValue(object2);
            }
        }

        protected void initializeList() {
            if (!ListCellEditor.this.mIsInitialized && ListCellEditor.this.mElement != null) {
                this.mInitializing = true;
                JComboBox jComboBox = (JComboBox)ListCellEditor.this.getComponent();
                if (ListCellEditor.this.mElement != null) {
                    IPropertyDefinition iPropertyDefinition = ListCellEditor.this.mElement.getPropertyDefinition();
                    DefinitionPropertyBuilder definitionPropertyBuilder = DefinitionPropertyBuilder.instance();
                    DefinitionPropertyBuilder.ValidValues validValues = definitionPropertyBuilder.retrieveValidValues(iPropertyDefinition, ListCellEditor.this.mElement);
                    if (validValues != null) {
                        String[] stringArray;
                        String string = ListCellEditor.this.mElement.getValue();
                        Vector<String> vector = new Vector<String>();
                        int n = jComboBox.getItemCount();
                        for (int i = 0; i < n; ++i) {
                            vector.add((String)jComboBox.getItemAt(i));
                        }
                        for (String string2 : stringArray = validValues.getValidValues()) {
                            if (vector.contains(string2)) continue;
                            String string3 = PropertyDataFormatter.translateFullyQualifiedName(string2);
                            vector.add(string3);
                            jComboBox.addItem(string3);
                        }
                        int n2 = vector.indexOf(PropertyDataFormatter.translateFullyQualifiedName(string));
                        if (n2 > 0) {
                            jComboBox.setSelectedIndex(n2);
                            ListCellEditor.this.delegate.setValue(PropertyDataFormatter.translateFullyQualifiedName(string));
                        }
                    }
                }
                this.mInitializing = false;
                ListCellEditor.this.mIsInitialized = true;
            }
        }
    }
}

